/**
* @file SplashScreenDlg.h
*
* Declaration of class CSplashScreenDlg
*
* @author Martin Ltzsch
*/

#ifndef __SplashScreenDlg_h__
#define __SplashScreenDlg_h__

#include "resource.h"

/**
* @class CSplashScreenDlg
*
* Displays the splash screen at the start of RobotControl
*
* @author Martin Ltzsch
*/
class CSplashScreenDlg : public CDialog
{
public:
  /** the constructor. */
  CSplashScreenDlg(CWnd* pParent = NULL);
  
  /** Sets the boot message which is displayed on the splash screen */
  void setMessage(CString message);
  //{{AFX_DATA(CSplashScreenDlg)
  enum { IDD = IDD_DIALOG_SPLASH_SCREEN };
  CStatic  m_configurationStatic;
  CStatic  m_messageStatic;
  CStatic  m_copyrightStatic;
  //}}AFX_DATA
  
  //{{AFX_VIRTUAL(CSplashScreenDlg)
protected:
  virtual void DoDataExchange(CDataExchange* pDX);
  //}}AFX_VIRTUAL
  
protected:
  //{{AFX_MSG(CSplashScreenDlg)
  virtual BOOL OnInitDialog();
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP();

  CFont smallFont;
};

#endif // __SplashScreenDlg_h__

/*
* Change log :
* 
* $Log: SplashScreenDlg.h,v $
* Revision 1.2  2003/12/18 13:54:22  jhoffman
* fixed font size for splash screen
*
* Revision 1.1  2003/12/15 13:05:04  loetzsch
* RobotControl now displays a splash screen at the beginning
*
*/
