/**
* @file XABSL2ProfilerDlgBar.h
* Declaration of class CXABSL2ProfilerDlgBar.
* @author Michael Spranger
*/

#ifndef __Xabsl2ProfilerDlgBar_h_
#define __Xabsl2ProfilerDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"
#include "Tools/Module/SolutionRequest.h"

#include "Modules/BehaviorControl/ATH2004ERS7BehaviorControl/ATH2004ERS7Xabsl2Profiler.h"

/**
* @class CXABSL2ProfilerDlgBar
*
* DialogBar for presenting logfiles recorded by the XabslProfiler
* @author Michael Spranger
*/
class CXABSL2ProfilerDlgBar : public CRobotControlDialogBar
{

// Construction
  CEdit m_ParamFramenumberEdit;
  CSliderCtrl m_SliderFrameNumber;
  CSliderCtrl m_SliderColumns;

  ATH2004ERS7Xabsl2Profiler profiler;
  int currentlogentryindex;
public:
	CXABSL2ProfilerDlgBar(CWnd* pParent = NULL);   // standard constructor
  ~CXABSL2ProfilerDlgBar();
  enum FontType{normal, bold, italic};

// Dialog Data
	//{{AFX_DATA(CXABSL2ProfilerDlgBar)
	enum { IDD = IDD_DIALOG_BAR_XABSL2PROFILER };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CXABSL2ProfilerDlgBar)
	public:
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);
  virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CXABSL2ProfilerDlgBar)
	afx_msg void OnXabsl2profilerLoadlogButton();
	afx_msg void OnXabsl2profilerExportxmlButton();
	afx_msg void OnChangeXabsl2profilerFramenumberEdit();
//	afx_msg void OnReleasedcaptureXabsl2profilerSlider(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnPaint();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
  afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
  afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
  afx_msg void OnMouseMove(UINT nFlags, CPoint point);
  //}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
  /** the rectangle in the dialog for painting */
  CRect paintRect;

  /** the rectangle in the bitmap for painting */
  CRect currentRect;

  /** An off screen device context for painting*/
  CDC dcOffScreen;
  
  /** A bitmap that is selected by dcOffScreen*/
  CBitmap* bmpOffScreen;

  /** The old bitmap that is selected by dcOffScreen at the end to enable
  *   the destruction of bmpOffScreen.
  */
  CBitmap* oldBitmap;

  int admOffset;

  
	BOOL m_LeftButtonDown;
  int m_LeftDownPos;
  int m_SelectedColumn;
  
  /** 
  * Draws a text to dcOffScreen.
  * @param fontType The type of the font. (normal, bold, italic)
  * @param line The line to paint to.
  * @param column The column to paint to.
  * @param string The text to paint.
  */
  void drawText(FontType fontType, int line, int column, CString string);

  void drawRectangle(COLORREF color , int line, int column);

  void drawHorizontalLines();
  CArray<int,int> horizontalLineList;

  void drawVerticalLines();
  struct VerticalLine
  {
    VerticalLine(int column, int begin, int end) : column(column), begin(begin), end(end) {}
    VerticalLine() {}
    int column;
    int begin;
    int end;
  };
  CArray<VerticalLine,VerticalLine> verticalLineList;

  /** 
  * Draws a text to dcOffScreen.
  * @param fontType The type of the font. (normal, bold, italic)
  * @param line The line to paint to.
  * @param x The x position to paint to.
  * @param string The string to paint.
  */
  // void drawTextFixedX(FontType fontType, int line, int x, CString string);

  /** creates some Fonts*/
  void createFonts();

  /** deletes the fonts*/
  void deleteFonts();

  /** The old font is selected to the dcOffScreen at the end to 
  *   enable the destruction of the fonts created by create fonts.
  */
  CFont* oldFont;

  /** */
  CFont normalFont;

  /** */
  CFont italicFont;
  
  /** */
  CFont boldFont;

  /** */
  int numberOfColumns;

  /** The relative postion of the columns*/
  // double leftOfColumnPercent;

  int* leftOfColumnWidth;

  /** The position of the columns calculated by OnSize*/
  int* leftOfColumnPosition;

  int showParamsForEntry;

  int minDistanceBetweenColumns;

  /** The number of lines (calculated in OnSize)*/
  int numberOfLines;

  int nrofdispayableOptionGraphs;
  int linesInGrid;

  /** The heiht of a single line*/
  int lineHeight;

  int horizontalTextOffset;

  /** The horizontal spacing of the drawing area.*/
  int horizontalSpacing;
  void OnSize(UINT nType, int cx, int cy);

  /** helper */
  void calcLeftOfColumnPosition();
  void CXABSL2ProfilerDlgBar::calcLeftOfColumnWidth();
  void CXABSL2ProfilerDlgBar::updateLeftOfColumnWidth(int,int);
  void CXABSL2ProfilerDlgBar::updateLeftOfColumnWidth();

  
  void setSliders();
  int columnsOffset;
  void setNrOfColumns(int size);
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif


/*
 * Change log :
 * 
 * $Log: XABSL2ProfilerDlgBar.h,v $
 * Revision 1.5  2004/05/22 16:58:04  spranger
 * changed dialog appearance, added features (including extended profiler-interface)
 *
 * Revision 1.4  2004/05/04 15:36:38  spranger
 * added columnsslider, destructor, framenumber
 *
 * Revision 1.3  2004/05/04 09:24:08  juengel
 * change log added
 *
 *
*/

