// XABSL2ProfilerDlgBar.cpp : implementation file
//

#include "StdAfx.h"
#include "XABSL2ProfilerDlgBar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CXABSL2ProfilerDlgBar dialog


CXABSL2ProfilerDlgBar::CXABSL2ProfilerDlgBar(CWnd* pParent /*=NULL*/)
	: CRobotControlDialogBar(IDD), profiler(), leftOfColumnPosition(NULL), columnsOffset(0), admOffset(20), nrofdispayableOptionGraphs(0), linesInGrid(2), horizontalTextOffset(3), m_LeftButtonDown(false) ,m_SelectedColumn(-1), leftOfColumnWidth(NULL), minDistanceBetweenColumns(4), showParamsForEntry(-1)
{
	//{{AFX_DATA_INIT(CXABSL2ProfilerDlgBar)
	//}}AFX_DATA_INIT
  
  bmpOffScreen = NULL;
  oldBitmap = NULL;
  lineHeight = 13;
  horizontalSpacing = 10;

  setNrOfColumns(1);
  
}

CXABSL2ProfilerDlgBar::~CXABSL2ProfilerDlgBar(){
   if(leftOfColumnPosition){
    delete[] leftOfColumnPosition;
  }
  if(leftOfColumnWidth){
    delete[] leftOfColumnWidth;
  }
   if(bmpOffScreen){
    delete bmpOffScreen;
   }
}

void CXABSL2ProfilerDlgBar::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CXABSL2ProfilerDlgBar)
  DDX_Control(pDX, IDC_XABSL2PROFILER_FRAMENUMBER_EDIT, m_ParamFramenumberEdit);
  DDX_Control(pDX, IDC_XABSL2PROFILER_SLIDER, m_SliderFrameNumber);
  DDX_Control(pDX, IDC_XABSL2PROFILER_SLIDER2, m_SliderColumns);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CXABSL2ProfilerDlgBar, CDynamicBarDlg)
	//{{AFX_MSG_MAP(CXABSL2ProfilerDlgBar)
	ON_BN_CLICKED(IDC_XABSL2PROFILER_LOADLOG_BUTTON, OnXabsl2profilerLoadlogButton)
	ON_BN_CLICKED(IDC_XABSL2PROFILER_EXPORTXML_BUTTON, OnXabsl2profilerExportxmlButton)
	ON_EN_CHANGE(IDC_XABSL2PROFILER_FRAMENUMBER_EDIT, OnChangeXabsl2profilerFramenumberEdit)
//	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_XABSL2PROFILER_SLIDER, OnReleasedcaptureXabsl2profilerSlider)
  ON_WM_PAINT()
  ON_WM_SIZE()
	ON_WM_HSCROLL()
  ON_WM_LBUTTONDOWN()
  ON_WM_LBUTTONUP()
  ON_WM_MOUSEMOVE()
  
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CXABSL2ProfilerDlgBar::OnInitDialog() 
{
  CDynamicBarDlg::OnInitDialog();
  return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CXABSL2ProfilerDlgBar message handlers

void CXABSL2ProfilerDlgBar::OnXabsl2profilerLoadlogButton() 
{
  CString defaultPath = File::getGTDir();
  defaultPath += "/Config/";
  defaultPath.Replace('/','\\');
  CString pathName = AfxGetApp()->GetProfileString("XABSL2ProfilerDlgBar", "openPath", defaultPath);
  pathName += "*.log";

  CFileDialog fileDialog(true, ".kst",pathName,
    OFN_HIDEREADONLY | OFN_EXPLORER | OFN_ENABLESIZING | OFN_NOCHANGEDIR | OFN_NONETWORKBUTTON
    , "xabsl2 log files (*.log)|*.log", this);

  if (fileDialog.DoModal()==IDOK)
  {
    CString fileName = fileDialog.GetFileName();
    CString pathAndFileName = fileDialog.GetPathName();
    pathName = 
      pathAndFileName.Left(
      pathAndFileName.GetLength() -
      fileName.GetLength()
      );
    AfxGetApp()->WriteProfileString("XABSL2ProfilerDlgBar", "openPath", pathName);
    
    
    if (profiler.importLogFile((LPCTSTR)pathAndFileName)){
      
    }
    else
    {
      CString message;
      message.Format( "File %s not found.", pathAndFileName);
      AfxMessageBox( message, MB_OK);
    }
  }
  CString s;
  if(profiler.size() > 0)
  {
    currentlogentryindex = 0;
    m_SliderFrameNumber.SetRange(0,  profiler.size() - 1, true);
    m_SliderFrameNumber.SetPos(0);
    s.Format( "%d", profiler[currentlogentryindex].framenumber);
  }
  else
  {
    currentlogentryindex = -1;
    m_SliderFrameNumber.SetRange(-1, -1, true);
    m_SliderFrameNumber.SetPos(-1);
    s = "no log entries";
  }
  m_ParamFramenumberEdit.SetWindowText(s);

  setNrOfColumns(profiler.getMaxDepth()?profiler.getMaxDepth() + 2:1);
  
  if(profiler.getMaxDepth()){
    m_SliderColumns.SetRange(0, profiler.getMaxDepth() - 1); 
    m_SliderColumns.SetPos(0);
  }
  else{
    m_SliderColumns.SetRange(0, 0);
    m_SliderColumns.SetPos(0);
  }
    
  RedrawWindow(NULL, NULL, RDW_INVALIDATE);
}

void CXABSL2ProfilerDlgBar::OnXabsl2profilerExportxmlButton() 
{
   CString defaultPath = File::getGTDir();
  defaultPath += "/Config/";
  defaultPath.Replace('/','\\');
  CString pathName = 
    AfxGetApp()->GetProfileString("XABSL2ProfilerDlgBar", "savePath", defaultPath);
  pathName += "*.xml";

  CFileDialog fileDialog(false, ".xml",pathName,
    OFN_HIDEREADONLY | OFN_EXPLORER | OFN_ENABLESIZING | OFN_NOCHANGEDIR | OFN_NONETWORKBUTTON
    , "xml xabsl2 profiles (*.xml)|*.xml", this);

  if (fileDialog.DoModal()==IDOK)
  {
    CString fileName = fileDialog.GetFileName();
    CString pathAndFileName = fileDialog.GetPathName();
    CString pathName = 
      pathAndFileName.Left(
      pathAndFileName.GetLength() -
      fileName.GetLength()
      );
    AfxGetApp()->WriteProfileString("XABSL2ProfilerDlgBar", "savePath", pathName);
    profiler.exportXMLFile((LPCTSTR)pathAndFileName);
   }

}

void CXABSL2ProfilerDlgBar::OnChangeXabsl2profilerFramenumberEdit() 
{
  CString valueString;
  int temp;
  m_ParamFramenumberEdit.GetWindowText(valueString);
  sscanf(valueString.GetBuffer(valueString.GetLength()), "%d", &(temp));

  currentlogentryindex = profiler.getIndex(temp);
 
  // m_SliderFrameNumber.SetPos(currentframenmb);

  RedrawWindow(NULL, NULL, RDW_INVALIDATE);
}

void CXABSL2ProfilerDlgBar::OnPaint() 
{
  CPaintDC dc(this); // device context for painting
  CBrush backGroundBrush(RGB(255,255,255));
  // CBrush backGroundBrush(RGB(0,0,0));
  dcOffScreen.FillRect(&currentRect, &backGroundBrush);
  dcOffScreen.SetBkMode(TRANSPARENT);

  createFonts();

  horizontalLineList.RemoveAll();
  verticalLineList.RemoveAll();
  

  // begin of drawing section
  int line = 0;
  
  // painting of grid
  for(int gridentry = 0; gridentry < nrofdispayableOptionGraphs; ++gridentry){
    int logEntryIndex;
    
    
    if(currentlogentryindex - gridentry > -1 && currentlogentryindex - gridentry < profiler.size()){
      logEntryIndex = currentlogentryindex - gridentry;
    }
    else{
      break;
    }
    
    ATH2004ERS7Xabsl2LogEntry& logEntry = profiler[logEntryIndex];
    
    CString s; s.Format("%d", logEntry.framenumber);
    drawText(normal, line, 0, s);
    if(logEntryIndex+1 < profiler.size())
      s.Format("%d", profiler[logEntryIndex+1].framenumber - logEntry.framenumber);
    else
      s = "n.a.";
    drawText(normal, line + 1, 0, s );
    
    
    int maxNrOfParameters = 0;
    for(int column = 1; column < numberOfColumns; ++column){
      ATH2004ERS7Xabsl2ActiveOption activeOption;

      
      verticalLineList.Add(VerticalLine(column, line, line+1));
      verticalLineList.Add(VerticalLine(column, line+1, line+2));

      
      drawRectangle(RGB(0,255,0), line, column);
      
      if(profiler.getActiveOption(logEntryIndex, column + columnsOffset, activeOption)){
        
        // drawing of coloured background for particular griditem
        // activeOption before processed
        ATH2004ERS7Xabsl2ActiveOption activeOptionT;
        if(logEntryIndex -1 > -1)
          profiler.getActiveOption(logEntryIndex -1, column + columnsOffset, activeOptionT);
        
        if(activeOptionT.optionNumber != activeOption.optionNumber){
          drawRectangle(RGB(255,0,0), line, column);
        }
        else if(activeOptionT.stateNumber != activeOption.stateNumber){
          drawRectangle(RGB(255,255,0), line, column);
        }
        else if(activeOptionT.parameters != activeOption.parameters){
          drawRectangle(RGB(0,0,255), line, column);
        }
                
        ATH2004ERS7Xabsl2ProfilerNameTableEntry& ntentry = profiler.getNameTableEntry(activeOption.optionNumber);
        drawText(normal, line, column, ntentry.optionName.c_str()); 
        drawText(normal, line+1, column, ntentry.states[activeOption.stateNumber].c_str());

        
        if(showParamsForEntry == gridentry)
        {
          for(int i = 0; i < (int)activeOption.parameters.size(); ++i)
          {
            CString s = ntentry.parameters[i].c_str();
            s += " = ";
            CString sValue; 
            sValue.Format("%f", activeOption.parameters[i]);
            s +=sValue;
            drawText(normal, line+2+i, column, s); 
          }
          if(i > maxNrOfParameters)
          {
            maxNrOfParameters = i;
          }
           
        }
        
        
        
      }
      
    }
    horizontalLineList.Add(line +1);
    line += 2;
    horizontalLineList.Add(line + maxNrOfParameters - 1);
    line += maxNrOfParameters;
  }
  //end of grid-drawing

  drawHorizontalLines();
  drawVerticalLines();
  // end of drawing section
  
  
  
  deleteFonts();
  dc.BitBlt(paintRect.left, paintRect.top, paintRect.right, paintRect.bottom,
    &dcOffScreen, 0, 0, SRCCOPY);
  
}
void CXABSL2ProfilerDlgBar::OnLButtonDown(UINT nFlags, CPoint point){
  int offsetToPreviousC;
  int offsetToNextC;
  for(int i = 1;i < numberOfColumns;++i)
  {
    offsetToPreviousC = (int)(leftOfColumnWidth[i-1]/2);
    offsetToNextC = (int)(leftOfColumnWidth[i]/2);
    if(point.x < leftOfColumnPosition[i] + offsetToNextC &&  point.x > leftOfColumnPosition[i] - offsetToPreviousC)
    {
      m_LeftDownPos = point.x;
      m_SelectedColumn = i;
      m_LeftButtonDown = true;
      SetCapture();
      break;
    }
  }

  CDynamicBarDlg::OnLButtonDown(nFlags, point);
}
void CXABSL2ProfilerDlgBar::OnLButtonUp(UINT nFlags, CPoint point){
  if(m_LeftButtonDown)
  {
    ReleaseCapture();
    m_LeftButtonDown = false;
  }
  
  CDynamicBarDlg::OnLButtonUp(nFlags, point);
}
void CXABSL2ProfilerDlgBar::OnMouseMove(UINT nFlags, CPoint point) 
{
  if(m_LeftButtonDown && numberOfColumns){
    int change = point.x - m_LeftDownPos;
        
    int minXPosition = leftOfColumnPosition[m_SelectedColumn-1] + minDistanceBetweenColumns;
    int maxXPosition = leftOfColumnPosition[m_SelectedColumn] + (currentRect.Width()+1 - minDistanceBetweenColumns - leftOfColumnPosition[numberOfColumns - 1]);

    if(minXPosition > leftOfColumnPosition[m_SelectedColumn]){
      ;; int x = 0+0;;
    }

    if(change < 0 &&  minXPosition > leftOfColumnPosition[m_SelectedColumn] + change)
    {
      change =  minXPosition - leftOfColumnPosition[m_SelectedColumn];
    }
    else if(change > 0 
      && maxXPosition < leftOfColumnPosition[m_SelectedColumn] + change)
    {
      change = maxXPosition - leftOfColumnPosition[m_SelectedColumn];
    }
    
           
    if(change)
    {
      
      for(int i = m_SelectedColumn ; i < numberOfColumns; ++i ){
        leftOfColumnPosition[i] += change;
      }
      updateLeftOfColumnWidth();
        
      m_LeftDownPos = point.x;
      
      RedrawWindow(NULL, NULL, RDW_INVALIDATE);
    }
     
  }
  // show params?
  else if(point.y - admOffset > 0 && point.y < paintRect.Height() && lineHeight)
  {
    int yInCurrentRect = point.y - admOffset;
    showParamsForEntry = ( yInCurrentRect /( lineHeight * linesInGrid)) ;
    SetCapture();
    RedrawWindow(NULL, NULL, RDW_INVALIDATE);
  }
  else if(showParamsForEntry >= 0)
  {
    ReleaseCapture();
    showParamsForEntry = -1;
    RedrawWindow(NULL, NULL, RDW_INVALIDATE);
  }
  
 
  CDynamicBarDlg::OnMouseMove(nFlags, point);
}


void CXABSL2ProfilerDlgBar::OnSize(UINT nType, int cx, int cy) 
{
  
  updateLeftOfColumnWidth(currentRect.Width(), cx);
  calcLeftOfColumnPosition();
  
  paintRect.top = admOffset;
  paintRect.bottom = cy;
  paintRect.left = 0;
  paintRect.right = cx;
  
  currentRect.top = 0;
  currentRect.left = 0;
  currentRect.bottom = paintRect.bottom - paintRect.top;
  currentRect.right = paintRect.right;
  
  numberOfLines = (currentRect.bottom) / lineHeight;
  nrofdispayableOptionGraphs = (int)((double)numberOfLines/(double)linesInGrid);
  
  CPaintDC dc(this); // device context for painting
  
  if(!dcOffScreen)
    dcOffScreen.CreateCompatibleDC(&dc);
  
  if(bmpOffScreen)
  {
    dcOffScreen.SelectObject(oldBitmap);
    bmpOffScreen->DeleteObject();
    delete(bmpOffScreen);
  }
  bmpOffScreen = new CBitmap;
  bmpOffScreen->CreateCompatibleBitmap(
    &dc, paintRect.right, paintRect.bottom - paintRect.top);
  oldBitmap = dcOffScreen.SelectObject(bmpOffScreen);
  
  
  RedrawWindow(NULL, NULL, RDW_INVALIDATE);
  
  CDynamicBarDlg::OnSize(nType,cx,cy);
}

void CXABSL2ProfilerDlgBar::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
  if(pScrollBar == (CScrollBar*)&m_SliderFrameNumber){
    currentlogentryindex = m_SliderFrameNumber.GetPos();
  }
  else
  {
    setNrOfColumns(profiler.getMaxDepth()?profiler.getMaxDepth() + 2 - m_SliderColumns.GetPos():1);
    columnsOffset = m_SliderColumns.GetPos();
  }
  

  setSliders();
  InvalidateRect(NULL,FALSE);
	CDynamicBarDlg::OnHScroll(nSBCode, nPos, pScrollBar);

}


void CXABSL2ProfilerDlgBar::drawText
(
 FontType fontType,
 int line, 
 int column, 
 CString string)
{
  dcOffScreen.SelectObject(&boldFont);
  switch(fontType)
  {
  case normal:
    dcOffScreen.SelectObject(&normalFont);
    break;
  case italic:
    dcOffScreen.SelectObject(&italicFont);
    break;
  case bold:
    dcOffScreen.SelectObject(&boldFont);
    break;
  default:
    dcOffScreen.SelectObject(&normalFont);
    break;
  }
  dcOffScreen.TextOut(leftOfColumnPosition[column] + horizontalTextOffset, currentRect.top + line * lineHeight, string);
}

void CXABSL2ProfilerDlgBar::drawHorizontalLines()
{ 
  CPen pen;
  pen.CreatePen(PS_SOLID, 1, RGB(0,0,0));
  dcOffScreen.SelectObject(&pen);
    
  for(int i = 0; i < horizontalLineList.GetSize(); i++)
  {
    dcOffScreen.MoveTo(currentRect.left, ((horizontalLineList[i] + 1) * lineHeight));
    dcOffScreen.LineTo(currentRect.right, ((horizontalLineList[i] + 1) * lineHeight));
  }
}

void CXABSL2ProfilerDlgBar::drawVerticalLines()
{
  for(int i = 0; i < verticalLineList.GetSize(); i++)
  {
    CPen blackPen; CPen* oldpen;
    blackPen.CreatePen(PS_SOLID, 2, RGB(0,0,0));
    oldpen = dcOffScreen.SelectObject(&blackPen);
    
    dcOffScreen.MoveTo(
      leftOfColumnPosition[verticalLineList[i].column], 
      (verticalLineList[i].begin ) * lineHeight);
    
    dcOffScreen.LineTo(
      leftOfColumnPosition[verticalLineList[i].column], 
      (verticalLineList[i].end ) * lineHeight);
    
    dcOffScreen.SelectObject(oldpen);

  }
}

void CXABSL2ProfilerDlgBar::drawRectangle(COLORREF color , int line, int column){
  CBrush backGroundBrush(color);
  int rightend = column +1 < numberOfColumns? leftOfColumnPosition[column+1] : currentRect.right;
  dcOffScreen.FillRect(
    CRect(leftOfColumnPosition[column],
    currentRect.top + line * lineHeight,
    rightend,
    currentRect.top + line * lineHeight + linesInGrid*lineHeight), 
    &backGroundBrush);
}

void CXABSL2ProfilerDlgBar::createFonts()
{
  normalFont.CreateFont(14,0,0,0,FW_NORMAL,FALSE,FALSE,0,ANSI_CHARSET,
    OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,
    DEFAULT_PITCH | FF_SWISS,"Arial");
  
  italicFont.CreateFont(14,0,0,0,FW_NORMAL,TRUE,FALSE,0,ANSI_CHARSET,
    OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,
    DEFAULT_PITCH | FF_SWISS,"Arial");
  
  boldFont.CreateFont(14,0,0,0,FW_BOLD,FALSE,FALSE,0,ANSI_CHARSET,
    OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,
    DEFAULT_PITCH | FF_SWISS,"Arial");
  
  oldFont = dcOffScreen.SelectObject(&boldFont);
}

void CXABSL2ProfilerDlgBar::deleteFonts()
{
  dcOffScreen.SelectObject(oldFont);
  boldFont.DeleteObject();
  normalFont.DeleteObject();
  italicFont.DeleteObject();
}



void CXABSL2ProfilerDlgBar::setSliders()
{
//  m_SliderFrameNumber.SetPos();
  CString string;
  
  if(currentlogentryindex > -1)
    string.Format ( "%d", profiler[currentlogentryindex].framenumber); 
  else
    string = "no log entries";

  m_ParamFramenumberEdit.SetWindowText(string);
}

void CXABSL2ProfilerDlgBar::setNrOfColumns(int size){
  if(leftOfColumnPosition){
    delete[] leftOfColumnPosition;
  }
  if(leftOfColumnWidth){
    delete[] leftOfColumnWidth;
  }
  numberOfColumns = size;
//  double leftOfColumnPercent = 100/numberOfColumns;
  leftOfColumnWidth = new int[numberOfColumns];
  calcLeftOfColumnWidth();
  leftOfColumnPosition = new int[numberOfColumns]; 
  calcLeftOfColumnPosition();
}


void CXABSL2ProfilerDlgBar::calcLeftOfColumnPosition(){
  ASSERT(leftOfColumnPosition);
  if(currentRect.Width() && numberOfColumns > 0){
    leftOfColumnPosition[0] = 0;
    for(int j = 1; j < numberOfColumns; j++)
    {
      leftOfColumnPosition[j] = (int)(leftOfColumnPosition[j-1] + leftOfColumnWidth[j-1]);
    }
  }
}

void CXABSL2ProfilerDlgBar::calcLeftOfColumnWidth(){
  ASSERT(leftOfColumnWidth);
  double leftOfColumnPercent = 100/numberOfColumns;
  for(int i = 0; i < numberOfColumns; ++i){
    leftOfColumnWidth[i] = (int)(currentRect.Width() * leftOfColumnPercent / 100);
  }
}
void CXABSL2ProfilerDlgBar::updateLeftOfColumnWidth(int oldWidth, int newWidth){
  ASSERT(leftOfColumnWidth);
  double leftOfColumnPercent;
  int constantWidth = leftOfColumnWidth[0];
  int i;
  for(i = 1; i < numberOfColumns; ++i){
    if(leftOfColumnWidth[i] <= minDistanceBetweenColumns){
      constantWidth += leftOfColumnWidth[i];
    }
    
  }
  for(i=1; i < numberOfColumns; ++i){
    if(i == numberOfColumns - 1){
      int zzzzz=0;
    }

    if(leftOfColumnWidth[i] <= minDistanceBetweenColumns){
      leftOfColumnWidth[i] = minDistanceBetweenColumns;
    }
    else
    {
      leftOfColumnPercent = 100 * leftOfColumnWidth[i] / (oldWidth - constantWidth);
      leftOfColumnWidth[i] = (int)((newWidth - constantWidth)  * leftOfColumnPercent / 100);
    }
  }
}
void CXABSL2ProfilerDlgBar::updateLeftOfColumnWidth(){
  for(int i = 0;i < numberOfColumns; ++i){
    leftOfColumnWidth[i] = (i+1 <numberOfColumns ? leftOfColumnPosition[i+1]:currentRect.Width()) - (i?leftOfColumnPosition[i]:0);
  }
}

/*
 * Change log :
 * 
 * $Log: XABSL2ProfilerDlgBar.cpp,v $
 * Revision 1.6  2004/05/22 16:58:04  spranger
 * changed dialog appearance, added features (including extended profiler-interface)
 *
 * Revision 1.5  2004/05/04 15:36:38  spranger
 * added columnsslider, destructor, framenumber
 *
 * Revision 1.4  2004/05/04 09:24:08  juengel
 * change log added
 *
 *
*/
