/**
* @file WorldstatePlayerToolBar.h
* Declaration of class WorldstatePlayerToolBar.
*/

#ifndef _WORLDSTATEPLAYERTOOLBAR_H__
#define _WORLDSTATEPLAYERTOOLBAR_H__

#include "StdAfx.h"
#include "RobotControlToolBar.h"
#include "Tools/MessageQueue/LogPlayer.h"
#include "WorldstateAnalysisDlgBar.h"
#include "WorldstatePlayer.h"

class CLogPlayerToolBar;

class CWorldstatePlayerToolBar : public CRobotControlToolBar  
{
  DECLARE_DYNAMIC( CWorldstatePlayerToolBar );
public:
	CWorldstatePlayerToolBar();
	virtual ~CWorldstatePlayerToolBar();

  /** Initializes the tool bar */
	virtual void Init(); 

  /** 
  * Handles control notifications which arrived in the main frame 
  * @param command The id of the control, menu, accelerator etc.
  * @return If the command was handled.
  */
  virtual bool handleCommand(UINT command);

	/*
	* moves the Slider if WS player is playing
	*/
	virtual void OnIdle();

	/*
	* insert an WS player.  then player can be controled by the Dialog
	*/
	virtual void SetPlayer(WorldstatePlayer* p) {player = p;}

	/*
	* insert a LogPlayToolBar
	*/
	virtual void SetPlayer(CLogPlayerToolBar* p) {m_logplayer = p;}

  /** 
  * Enables the controls in the toolbar. 
  * This function is called from the main window for all controls. 
  * @param pCmdUI An interface to the control that allows enabling/disabling, checking etc.
  */
  virtual void updateUI(CCmdUI* pCmdUI);

	/** 
	* Handles edit change events for the edit control 
	*/
	virtual BOOL OnEditChange(int nID);

  /** Handles selection change events for the combo box */
	virtual BOOL OnSelChange(int nID);

	/** 
	* Handles selection change events for the edit control 
	*/
	virtual bool handleSelChange(UINT nID);
	/** 
	* Handles edit change events for the edit control 
	*/
	virtual bool handleEditChange(UINT nID);

	DECLARE_MESSAGE_MAP()

	
protected:
	/** LogplayerToolbar to Sync Logplayer*/
	CLogPlayerToolBar*	m_logplayer;



  /** A reference to the log player queue in the RobotControl application */
	CWorldstateAnalysisDlgBar* m_worldstateAnalysisDlgBar;
  /** The current log file for playing and recording*/
  CString fileName;
  
  /** Determines if the buttons have a text */
  virtual bool HasButtonText( UINT nID ) {return false;}

  /** Adjusts the speed of the player */
  
  CComboBox speedCombo;
  /** A slider for the position */
  CSliderCtrl worldstatePlayerPosSlider;

  virtual void OnSliderMoved(NMHDR*,LRESULT*);
  
  int lastSpeed;
  int playerPos;
  WorldstatePlayer* player;
  int step;
  int lastSliderPos;

  CEdit	m_edit[5];
  CComboBox m_DummyCombo[5];
};

#endif //_WORLDSTATEPLAYERTOOLBAR_H__

/*
* Change log :
* 
* $Log: WorldstatePlayerToolBar.h,v $
* Revision 1.13  2004/02/28 17:36:19  dueffert
* header and footer now in GT style
*
*
*/
