/**
* @file WorldstatePlayerToolBar.cpp
* 
* implementation of class WorldstatePlayerToolBar.
*
*/

#include "WorldstatePlayerToolBar.h"

//#define USE_GETMESSAGEIDNAME
#include "StdAfx.h"
#include <vfw.h>
#include "RobotControlQueues.h"
#include "LogPlayerToolBar.h"
#include "Tools/Player.h"

IMPLEMENT_DYNAMIC( CWorldstatePlayerToolBar, CToolBarEx )

BEGIN_MESSAGE_MAP(CWorldstatePlayerToolBar, CToolBarEx)
ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_WORLDSTATE_PLAYER_POS, OnSliderMoved)
END_MESSAGE_MAP()

void CWorldstatePlayerToolBar::Init()
{
  static TBBUTTONEX tbButtons[] =
  {
    //{ {  0, IDC_LOGPLAYER_NEW,     TBSTATE_ENABLED, TBSTYLE_BUTTON , 0, 0 }, true },
    { {  1, IDC_WORLDSTATE_PLAYER_OPEN,     TBSTATE_ENABLED, TBSTYLE_BUTTON , 0, 0 }, true },
    { {  0, 0, 0, TBSTYLE_SEP, 0,0 }, true },
    
    { {  9, IDC_WORLDSTATE_PLAYER_SPEED,     TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0 }, true },
    { {  0, 0, 0, TBSTYLE_SEP, 0,0 }, true },
    { {  2, IDC_WORLDSTATE_PLAYER_PLAY,     TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0 }, true },
    { {  3, IDC_WORLDSTATE_PLAYER_STOP,     TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0 }, true },
    { {  4, IDC_WORLDSTATE_PLAYER_PAUSE,     TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0 }, true },
    { {  5, IDC_WORLDSTATE_PLAYER_STEP_BACKWARD,     TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0 }, true },
    { {  6, IDC_WORLDSTATE_PLAYER_STEP_FORWARD,     TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0 }, true },
    { {  0, 0, 0, TBSTYLE_SEP, 0,0 }, true },
    { { 14, IDC_WORLDSTATE_PLAYER_POS, TBSTATE_ENABLED, TBSTYLE_BUTTON,    0 , 0 }, true},
    { {  0, 0, 0, TBSTYLE_SEP, 0,0 }, true },
    { { 14, IDC_WORLDSTATE_LOGFILE1_STARTTIME, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0,0 }, true },
    { { 14, IDC_WORLDSTATE_LOGFILE2_STARTTIME, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0,0 }, true },
    { { 14, IDC_WORLDSTATE_LOGFILE3_STARTTIME, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0,0 }, true },
    { { 14, IDC_WORLDSTATE_LOGFILE4_STARTTIME, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0,0 }, true },
    { { 14, IDC_WORLDSTATE_CAM_STARTTIME, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0,0 }, true },
	//    { {  7, IDC_LOGPLAYER_RECORD,     TBSTATE_ENABLED, TBSTYLE_CHECK, 0, 0 }, true },
    //{ {  8, IDC_LOGPLAYER_SAVE,     TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0 }, true },
    
  };
  
  SetBitmaps( IDB_WORLDSTATEPLAYER, IDB_WORLDSTATEPLAYER_COLD);
  SetButtons( sizeof( tbButtons ) / sizeof( tbButtons[ 0 ] ), tbButtons);
  AddCombo(&speedCombo,IDC_WORLDSTATE_PLAYER_SPEED, 60);
  speedCombo.AddString("400%");
  speedCombo.AddString("200%");
  speedCombo.AddString("100%");
  speedCombo.AddString("50%");
  speedCombo.AddString("25%");
  speedCombo.AddString("10%");
  speedCombo.AddString("5%");
  
  speedCombo.SetCurSel(2);
  
  AddSlider(&worldstatePlayerPosSlider,IDC_WORLDSTATE_PLAYER_POS,90);
  worldstatePlayerPosSlider.SetRange(0,100);
  worldstatePlayerPosSlider.SetPos(0);
  lastSliderPos=0;
  player=0;

//  this->AddEdit(&m_edit,IDC_WORLDSTATE_PLAYER_SPEED,50,0);
  AddEdit(&m_edit[0],IDC_WORLDSTATE_LOGFILE1_STARTTIME,70,&m_DummyCombo[0]);
  AddEdit(&m_edit[1],IDC_WORLDSTATE_LOGFILE2_STARTTIME,70,&m_DummyCombo[1]);
  AddEdit(&m_edit[2],IDC_WORLDSTATE_LOGFILE3_STARTTIME,70,&m_DummyCombo[2]);
  AddEdit(&m_edit[3],IDC_WORLDSTATE_LOGFILE4_STARTTIME,70,&m_DummyCombo[3]);
  AddEdit(&m_edit[4],IDC_WORLDSTATE_CAM_STARTTIME,70,&m_DummyCombo[4]);
  
  
}

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

CWorldstatePlayerToolBar::CWorldstatePlayerToolBar()
{
	m_logplayer = 0;
  
}

CWorldstatePlayerToolBar::~CWorldstatePlayerToolBar()
{
	m_logplayer = 0;
  
}

BOOL CWorldstatePlayerToolBar::OnEditChange(int nID)
{
	if (player == 0)
		return false;
	if (  ( IDC_WORLDSTATE_LOGFILE1_STARTTIME <= nID)
		&&( IDC_WORLDSTATE_CAM_STARTTIME >= nID))
	{
		Player::playerNumber num;
		num = (Player::playerNumber)(nID - IDC_WORLDSTATE_LOGFILE1_STARTTIME);
		char tmp[20];
		m_edit[num].GetWindowText(tmp, 20);
		if (player->setStarttime( num,  tmp))
		{
			TTIME time =  player->getStarttime( num );
			sprintf(tmp, "%08.08i", time);
			m_edit[num].SetWindowText(tmp);
			return true;
		}
	}
	/**/
	/*
	if (  ( IDC_WORLDSTATE_LOGFILE1_STARTTIME <= nID)
		&&( IDC_WORLDSTATE_CAM_STARTTIME >= nID))
	{
		Player::playerNumber num;
		num = (Player::playerNumber)(nID - IDC_WORLDSTATE_LOGFILE1_STARTTIME);
		char tmp[20];
		m_edit[num].GetWindowText(tmp, 20);
		if (tmp[0] == '!')
		{

			unsigned long pos = player->getLogfilePos( num );
//			unsigned long pos = player->getLastLogfilePos( WorldstatePlayer::goalie );
			pos += player->getStarttime( num );
			char tmp2[20];
			sprintf(tmp2,"%i",pos );
			// m_logplayer->playposEdit.SetWindowText(tmp2);
      //
      // Die LogPlayer Toolbar ist auch nur eine Schnittstelle zur Instanz 
      // logPlayer in CRobotControlQueues. 
      // Mit getQueues().logPlayer kommt ihr direkt an den Logplayer ran.
      // Martin
		}
	}
	*/
	return false;
}

bool CWorldstatePlayerToolBar::handleSelChange(UINT nID)
{
	return OnSelChange(nID)!=0;
}
bool CWorldstatePlayerToolBar::handleEditChange(UINT nID)
{
	return OnEditChange(nID)!=0;
}


bool CWorldstatePlayerToolBar::handleCommand(UINT command)
{
	if (player == 0)
		return false;
	switch(command)
	{
		case IDC_WORLDSTATE_PLAYER_PLAY:
			step = 0;
			player->play();
			return true;
 		case IDC_WORLDSTATE_PLAYER_STOP:
			player->stop();
			return true;
        case IDC_WORLDSTATE_PLAYER_PAUSE:
			player->pause();
			return true;
 		case IDC_WORLDSTATE_PLAYER_STEP_BACKWARD:
			player->stepBackward();
			return true;
        case IDC_WORLDSTATE_PLAYER_STEP_FORWARD:
			player->stepForward();
			return true;
        case IDC_WORLDSTATE_PLAYER_OPEN:
			{
			player->load();
			for(int i= 0; i< Player::numOfPlayerNumbers+1; ++i)
			{
				TTIME time =  player->getStarttime( (Player::playerNumber)i );
				char tmp[20];
				sprintf(tmp, "%08.08i", time);
				m_edit[i].SetWindowText(tmp);
			}
			}
			return true;
		default:
			return false;
	}
	
	return TRUE;
}

BOOL CWorldstatePlayerToolBar::OnSelChange(int nID)
{
  switch (nID) {
    
  case IDC_WORLDSTATE_PLAYER_SPEED: {
    CString s;
    speedCombo.GetWindowText(s);
    int speed;
    sscanf(s,"%i%%",&speed);
    player->speed(speed);
    return true;
                                    }
  }
  return false;
}

void CWorldstatePlayerToolBar::OnSliderMoved(NMHDR*,LRESULT*)
{
  int newSliderPos = worldstatePlayerPosSlider.GetPos();
  if (lastSliderPos != newSliderPos)
  {
    player->seekPosPerCent(newSliderPos);
    lastSliderPos = newSliderPos;
    
  }
}

void CWorldstatePlayerToolBar::OnIdle()
{
	if (player==0)
		return;
	++playerPos;
	playerPos %= 100;
	if (player->hasTimeDelay())
	{
		if (speedCombo.GetCurSel()<2)
		{
			speedCombo.SetCurSel(speedCombo.GetCurSel()+1);
			OnSelChange(IDC_WORLDSTATE_PLAYER_SPEED);
			player->pause();
		}
	}
	if (!playerPos)
	{
		worldstatePlayerPosSlider.SetPos( (int) player->getPosPerCent() );
	}
}


void CWorldstatePlayerToolBar::updateUI(CCmdUI* pCmdUI)
{
  if (pCmdUI == 0)
	  return;
  
  if (player==0)
  {
    switch(pCmdUI->m_nID)
    {
    case IDC_WORLDSTATE_PLAYER_PLAY:
 			case IDC_WORLDSTATE_PLAYER_STOP:
      case IDC_WORLDSTATE_PLAYER_PAUSE:
      case IDC_WORLDSTATE_PLAYER_STEP_BACKWARD:
      case IDC_WORLDSTATE_PLAYER_STEP_FORWARD:
      case IDC_WORLDSTATE_PLAYER_OPEN:
      default:
        pCmdUI->Enable(false);
        break;
    }
    return;
  }
  switch (player->getStatus())
  {
		case WorldstatePlayer::deleted:
		case WorldstatePlayer::empty:
			switch(pCmdUI->m_nID)
			{
				case IDC_WORLDSTATE_PLAYER_OPEN:
					pCmdUI->Enable(true);
					return;
				case IDC_WORLDSTATE_PLAYER_PLAY:
 				case IDC_WORLDSTATE_PLAYER_STOP:
				case IDC_WORLDSTATE_PLAYER_PAUSE:
 				case IDC_WORLDSTATE_PLAYER_STEP_BACKWARD:
				case IDC_WORLDSTATE_PLAYER_STEP_FORWARD:
					return;
				default:
//					pCmdUI->Enable(false);
					break;
			}
			break;
		case WorldstatePlayer::initial:
			switch(pCmdUI->m_nID)
			{
				case IDC_WORLDSTATE_PLAYER_PLAY:
				case IDC_WORLDSTATE_PLAYER_OPEN:
					pCmdUI->Enable(true);
					return;
 				case IDC_WORLDSTATE_PLAYER_STEP_BACKWARD:
				case IDC_WORLDSTATE_PLAYER_STEP_FORWARD:
 				case IDC_WORLDSTATE_PLAYER_STOP:
				case IDC_WORLDSTATE_PLAYER_PAUSE:
					pCmdUI->Enable(false);
					return;
				default:
					break;
			}
			break;
		case WorldstatePlayer::paused:
			switch(pCmdUI->m_nID)
			{
 				case IDC_WORLDSTATE_PLAYER_STOP:
				case IDC_WORLDSTATE_PLAYER_PAUSE:
				case IDC_WORLDSTATE_PLAYER_PLAY:
 				case IDC_WORLDSTATE_PLAYER_STEP_BACKWARD:
				case IDC_WORLDSTATE_PLAYER_STEP_FORWARD:
					pCmdUI->Enable(true);
					return;
				case IDC_WORLDSTATE_PLAYER_OPEN:
					pCmdUI->Enable(false);
					return;
				default:
					break;
			}
			break;
		case WorldstatePlayer::playing:
			switch(pCmdUI->m_nID)
			{
				case IDC_WORLDSTATE_PLAYER_PLAY:
				case IDC_WORLDSTATE_PLAYER_OPEN:
					pCmdUI->Enable(false);
					return;
 				case IDC_WORLDSTATE_PLAYER_STOP:
				case IDC_WORLDSTATE_PLAYER_PAUSE:
 				case IDC_WORLDSTATE_PLAYER_STEP_BACKWARD:
				case IDC_WORLDSTATE_PLAYER_STEP_FORWARD:
					pCmdUI->Enable(true);
					return;
				default:
					break;
			}
			break;
		default:
			switch(pCmdUI->m_nID)
			{
				case IDC_WORLDSTATE_PLAYER_PLAY:
 				case IDC_WORLDSTATE_PLAYER_STOP:
				case IDC_WORLDSTATE_PLAYER_PAUSE:
 				case IDC_WORLDSTATE_PLAYER_STEP_BACKWARD:
				case IDC_WORLDSTATE_PLAYER_STEP_FORWARD:
					pCmdUI->Enable(false);
					return;
				case IDC_WORLDSTATE_PLAYER_OPEN:
					pCmdUI->Enable(true);
					return;
				default:
					break;
			}
			break;
	}

}


/**
* Change Log:
*
* $Log: WorldstatePlayerToolBar.cpp,v $
* Revision 1.17  2004/02/28 17:36:19  dueffert
* header and footer now in GT style
*
* Revision 1.16  2003/12/25 13:25:26  hamerla
* Logplayer extension to LogPlayerWithSync
*
* Revision 1.15  2003/12/19 17:37:28  loetzsch
* removed access from the worldstateanalysisdlgbar to the logPlayerToolbar
*
* Revision 1.14  2003/12/19 11:09:27  hamerla
* Logplayer extension  Seek
*
* Revision 1.13  2003/12/11 17:34:00  hamerla
* *** empty log message ***
*
* Revision 1.12  2003/12/09 20:07:12  hamerla
* *** empty log message ***
*
* Revision 1.11  2003/12/06 14:26:52  hamerla
* *** empty log message ***
*
* Revision 1.10  2003/12/06 06:31:20  loetzsch
* no message
*
*/
