#ifndef _WORLDSTATEANALYSISDLGBAR_H__
#define _WORLDSTATEANALYSISDLGBAR_H__

// WorldstateAnalysisDlgBar.h : Header-Datei
#include "StdAfx.h"
#include "RobotControlDialogBar.h"
#include "../Visualization/MoviePlayer.h"
#include "WorldstatePlayerToolBar.h"
#include "WorldstatePlayer.h"
#include "../Visualization/DebugDrawingManager/DebugDrawingManager.h"
#include "../Representations/Cognition/RobotPose.h"
#include "../Representations/Cognition/RobotState.h"
#include "../Representations/Perception/ObstaclesPercept.h"
#include "../Representations/Perception/PSDPercept.h"
#include "../Representations/Cognition/ObstaclesModel.h"
#include "../Representations/Perception/CollisionPercept.h"
#include "../Representations/Perception/LandmarksPercept.h"
#include "../Representations/Perception/BallPercept.h"
#include "../Representations/Perception/PlayersPercept.h"
#include "../Representations/Perception/LinesPercept.h"
#include "../Representations/Cognition/PlayerPoseCollection.h"
#include "../Representations/Cognition/BallModel.h"
#include "Tools/Player.h"

/**
* needed to send Messages form the Logfiles
*/
class CRobotControlMainFrame;

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CWorldstateAnalysisDlgBar 

class CWorldstateAnalysisDlgBar : public CRobotControlDialogBar
{
// Konstruktion
public:
	CWorldstateAnalysisDlgBar();   // Standardkonstruktor
	~CWorldstateAnalysisDlgBar();
	/**
	* not used 
	* edit here for showing WSMessages 
	*/
    virtual bool handleMessage(InMessage& message);

	/**
	*
	*/
	virtual bool handleCommand(UINT command);
	virtual void OnIdle();
	int step;
	int speed;
	WorldstatePlayer* player;

	/**
	* returns the Player.
	* needed in MainFrame too init WorldstatePlayerToolBar
	*/
	WorldstatePlayer* getPlayer();
	/**
	* set the Mainfraims
	* here Messages from the selected Logfiles are send to
	*/
	void setMainFrame(CRobotControlMainFrame* mainframe);

	/**
	* is called from the WorldstatePlayer to send the Message frorm the Logfiles
	* @param message The message to paint.
	* @param num number of the Logfile (Viewport)
	*/
	virtual bool paintMessage(InMessage& message, unsigned int num);
    /** Handles commands. */

// Dialogfelddaten
	//{{AFX_DATA(CWorldstateAnalysisDlgBar)
	enum { IDD = IDD_DIALOG_BAR_WORLDSTATE_ANALYSIS };
		// HINWEIS: Der Klassen-Assistent fgt hier Datenelemente ein
	//}}AFX_DATA

	void setSpeed(int newSpeed);
// berschreibungen
	// Vom Klassen-Assistenten generierte virtuelle Funktionsberschreibungen
	//{{AFX_VIRTUAL(CWorldstateAnalysisDlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung
	virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL

	/** Handles button press events. */
//	virtual BOOL OnCommand(WPARAM nID,LPARAM l);


protected:
	
	MoviePlayer* m_movieplayer;
	// Generierte Nachrichtenzuordnungsfunktionen
	//{{AFX_MSG(CWorldstateAnalysisDlgBar)
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
		// HINWEIS: Der Klassen-Assistent fgt hier Member-Funktionen ein
		//}}AFX_MSG
	DECLARE_MESSAGE_MAP();

    

private:
	void paintDC(CDC* pDC,CRect* rect);
	CRect dcRect;
	double calculateScale(CRect* dcRect,double rotationAngle);
	double scale;
	
	DebugDrawingManager debugDrawingManager;
    CRect rectForMetaFilePlay;
	MessageHandler* m_extmessagehandler;
	CRobotControlMainFrame* m_mainframe;

    RobotPose				robotPose[Player::numOfPlayerNumbers*2];
    Player					gPlayer[Player::numOfPlayerNumbers*2];
    BallModel			ballPosition[Player::numOfPlayerNumbers*2];
    PlayerPoseCollection	playerPoseCollection[Player::numOfPlayerNumbers*2];
    ObstaclesModel			obstaclesModel[Player::numOfPlayerNumbers*2];
    RobotState				robotState[Player::numOfPlayerNumbers*2];
    CameraMatrix			cameraMatrix[Player::numOfPlayerNumbers*2];
    CameraInfo        cameraInfo[Player::numOfPlayerNumbers*2];
    LandmarksPercept		landmarksPercept[Player::numOfPlayerNumbers*2];
    BallPercept				ballPercept[Player::numOfPlayerNumbers*2];
    PlayersPercept			playersPercept[Player::numOfPlayerNumbers*2];
    ObstaclesPercept		obstaclesPercept[Player::numOfPlayerNumbers*2];
    PSDPercept				psdPercept[Player::numOfPlayerNumbers*2];
    CollisionPercept		collisionPercept[Player::numOfPlayerNumbers*2];
    LinesPercept			linesPercept[Player::numOfPlayerNumbers*2];
	unsigned long			worldStateTimestamp[Player::numOfPlayerNumbers*2];

	CDC dcOffScreen;
    int x;
    int y;
    int m_y;
    int m_x;
	CRect rect;
	//int xPos;
	//int yPos;
	int xPos[6];
	int yPos[6];
	int minimumFieldWidth;
	int fieldHeight;
	int fieldWidth;
	int wndWidth;
	int wndHeight;
	double faktor;
	bool listMenu[6][11];
    DebugDrawing paintDrawing(int drawingNr, int num);
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ fgt unmittelbar vor der vorhergehenden Zeile zustzliche Deklarationen ein.

#endif // ndef _WORLDSTATEANALYSISDLGBAR_H__
