// WorldstateAnalysisDlgBar.cpp: Implementierungsdatei
//

#include "StdAfx.h"
#include <vfw.h>
#include "../RobotControl.h"
#include "WorldstateAnalysisDlgBar.h"
#include "RobotControl/Visualization/DrawingMethods.h"
#include "RobotControl/Visualization/PaintMethodsWin32.h"
#include "../RobotControlMessageHandler.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CWorldstateAnalysisDlgBar 


CWorldstateAnalysisDlgBar::CWorldstateAnalysisDlgBar()
: CRobotControlDialogBar(IDD)
{
	//{{AFX_DATA_INIT(CWorldstateAnalysisDlgBar)
		// HINWEIS: Der Klassen-Assistent fgt hier Elementinitialisierung ein
	//}}AFX_DATA_INIT
	
	faktor = 0.8;
	m_movieplayer = 0;
	m_extmessagehandler = 0;
	player = 0;

	for (int i=0; i<5; i++) {
		for (int j=0; j<11; j++) {
			listMenu[i][j]=false;
		}
		listMenu[i][1]=true;
	}
	listMenu[5][1]=false;

	for(i = 0; i < Player::numOfPlayerNumbers*2; ++i)
	{
		worldStateTimestamp[i] = 0;
	}

}

CWorldstateAnalysisDlgBar::~CWorldstateAnalysisDlgBar()
{
	delete player;
	player=0;
}

void CWorldstateAnalysisDlgBar::DoDataExchange(CDataExchange* pDX)
{
	CDynamicBarDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWorldstateAnalysisDlgBar)
		// HINWEIS: Der Klassen-Assistent fgt hier DDX- und DDV-Aufrufe ein
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CWorldstateAnalysisDlgBar, CDynamicBarDlg)
	//{{AFX_MSG_MAP(CWorldstateAnalysisDlgBar)
	ON_WM_PAINT()
	ON_WM_SIZE()
	ON_WM_CONTEXTMENU()
		// HINWEIS: Der Klassen-Assistent fgt hier Zuordnungsmakros fr Nachrichten ein
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CWorldstateAnalysisDlgBar::OnInitDialog()
{
	

	CDynamicBarDlg::OnInitDialog();
    CPaintDC dc(this); // device context for painting
	player = new WorldstatePlayer(getQueues(),this->GetSafeHwnd(),AfxGetInstanceHandle(),this);
	
    dcOffScreen.CreateCompatibleDC(&dc);
	return TRUE;
}

bool CWorldstateAnalysisDlgBar::handleCommand(UINT command)
{
	return false;
	
}

void CWorldstateAnalysisDlgBar::setSpeed(int newSpeed){
//	if (m_movieplayer != 0) m_movieplayer->speed(newSpeed);
}

bool CWorldstateAnalysisDlgBar::handleMessage(InMessage& message)
{
	message.resetReadPosition();
//	paintMessage(message, (WorldstatePlayer::Logfiles)message.getPlayerNumber());
	paintMessage(message, message.getRobotNumber());
	message.resetReadPosition();
  return false;
}



void CWorldstateAnalysisDlgBar::OnIdle()
{
	if (player!=0) player->OnIdle();

}

WorldstatePlayer* CWorldstateAnalysisDlgBar::getPlayer()
{
	return player;
}



bool CWorldstateAnalysisDlgBar::paintMessage(InMessage& message, unsigned int num)
{
	/*
  vorbergehend auser Betrieb
	if (num == WorldstatePlayer::goalie)
	{
		if (m_extmessagehandler!=0)
			m_extmessagehandler->handleMessage(message);
		if (m_mainframe != 0)
		{
			CMessageHandlerForQueueToGUI tmp(*m_mainframe);
			tmp.handleMessage(message);
			message.resetReadPosition();
		}
	}

	/**/
	MessageID id = message.getMessageID();
	switch(id)
	{
		case idPercepts:

		  message.bin >> RECEIVE_PERCEPTS(cameraMatrix[num],cameraInfo[num],ballPercept[num],
			landmarksPercept[num],linesPercept[num],playersPercept[num], obstaclesPercept[num], psdPercept[num], collisionPercept[num]);
      gPlayer[num].setPlayerNumber(message.getPlayerNumber());
      gPlayer[num].setTeamColor(message.getTeamColor());

		  break;

    case idWorldState:
		  message.bin >> RECEIVE_WORLDSTATE(robotPose[num],
            ballPosition[num],playerPoseCollection[num],obstaclesModel[num],robotState[num], cameraMatrix[num], cameraInfo[num]);
			worldStateTimestamp[num] = message.getTimeStamp();

      gPlayer[num].setPlayerNumber(message.getPlayerNumber());
      gPlayer[num].setTeamColor(message.getTeamColor());
			
      /* test */
			if (gPlayer[num].getTeamColor() != gPlayer[num].red)
			{
			  // flip the robot pose 
			  robotPose[num].translation *= -1;
			  robotPose[num].rotation += fromDegrees(180);

			  // flip the ball position
			  ballPosition[num].communicated *=-1;
			  ballPosition[num].seen *=-1;
			}
			/* TEST */
		  break;
	}
	RedrawWindow(NULL, NULL, RDW_INVALIDATE);
	return true;
}


void CWorldstateAnalysisDlgBar::OnPaint() 
{
    CPaintDC dc(this);
	paintDC(&dc,&dcRect);

}

void CWorldstateAnalysisDlgBar::OnSize(UINT nType, int cx, int cy) 
{
	
	dcRect.left=0;
	dcRect.right=cx;
	dcRect.top=0;
	dcRect.bottom=cy;
	wndWidth= cx;
	wndHeight = cy;

		
		fieldWidth = cx /2;
		fieldHeight = cy / 3;
		xPos[0] = fieldWidth/2;
		yPos[0] = fieldHeight/2;
		xPos[1] = xPos[0] + fieldWidth;// 0.9 ;
		yPos[1] = yPos[0];
		xPos[2] = xPos[0];
		yPos[2] = yPos[0] + fieldHeight;// 0.9;
		xPos[3] = xPos[1];
		yPos[3] = yPos[2];
		xPos[4] = xPos[0];
		yPos[4] = yPos[2] + fieldHeight;// 0.9;
		xPos[5] = xPos[3];
		yPos[5] = yPos[4];
		
		scale = min(((double)cx/10000.0),((double)cy/10000.0));
		


    if(player!=0) player->setAppearanceMovieplayer(int(xPos[5] - fieldWidth / 2 * 0.8), int(yPos[5] - fieldHeight / 2 * 0.8), int(fieldWidth*faktor), int(fieldHeight*faktor));


    RedrawWindow(NULL, NULL, RDW_INVALIDATE);
}

void CWorldstateAnalysisDlgBar::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	int whichMenu=-1;
	//WindowPosition
    RECT aRect = {0,0,0,0};
    this->GetWindowRect(&aRect);
	

	//Mouse over field1?
	if ((point.x >= xPos[0]-fieldWidth/2+aRect.left)&&(point.x <= xPos[0]+fieldWidth/2+aRect.left)&&(point.y >= yPos[0]-fieldHeight/2+aRect.top)&&(point.y <= yPos[0]+fieldHeight/2+aRect.top))
	{
		whichMenu=0;
	} else {//Mouse over field2?
		if ((point.x >= xPos[1]-fieldWidth/2+aRect.left)&&(point.x <= xPos[1]+fieldWidth/2+aRect.left)&&(point.y >= yPos[1]-fieldHeight/2+aRect.top)&&(point.y <= yPos[1]+fieldHeight/2+aRect.top))
		{
			whichMenu=1;
		} else {//Mouse over field3?
			if ((point.x >= xPos[2]-fieldWidth/2+aRect.left)&&(point.x <= xPos[2]+fieldWidth/2+aRect.left)&&(point.y >= yPos[2]-fieldHeight/2+aRect.top)&&(point.y <= yPos[2]+fieldHeight/2+aRect.top))
			{
				whichMenu=2;
			} else {//Mouse over field4?
				if ((point.x >= xPos[3]-fieldWidth/2+aRect.left)&&(point.x <= xPos[3]+fieldWidth/2+aRect.left)&&(point.y >= yPos[3]-fieldHeight/2+aRect.top)&&(point.y <= yPos[3]+fieldHeight/2+aRect.top))
				{
					whichMenu=3;
				} else {//Mouse over field5?
					if ((point.x >= xPos[4]-fieldWidth/2+aRect.left)&&(point.x <= xPos[4]+fieldWidth/2+aRect.left)&&(point.y >= yPos[4]-fieldHeight/2+aRect.top)&&(point.y <= yPos[4]+fieldHeight/2+aRect.top))
					{
						whichMenu=4;
					}
				}
			}
		}
	}

	if (whichMenu>-1) {
		
		CMenu menu;
        UINT nFlags = 0;
        VERIFY( menu.CreatePopupMenu() );
        VERIFY( menu.AppendMenu( MF_BYCOMMAND | listMenu[whichMenu][0] ? MF_CHECKED : 0,
		  1, Drawings::getDrawingName(Drawings::fieldPolygons)));
        VERIFY( menu.AppendMenu( MF_BYCOMMAND | listMenu[whichMenu][1] ? MF_CHECKED : 0,
		  2, Drawings::getDrawingName(Drawings::fieldLines)));
        VERIFY( menu.AppendMenu( MF_BYCOMMAND | listMenu[whichMenu][2] ? MF_CHECKED : 0,
		  3, Drawings::getDrawingName(Drawings::percepts_ballFlagsGoalsField)));
        VERIFY( menu.AppendMenu( MF_BYCOMMAND | listMenu[whichMenu][3] ? MF_CHECKED : 0,
		  4, Drawings::getDrawingName(Drawings::worldStateOracle)));
        VERIFY( menu.AppendMenu( MF_BYCOMMAND | listMenu[whichMenu][4] ? MF_CHECKED : 0,
		  5, Drawings::getDrawingName(Drawings::worldState)));
        VERIFY( menu.AppendMenu( MF_BYCOMMAND | listMenu[whichMenu][5] ? MF_CHECKED : 0,
		  6, Drawings::getDrawingName(Drawings::models_obstaclesField)));
        //separator
        UINT nBars = menu.GetMenuItemCount();
        VERIFY( menu.InsertMenu( nBars, MF_BYPOSITION | MF_SEPARATOR ) );

        VERIFY(menu.AppendMenu( MF_BYCOMMAND | listMenu[whichMenu][6] ? MF_CHECKED : 0,
		  7, "select/deselect all"));
  
        UINT nID;

        nID = menu.TrackPopupMenu( TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_RETURNCMD | TPM_NONOTIFY, point.x, point.y, pWnd );

 if (nID>0){
	 if (nID <7) {
		 listMenu[whichMenu][nID-1] = !listMenu[whichMenu][nID-1];
	     RedrawWindow(NULL, NULL, RDW_INVALIDATE);
	 } else {
		 if (listMenu[whichMenu][6]) {
			 for (int k=0; k<7; k++) {
				listMenu[whichMenu][k]=false;
			 }
		 } else {
			 for (int k=0; k<7; k++) {
				listMenu[whichMenu][k]=	true;
			 }
		 }

		 RedrawWindow(NULL, NULL, RDW_INVALIDATE);
	 }
 }
}
  
}

DebugDrawing CWorldstateAnalysisDlgBar::paintDrawing(int drawingNr, int num){
	DebugDrawing drawing;
	if (worldStateTimestamp[num] == 0)
		return drawing;

//paints the drawings
	switch (drawingNr){
			case 0:
//					DrawingMethods::paintFieldPolygons(drawing,gPlayer[num].getTeamColor());
					DrawingMethods::paintFieldPolygons(drawing,gPlayer[num].red);
				break;
			case 1: 
			
					DrawingMethods::paintFieldLines(drawing);
			
				break;
			case 2:
				DrawingMethods::paintPerceptCollectionForFieldView(drawing,
					landmarksPercept[num], ballPercept[num], playersPercept[num],
					obstaclesPercept[num], linesPercept[num], robotPose[num],
					gPlayer[num].getTeamColor());
				break;		
			case 3:
				DrawingMethods::paintWorldState(drawing, robotPose[num], 
					ballPosition[num], playerPoseCollection[num], gPlayer[num].getTeamColor(), 
          worldStateTimestamp[num],false);
				break;
			case 4:
				DrawingMethods::paintWorldState(drawing,robotPose[num],ballPosition[num],
          playerPoseCollection[num],gPlayer[num].getTeamColor(),
          worldStateTimestamp[num],false);
				break;
			case 5:
				DrawingMethods::paintObstaclesModelForFieldView(drawing,obstaclesModel[num],robotPose[num]);
				break;
					
		}

	return drawing;
}

void CWorldstateAnalysisDlgBar::paintDC
(
 CDC* pDC,
 CRect* arect 
 )
{
  int currentWidth;
  int currentHeight;
  currentWidth = (arect->right - arect->left);
  currentHeight = (arect->bottom - arect->top);
  currentWidth = xPos[0]*2;
  currentHeight = yPos[0]*2;

  CDC dcOffScreen; //an in memory device context
  CBitmap bmpOffScreen;
  CBitmap* oldBitmap;

  CDC* tmpdc = &dcOffScreen;

  dcOffScreen.CreateCompatibleDC(pDC);
  bmpOffScreen.CreateCompatibleBitmap(pDC, currentWidth, currentHeight);
  oldBitmap = dcOffScreen.SelectObject(&bmpOffScreen);
 
  CPen noPen;
  CPen* oldPen;
  noPen.CreatePen(PS_NULL, 0 , RGB(0,0,0));
  tmpdc->SetViewportOrg(currentWidth/2,currentHeight/2);
  tmpdc->SetViewportExt(currentWidth,currentHeight);
  
  XFORM xform;
  for (int i = 0;i<6; ++i)
  {
	  //fixes the mirrored worldstate
      xform.eM11 = (FLOAT)cos(0.0);
	  xform.eM12 = (FLOAT)sin(0.0);
      xform.eM21 = (FLOAT)sin(0.0);
      xform.eM22 = (FLOAT)-cos(0.0);
      xform.eDx = 0.0;
      xform.eDy = 0.0;
      SetGraphicsMode(tmpdc->m_hDC, GM_ADVANCED); //needed for SetWorldTransform
      SetWorldTransform(tmpdc->m_hDC, &xform); 
	  tmpdc->SetViewportOrg(currentWidth/2,currentHeight/2);

	  oldPen = dcOffScreen.SelectObject(&noPen);
	  tmpdc->Rectangle(-currentWidth/2, -currentHeight/2, currentWidth/2 + 1, currentHeight/2 + 1);
	  tmpdc->SelectObject(oldPen);

		for (int k=0; k<6; k++) {
			if (listMenu[i][k]) {
				if (i < 4)
				{   //paint Drawings
					PaintMethodsWin32::paintDebugDrawingToCDC(paintDrawing(k,i),*tmpdc ,scale);//paint red;
					PaintMethodsWin32::paintDebugDrawingToCDC(paintDrawing(k,i+Player::numOfPlayerNumbers),*tmpdc ,scale);//paint blue
			
				} else 
					if (i==4) { //paint merged worldstates for field5
					PaintMethodsWin32::paintDebugDrawingToCDC(paintDrawing(k,0),*tmpdc,scale);
					PaintMethodsWin32::paintDebugDrawingToCDC(paintDrawing(k,1),*tmpdc,scale);
					PaintMethodsWin32::paintDebugDrawingToCDC(paintDrawing(k,2),*tmpdc,scale);
					PaintMethodsWin32::paintDebugDrawingToCDC(paintDrawing(k,3),*tmpdc,scale);
				}
			}		
			
		}
	 xform.eM11 = 1.0;xform.eM12 = 0.0;xform.eM21 = 0.0;xform.eM22 = 1.0;
     SetWorldTransform(tmpdc->m_hDC, &xform);

	 tmpdc->SetWindowOrg(0,0);
	 tmpdc->SetViewportOrg(0,0);
	 //writes dc back to the screen
	 pDC->BitBlt(xPos[i]-xPos[0], yPos[i]-yPos[0], currentWidth, currentHeight, &dcOffScreen, 0, 0, SRCCOPY);
  }

  dcOffScreen.SelectObject(oldBitmap);
  dcOffScreen.DeleteDC();

}

void CWorldstateAnalysisDlgBar::setMainFrame(CRobotControlMainFrame* mainframe)
{
	m_mainframe = mainframe;
}





/*
 * Changelog:
 *
 * $Log: WorldstateAnalysisDlgBar.cpp,v $
 * Revision 1.34  2004/01/10 10:09:15  juengel
 * Added CameraInfo to and removed Player from (SEND|RECEIVE)_(PERCEPTS|WORLDSTATE).
 *
 * Revision 1.33  2003/12/17 12:12:28  hamerla
 * Robotnumber statt PlayerNumber
 *
 * Revision 1.32  2003/12/14 10:43:09  hamerla
 * bug resize movieplayer
 *
 * Revision 1.31  2003/12/13 17:03:18  hamerla
 * insert Player color
 *
 * Revision 1.30  2003/12/13 10:39:12  roefer
 * Ambiguous call to functions clarified
 *
 * Revision 1.29  2003/12/12 10:56:48  lohmann
 * Mirrored Worldstate fixed
 * unnecessary comments deleted
 *
 * Revision 1.28  2003/12/12 10:16:05  hamerla
 * added Simulator showings to WorldstateAnalysis
 *
 * Revision 1.27  2003/12/11 17:33:59  hamerla
 * *** empty log message ***
 *
 * Revision 1.26  2003/12/09 20:07:12  hamerla
 * *** empty log message ***
 *
 * Revision 1.25  2003/12/09 18:50:01  loetzsch
 * correct invocation of DrawingMethods::paintWorldState
 *
 * Revision 1.24  2003/12/09 18:11:45  loetzsch
 * Added parameter timestamp to
 * Drawingmethods::paintWorldStateToDebugDrawing
 *
 * Revision 1.23  2003/12/06 14:26:52  hamerla
 * *** empty log message ***
 *
 * Revision 1.22  2003/12/06 06:31:20  loetzsch
 * no message
 *
 * Revision 1.21  2003/12/05 23:14:07  hamerla
 * *** empty log message ***
 *
 * Revision 1.20  2003/12/04 22:56:07  roefer
 * Compatibility with VC2003.NET
 *
 * Revision 1.19  2003/12/03 17:49:26  lohmann
 * WorldstatePlayerDlgBar fixed
 *
 * Revision 1.18  2003/12/03 12:31:34  hamerla
 * no message
 *
 * Revision 1.17  2003/12/02 15:13:14  lohmann
 * WorldstatePlayerDialogChanges
 *
 * Revision 1.16  2003/12/02 14:09:55  hamerla
 * no message
 *
 * Revision 1.15  2003/12/02 13:39:22  hamerla
 * no message
 *
 * Revision 1.14  2003/12/02 11:25:07  hamerla
 * Memory leaks
 *
 * Revision 1.13  2003/12/02 10:25:33  lohmann
 * Some Memory leaks deleted
 * OnContextMenu() and OnPaint() enhanced
 *
 * Revision 1.12  2003/12/01 11:28:27  lohmann
 * Added identifier to fields
 *
 * Revision 1.11  2003/11/28 10:45:14  hamerla
 * no message
 *
 * Revision 1.10  2003/11/28 10:14:13  rossdeutscher
 * Modified resize bahaviour of WorldStateAnalysisDialogBar
 *
 * Revision 1.9  2003/11/27 10:35:23  rossdeutscher
 * no message
 *
 * Revision 1.8  2003/11/26 15:50:11  lohmann
 * WorldStatePlayer Changed
 *
 * Revision 1.7  2003/11/26 15:29:37  lohmann
 * World State Player changed
 *
 * Revision 1.6  2003/11/26 11:18:40  neubach
 * WorldStatePlayer changed
 *
 * Revision 1.5  2003/11/26 10:34:37  lohmann
 * WorldState Player changed
 *
 * Revision 1.4  2003/11/18 16:34:28  dueffert
 * bugs fixed
 *
 * Revision 1.3  2003/11/18 10:58:18  wachter
 * Added changelog
 *
 *
 */
