/**
* @file WLANToolBar.h
* 
* Definition of WLAN toolbar in the RobotControl project.
*
* @author Max Risler, Uwe Dffert
*/

#ifndef __WLANToolBar_h_ 
#define __WLANToolBar_h_ 

#include "StdAfx.h"

#include "RobotControlToolBar.h"
#include "RobotControlPhysicalRobots.h"

const int wlanToolBarMaxNumOfConfigs = 20;

/** A ToolBar for WLAN connection */
class CWLANToolBar: public CRobotControlToolBar
{
  DECLARE_DYNAMIC( CWLANToolBar );
public:
  /** the constructor. */
  CWLANToolBar();
  
  /** the destructor. */
  ~CWLANToolBar();
  
  /** the initialisation. */
  virtual void Init();
  
  /** change the current wlan configuration */
  void changeConfiguration();
  
  /** Select a connected robot fro communication
  * @param red specifies whether to select to a red or blue robot
  * @param number specifies the number of the player number (1..4) to select
  */
  void OnSelect(bool red, int number);
  
  /** Connect or disconnect to all robots
  * @param connect if true connect, if false disconnect
  */
  void OnConnectAll(bool connect);
  
  /** add a new wlan configuration */
  void OnAdd();
  
  /** edit the current wlan configuration */
  void OnEdit();
  
  /** delete the current wlan configuration */
  void OnDelete();
  
  /** 
  * Enables the controls in the toolbar. 
  * This function is called from the main window for all controls. 
  * @param pCmdUI An interface to the control that allows enabling/disabling, checking etc.
  */
  virtual void updateUI(CCmdUI* pCmdUI);
  
  /** 
  * Handles control notifications which arrived in the main frame 
  * @param command The id of the control, menu, accelerator etc.
  * @return If the command was handled.
  */
  virtual bool handleCommand(UINT command);

  /** 
  * Handles selection change events for combo boxes. That function must be called from the 
  * main frame window for all combo boxes of the toolbar. 
  * @param nID the command id of the combo box
  * @return if the message was handled
  */
  virtual bool handleSelChange(UINT nID);
protected:
  
  /** write all or single wlan configuration to the registry */
  void WriteConfigs(int index=-1);
  
  /** read all wlan configurations from the registry */
  void ReadConfigs();
  
  //DirectWlanSendThread* threadToDog;
  //DirectWlanReceiveThread* threadFromDog;
  
  /* the current number of different configurations */
  int numOfConfigs;
  
  /** the different wlan configurations to choose from */
  CRobotControlWLANConfiguration wlanConfig[wlanToolBarMaxNumOfConfigs];
  
  /** this combo box contains the configuration names to choose from */
  CComboBox m_wndWLANCombo;

  /** sets the toolbar images according to configuration */
  void setImages();
  
  /** Determines if the buttons have a text */
  virtual bool HasButtonText( UINT nID );
};

#endif //__WLANToolBar_h_ 

/*
* Change log :
* 
* $Log: WLANToolBar.h,v $
* Revision 1.4  2003/12/13 11:32:07  loetzsch
* renamed WLANConfiguration to CRobotControlWLANConfiguration
* and moved to RobotControlPhysicalRobots.h
*
* Revision 1.3  2003/12/06 17:45:33  loetzsch
* replaced Player::playerRole (goalie, defender, striker1, striker2)
* by Player::playerNumber (one, two, three, four)
*
* Revision 1.2  2003/12/06 06:31:20  loetzsch
* no message
*
* Revision 1.1  2003/10/07 10:09:38  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/25 20:25:05  loetzsch
* removed direct WLAN thread
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.7  2003/05/11 23:46:36  dueffert
* Depend now works with RobotControl too
*
* Revision 1.6  2003/03/28 14:05:53  dueffert
* team wlan support improved
*
* Revision 1.5  2003/03/25 11:46:53  dueffert
* team wlan support improved
*
* Revision 1.4  2003/03/19 09:11:19  dueffert
* team wlan support improved
*
* Revision 1.3  2003/03/13 16:39:46  dueffert
* wlan toolbar can handle teams now
*
* Revision 1.2  2002/09/22 13:46:09  dueffert
* direct wlan removed (still in code as comments)
*
* Revision 1.1  2002/09/10 15:49:05  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.7  2002/09/01 17:19:48  loetzsch
* tidied up the MfcTools/ directory. Created directories
* MfcTools/DockingControlBars and MfcTools/IEStyleToolbars.
*
* Revision 1.6  2002/08/30 21:08:39  dueffert
* documentation improved
*
* Revision 1.5  2002/08/30 17:13:56  dueffert
* doxygen parser bugs fixed, docu added
*
* Revision 1.4  2002/07/23 13:43:37  loetzsch
* - new streaming classes
* - removed many #include statements
* - 5 instead of 3 debug queues in RobotControl
* - exchanged StaticQueue with MessageQueue
* - new debug message handling
* - empty constructors in bars / dialogs
* - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
* - general clean up
*
* Revision 1.3  2002/06/20 23:38:47  dueffert
* player toolbar & wlan toolbar completed
*
* Revision 1.2  2002/06/08 12:57:40  dueffert
* further wlan config functionality added
*
* Revision 1.1.1.1  2002/05/10 12:40:21  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.6  2002/04/24 14:44:41  dueffert
* WLANToolbar saves actual setting in registry
*
* Revision 1.5  2002/04/23 17:45:15  loetzsch
* - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
* - removed Modules Toolbar
* - removed access for dialogs and toolbars to solutionRequest.
* - changed access for dialogs and toolbars to debug queues
* - removed the instance of SolutionRequest in CRobotControlApp
* - only the log player, local processes and the robot put messages into queueToRobotControl
*
* Revision 1.4  2002/02/20 16:08:12  dueffert
* direct wlan connection added, not fully functional yet
*
* Revision 1.3  2002/02/16 20:11:56  dueffert
* direct wlan communication (without Router) added, integration not yet completed
*
* Revision 1.2  2002/01/24 22:57:22  risler
* finished WLAN Toolbar
*
* Revision 1.1  2002/01/24 13:16:02  risler
* added WLAN Toolbar
*
*
*/
