/**
* @file TestDataGeneratorDlgBar.h
*
* Declaration of class CTestDataGeneratorDlgBar
*
* @author Matthias Jngel
*/

#ifndef __TestDataGeneratorDlgBar_h_
#define __TestDataGeneratorDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"

#include "Representations/Perception/Image.h"
#include "Tools/Debugging/GenericDebugData.h"

/**
* The class TestDataGenerator defines static Methods that generate test data
* using the passed parameters.
*
*/
struct TestDataGenerator
{
public:
  enum TestDataType
  {
    showColorSlidesInImage,
      generateBallInImage,
      generateLineInImage,
      testLineClipping,
      testLineClipping2,
//      insert here,
      numberOfTestDataTypes,
      genericDebugData
  };
  // if you add a new test data type, add the name and the generation method
  // in the implementation of the following two functions in 
  // TestDataGenerator.cpp !!!!!

	static void generateTestData(
    TestDataType testDataType, 
    GenericDebugData parameters,
    OutMessage& out 
    );

  static const char* getTestDataTypeName(enum TestDataType testDataType);

private:
// generation methods


  /**Sends the parameters as a message with idSendGenericDebugData. */
  static void generateGenericDebugData( GenericDebugData parameters, OutMessage& out);

  /** 
  * Genrates an image showing all colors of a specified layer in the yuv
  * color space.
  */
  static void generateImageWithYUV_Layer(GenericDebugData parameters, OutMessage& out);

  /**generates an orange ball in a green image*/
  static void generateImageWithBall(GenericDebugData parameters, OutMessage& out);

  /**generates a black line in a white image*/
  static void generateImageWithLine(GenericDebugData parameters, OutMessage& out);

  /** generates a line and clips it with a rectangle */
  static void lineClippingTest(GenericDebugData parameterStruct, OutMessage& out);

  /** generates a line and clips it with a rectangle */
  static void lineClippingTest2(GenericDebugData parameterStruct, OutMessage& out);
  
// help methods
  /**
  * Generates a vertical color slide in an image.
  * @param image The image to modify.
  * @param y1 The y value at the top of the image.
  * @param u1 The u value at the top of the image.
  * @param v1 The v value at the top of the image.
  * @param y2 The y value at the bottom of the image.
  * @param u2 The u value at the bottom of the image.
  * @param v2 The v value at the bottom of the image.
  */
  static void generateColorSlideInImage(
    Image& image,
    int y1, int u1, int v1,
    int y2, int u2, int v2
    );

  /**
  * Generates a circle in an image.
  * @param image The image to modify.
  * @param centerX The x coordinate of the center of the circle.
  * @param centerY The y coordinate of the center of the circle.
  * @param radius The radius of the circle.
  * @param y The y value of the color of the circle.
  * @param u The u value of the color of the circle.
  * @param v The v value of the color of the circle.
  */
  static void generateCircleInImage(
    Image& image,
    int centerX, int centerY, double radius,
    int y, int u, int v
    );

  /**
  * Generates a rectangle in an image.
  * @param image The image to modify.
  * @param left,top,right,bottom The coordinates of the rectangle to generate.
  * @param y The y value of the color of the rectangle.
  * @param u The u value of the color of the rectangle.
  * @param v The v value of the color of the rectangle.
  */
  static void generateRectangleInImage(
    Image& image,
    int left, int top, int right, int bottom,
    int y, int u, int v
    );
};

/** 
 * @class CTestDataGeneratorDlgBar
 * a dialog bar that can generate any type of message and put in into a message queue
 */
class CTestDataGeneratorDlgBar : public CRobotControlDialogBar
{
// Konstruktion
public:
  CTestDataGeneratorDlgBar();   // Standardkonstruktor

  ~CTestDataGeneratorDlgBar();   // Standardkonstruktor

  bool enableDescriptionEdit[10];

  /** 
  * Enables the controls in the toolbar. 
  * This function is called from the main window for all controls. 
  * @param pCmdUI An interface to the control that allows enabling/disabling, checking etc.
  */
  virtual void updateUI(CCmdUI* pCmdUI);

// Dialogfelddaten
	//{{AFX_DATA(CTestDataGeneratorDlgBar)
	enum { IDD = IDD_DIALOG_BAR_TEST_DATA_GENERATOR };
	CEdit	m_descriptionAEdit;
	CEdit	m_descriptionBEdit;
	CEdit	m_descriptionCEdit;
	CEdit	m_descriptionDEdit;
	CEdit	m_descriptionEEdit;
	CEdit	m_descriptionFEdit;
	CEdit	m_descriptionGEdit;
	CEdit	m_descriptionHEdit;
	CEdit	m_descriptionIEdit;
	CEdit	m_descriptionJEdit;
	CButton	m_testOnRobotCheck;
	CEdit	m_minIEdit;
	CEdit	m_minJEdit;
	CEdit	m_minHEdit;
	CEdit	m_minGEdit;
	CEdit	m_minFEdit;
	CEdit	m_minEEdit;
	CEdit	m_minDEdit;
	CEdit	m_minCEdit;
	CEdit	m_minBEdit;
	CEdit	m_minAEdit;
	CEdit	m_maxJEdit;
	CEdit	m_maxIEdit;
	CEdit	m_maxHEdit;
	CEdit	m_maxGEdit;
	CEdit	m_maxFEdit;
	CEdit	m_maxEEdit;
	CEdit	m_maxDEdit;
	CEdit	m_maxCEdit;
	CEdit	m_maxBEdit;
	CEdit	m_maxAEdit;
	CComboBox	m_testDataTypeCombo;
	CButton	m_sendOnChangeCheck;
	CSliderCtrl	m_slider10;
	CSliderCtrl	m_slider9;
	CSliderCtrl	m_slider8;
	CSliderCtrl	m_slider7;
	CSliderCtrl	m_slider6;
	CSliderCtrl	m_slider5;
	CSliderCtrl	m_slider4;
	CSliderCtrl	m_slider3;
	CSliderCtrl	m_slider2;
	CSliderCtrl	m_slider1;
	CEdit	m_valueJEdit;
	CEdit	m_valueIEdit;
	CEdit	m_valueHEdit;
	CEdit	m_valueGEdit;
	CEdit	m_valueFEdit;
	CEdit	m_valueEEdit;
	CEdit	m_valueDEdit;
	CEdit	m_valueCEdit;
	CEdit	m_valueBEdit;
	CEdit	m_valueAEdit;
	//}}AFX_DATA
  


	//{{AFX_VIRTUAL(CTestDataGeneratorDlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung
	//}}AFX_VIRTUAL

// Implementierung
protected:

	//{{AFX_MSG(CTestDataGeneratorDlgBar)
	virtual BOOL OnInitDialog();
	afx_msg void OnSendOnChangeCheck();
	afx_msg void OnSendButton();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnSelchangeTestDataTypeCombo();
	afx_msg void OnChangeDescription();
	afx_msg void OnChangeMinMax();
	afx_msg void OnChangeValue();
	afx_msg void OnTestOnRobotCheck();
	afx_msg void OnDefaultButton();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();

private:
	void setDescription();
	void setSliders();
	void setSliderRanges();
	void saveParameters();
	void loadParameters();
	void generateTestData();

  float min[10];
  float max[10];
  float value[10];
  double scale[10];
  CString description[10];

  TestDataGenerator::TestDataType selectedTestDataType;
  GenericDebugData::GenericDebugDataID selectedGenericDebugDataID;

  bool testOnRobot;
  bool testLocal;

  bool sendOnChange;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ fgt unmittelbar vor der vorhergehenden Zeile zustzliche Deklarationen ein.



#endif // __TestDataGeneratorDlgBar_h_

/*
 * Change log :
 * 
 * $Log: TestDataGeneratorDlgBar.h,v $
 * Revision 1.2  2003/12/06 06:31:20  loetzsch
 * no message
 *
 * Revision 1.1  2003/10/07 10:09:38  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.3  2003/09/26 15:28:24  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.2  2003/09/26 11:40:12  juengel
 * - sorted tools
 * - clean-up in DataTypes
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.9  2003/06/25 18:41:02  juengel
 * Added lineClippingTest2.
 *
 * Revision 1.8  2003/05/11 23:46:35  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.7  2003/02/09 10:05:26  juengel
 * Added default button to TestDataGenerator
 *
 * Revision 1.6  2003/01/30 22:29:30  juengel
 * Added methods getParameterName and getParameterValue to GenericDebugData.
 *
 * Revision 1.5  2003/01/27 14:47:12  juengel
 * TestDataGenerator generates GenericDebugData now.
 *
 * Revision 1.4  2003/01/23 19:08:47  juengel
 * Improved TestDataGeneratorDlg.
 * Removed ParameterStruct.
 * Moved implementation and declaration of TestDataGenerator to
 * TestDataGeneratorDlg.h and TestDataGeneratorDlg.cpp.
 *
 * Revision 1.3  2003/01/17 12:48:18  jhoffman
 * added GenericDebugData
 * changes to the TestDataGenerator towards using sliders, min/max, and other cool stuff
 *
 * Revision 1.2  2002/12/01 17:36:41  juengel
 * TestDataGenerator has 8 sliders now.
 *
 * Revision 1.1  2002/09/10 15:49:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.3  2002/08/30 17:13:56  dueffert
 * doxygen parser bugs fixed, docu added
 *
 * Revision 1.2  2002/07/23 13:43:37  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - empty constructors in bars / dialogs
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 *
 * Revision 1.1.1.1  2002/05/10 12:40:21  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.1  2002/01/22 14:47:59  juengel
 * TestDataGenerator eingefhrt
 *
 *
 */
