/**
* @file TacticDesignerDlgBar.cpp
*
* Implementation of class CTacticDesignerDlgBar
*
* @author Jochen Kerdels
*/

#include "StdAfx.h"
#include "TacticDesignerDlgBar.h"
#include "Tools/DynamicTeamTactic/RateableOptions.h"
#include "Tools/Streams/OutStreams.h"
#include "RobotControlQueues.h"


CTacticDesignerDlgBar::CTacticDesignerDlgBar()
  : CRobotControlDialogBar(IDD)
{
  //{{AFX_DATA_INIT(CTacticDesignerDlgBar)
  //}}AFX_DATA_INIT
  TECount = 0;
}

CTacticDesignerDlgBar::~CTacticDesignerDlgBar()
{
}

BEGIN_MESSAGE_MAP(CTacticDesignerDlgBar, CDynamicBarDlg)
  //{{AFX_MSG_MAP(CTacticDesignerDlgBar)
  ON_NOTIFY( TVN_SELCHANGED   , IDC_TACTICDESIGNER_TREE, onSelChanged)
  ON_NOTIFY( TVN_ENDLABELEDIT , IDC_TACTICDESIGNER_TREE, onItemTextEdited)
  ON_LBN_SELCHANGE(IDC_TACTICDESIGNER_LIST, onListSelChanged)
	ON_BN_CLICKED(IDC_TACTICDESIGNER_ADDBUTTON, OnAddButton)
	ON_BN_CLICKED(IDC_TACTICDESIGNER_DELBUTTON, OnDelButton)
	ON_BN_CLICKED(IDC_TACTICDESIGNER_NEWBUTTON, OnNewButton)
	ON_BN_CLICKED(IDC_TACTICDESIGNER_OPENBUTTON, OnOpenButton)
	ON_BN_CLICKED(IDC_TACTICDESIGNER_SAVEBUTTON, OnSaveButton)
	ON_BN_CLICKED(IDC_TACTICDESIGNER_MERGEBUTTON, OnMergeButton)
	ON_BN_CLICKED(IDC_TACTICDESIGNER_SENDBUTTON, OnSendButton)
	ON_BN_CLICKED(IDC_TACTICDESIGNER_FREEZEBUTTON, OnFreezeButton)
	ON_BN_CLICKED(IDC_TACTICDESIGNER_UNFREEZEBUTTON, OnUnfreezeButton)
  //}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CTacticDesignerDlgBar::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CTacticDesignerDlgBar)
	DDX_Control(pDX, IDC_TACTICDESIGNER_NEWBUTTON , m_new);
	DDX_Control(pDX, IDC_TACTICDESIGNER_OPENBUTTON, m_open);
	DDX_Control(pDX, IDC_TACTICDESIGNER_SAVEBUTTON, m_save);
	DDX_Control(pDX, IDC_TACTICDESIGNER_MERGEBUTTON, m_merge);
	DDX_Control(pDX, IDC_TACTICDESIGNER_SENDBUTTON, m_send);
	DDX_Control(pDX, IDC_TACTICDESIGNER_FREEZEBUTTON, m_freeze);
	DDX_Control(pDX, IDC_TACTICDESIGNER_UNFREEZEBUTTON, m_unfreeze);
	DDX_Control(pDX, IDC_TACTICDESIGNER_ADDBUTTON , m_add);
	DDX_Control(pDX, IDC_TACTICDESIGNER_DELBUTTON , m_del);
	DDX_Control(pDX, IDC_TACTICDESIGNER_TREE      , m_Tree);
	DDX_Control(pDX, IDC_TACTICDESIGNER_LIST      , m_List);
  //}}AFX_DATA_MAP
}

BOOL CTacticDesignerDlgBar::OnInitDialog() 
{
  CDynamicBarDlg::OnInitDialog();

  AddSzControl(m_new,mdNone,mdNone);
  AddSzControl(m_open,mdNone,mdNone);
  AddSzControl(m_save,mdNone,mdNone);
  AddSzControl(m_merge,mdNone,mdNone);
  AddSzControl(m_send,mdNone,mdNone);
  AddSzControl(m_freeze,mdNone,mdNone);
  AddSzControl(m_unfreeze,mdNone,mdNone);

  AddSzControl(m_List,mdResize,mdNone);

  AddSzControl(m_Tree,mdResize,mdResize);

  AddSzControl(m_add,mdResize,mdRepos);
  AddSzControl(m_del,mdRepos,mdRepos);


  root = m_Tree.InsertItem("TacticEntryArray");
  m_Tree.SetItemData(root,-2);
  
  return TRUE;
}

void CTacticDesignerDlgBar::AddFromFile(bool append)
{
  CString defaultPath = File::getGTDir();
  defaultPath += "/Config/";
  defaultPath.Replace('/','\\');
      
  CString pathName = AfxGetApp()->GetProfileString("Tactic Designer", "path", defaultPath);
  pathName += "*.dtt";
      
  CFileDialog fileDialog(true, ".dtt",pathName,
    OFN_HIDEREADONLY | OFN_EXPLORER | OFN_ENABLESIZING | OFN_NOCHANGEDIR | OFN_NONETWORKBUTTON
    , "Tactic Data (*.dtt)|*.dtt||", this);
      
  if (fileDialog.DoModal()==IDOK)
  {
    pathName = fileDialog.GetPathName().Left(
      fileDialog.GetPathName().GetLength() - fileDialog.GetFileName().GetLength());
    AfxGetApp()->WriteProfileString("Tactic Designer", "path", pathName);
       
    TacticEntryArray tacticEntryArray;
  	// Loading the TacticEntryArray
    InBinaryFile stream(fileDialog.GetPathName());
    if (stream.exists())
    {
      stream >> tacticEntryArray;

      if (!append)
      {
        m_Tree.DeleteAllItems();
        root = m_Tree.InsertItem("TacticEntryArray");
        m_Tree.SetItemData(root,-2);
        TECount = tacticEntryArray.entryCount;
      } else TECount += tacticEntryArray.entryCount;

      HTREEITEM tmpitem; 
      HTREEITEM tmpitem2; 
      HTREEITEM tmpitem3;
      HTREEITEM tmpchild;
      int i,j;
      char* tmpstr = new char[20];
      for (int k = 0; k < tacticEntryArray.entryCount; ++k) {
        tmpchild = m_Tree.InsertItem(tacticEntryArray.entrys[k].name,root);
        m_Tree.SetItemData(tmpchild,-4);
        // adding needed Options
        tmpitem2 = m_Tree.InsertItem("needed Options",tmpchild);
        m_Tree.SetItemData(tmpitem2,-1);
        for (i=0; i < Player::numOfPlayerNumbers; ++i) {
          tmpitem = m_Tree.InsertItem(
            RateableOptions::getOptionName(tacticEntryArray.entrys[k].neededOptions[i]),
                                      tmpitem2);
          m_Tree.SetItemData(tmpitem,-3);
          sprintf(tmpstr, "%f", tacticEntryArray.entrys[k].optionWeights[i]);
          tmpstr[4] = 0;
          tmpitem3 = m_Tree.InsertItem(tmpstr,tmpitem);
          m_Tree.SetItemData(tmpitem3,-6);
        }
                 
        // adding allowed Dogs
        tmpitem = m_Tree.InsertItem("allowed Dogs",tmpchild);
        m_Tree.SetItemData(tmpitem,-1);
        for (i=0; i < Player::numOfPlayerNumbers; ++i) {
          sprintf(tmpstr, "allowed Dog %d", i);
          tmpitem2 = m_Tree.InsertItem(tmpstr,tmpitem);
          m_Tree.SetItemData(tmpitem2,-1);
          for (j=0; j <Player::numOfPlayerNumbers; ++j)
            if (tacticEntryArray.entrys[k].allowedDogs[i][j]){
              tmpitem3 = m_Tree.InsertItem("true",tmpitem2);
              m_Tree.SetItemData(tmpitem3,-5);
            } else {
              tmpitem3 = m_Tree.InsertItem("false",tmpitem2);
              m_Tree.SetItemData(tmpitem3,-5);
            }
        }
                 
        // adding weight
        tmpitem = m_Tree.InsertItem("Weight",tmpchild);
        m_Tree.SetItemData(tmpitem,-1);
        sprintf(tmpstr, "%f", tacticEntryArray.entrys[k].weight);
        tmpstr[4] = 0;
        tmpitem2 = m_Tree.InsertItem(tmpstr,tmpitem);
        m_Tree.SetItemData(tmpitem2,-6);
                 
        // adding GlobalAnalysersInfo
        tmpitem = m_Tree.InsertItem("global Analysers Info",tmpchild);
        m_Tree.SetItemData(tmpitem,-1);
        for (i=0; i < RateableOptions::numOfGlobalAnalysers; ++i) {
          tmpitem2 = m_Tree.InsertItem(
             RateableOptions::getGlobalAnalyserName((RateableOptions::GlobalAnalyserID)i),
                                       tmpitem);
          m_Tree.SetItemData(tmpitem2,i);
          tmpitem3 = m_Tree.InsertItem(
                                     RateableOptions::getTETIDName(
                                       tacticEntryArray.entrys[k].globalAnalysersInfo[i]),
                                     tmpitem2);
          m_Tree.SetItemData(tmpitem3,-9);
        }

        // adding following Entries
        for (i=0; i < tacticEntryArray.entrys[k].followingEntryCount; ++i) {
          tmpitem = m_Tree.InsertItem("following Entry",tmpchild);
          m_Tree.SetItemData(tmpitem,-7);
          sprintf(tmpstr, "Tactic Entry %d", tacticEntryArray.entrys[k].followingEntrys[i]);
          tmpitem2 = m_Tree.InsertItem(tmpstr,tmpitem);
          m_Tree.SetItemData(tmpitem2,-8);
          sprintf(tmpstr, "%f", tacticEntryArray.entrys[k].followingEntryWeights[i]);
          tmpstr[4] = 0;
          tmpitem2 = m_Tree.InsertItem(tmpstr,tmpitem);
          m_Tree.SetItemData(tmpitem2,-6);
        }


      }
      m_Tree.Expand(root,TVE_EXPAND);
      delete[] tmpstr;


    }
    else
    {
  		AfxMessageBox("Could not load " + fileDialog.GetPathName());
    }
  }    
}

void CTacticDesignerDlgBar::onSelChanged( NMHDR * pNotifyStruct, LRESULT * result )
{
  HTREEITEM selectedItem = m_Tree.GetSelectedItem();
  if (selectedItem == NULL) {
    m_add.SetWindowText("///");
    m_del.SetWindowText("///");
    m_List.ResetContent();
  } else {
    int seltype = m_Tree.GetItemData(selectedItem);
    switch (seltype) {

      case -2 : { // TacticEntryArray selected
                 m_add.SetWindowText("add tactic entry");
                 m_del.SetWindowText("///");
                 m_List.ResetContent();
               } break;

      case -3 : { // OptionField selected
                 m_add.SetWindowText("///");
                 m_del.SetWindowText("///");
                 m_List.ResetContent();
                 for (int i = 0; i < RateableOptions::maxOptionClassID; ++i)
                   m_List.AddString(RateableOptions::getOptionName(i));
                 m_List.SelectString(-1,m_Tree.GetItemText(selectedItem));
               } break;

      case -4 : { // TacticEntry selected
                 m_add.SetWindowText("insert tactic entry");
                 m_del.SetWindowText("del");
                 m_List.ResetContent();
               } break;

      case -5 : { // true/false selected
                 m_add.SetWindowText("///");
                 m_del.SetWindowText("///");
                 m_List.ResetContent();
                 m_List.AddString("true");
                 m_List.AddString("false");
                 m_List.SelectString(-1,m_Tree.GetItemText(selectedItem));
               } break;

      case -6 : { // some double selected
                 m_add.SetWindowText("///");
                 m_del.SetWindowText("///");
                 m_List.ResetContent();
                 char* tmpstr = new char[10];
                 for (double d = 0; d < 10; d += 0.05) {
                   sprintf(tmpstr, "%f", d);
                   tmpstr[4] = 0;
                   m_List.AddString(tmpstr);
                 }
                 delete[] tmpstr;
                 m_List.SelectString(-1,m_Tree.GetItemText(selectedItem));
               } break;

      case -7 : { // following Entry selected
                 m_add.SetWindowText("///");
                 m_del.SetWindowText("del");
                 m_List.ResetContent();
               } break;

      case -8 : { // following TacticEntry selected
                 m_add.SetWindowText("///");
                 m_del.SetWindowText("///");
                 m_List.ResetContent();
                 HTREEITEM tmpitem = m_Tree.GetChildItem(root);
                 while (tmpitem != NULL) {
                   m_List.AddString(m_Tree.GetItemText(tmpitem));
                   tmpitem = m_Tree.GetNextSiblingItem(tmpitem);
                 }
                 m_List.SelectString(-1,m_Tree.GetItemText(selectedItem));
               } break;

      case -9 : { // globalAnalysersInfo selected
                 m_add.SetWindowText("///");
                 m_del.SetWindowText("///");
                 m_List.ResetContent();
                 HTREEITEM tmpitem = m_Tree.GetParentItem(selectedItem);
                 RateableOptions::GlobalAnalyserID GA = 
                   (RateableOptions::GlobalAnalyserID)(m_Tree.GetItemData(tmpitem));
                 int base  = RateableOptions::getGlobalAnalyserTETBase(GA);
                 int count = RateableOptions::getGlobalAnalyserTETBase(GA) +
                             RateableOptions::getGlobalAnalyserTETCount(GA);
                 for (int i = base; i < count; ++i) {
                   m_List.AddString(RateableOptions::getTETIDName(
                     (RateableOptions::TacticEntryTypeID)i));
                 }
                 m_List.SelectString(-1,m_Tree.GetItemText(selectedItem));
               } break;

      default: {
                 m_add.SetWindowText("///");
                 m_del.SetWindowText("///");
                 m_List.ResetContent();
               }
    } //switch
  } // else
}

void CTacticDesignerDlgBar::onListSelChanged()
{
  HTREEITEM selectedItem = m_Tree.GetSelectedItem();
  int selectedOption = m_List.GetCurSel();
  if ((selectedOption != LB_ERR) && (selectedItem != NULL)) {
    char* tmpstr = new char[50];
    m_List.GetText(selectedOption,tmpstr);
    m_Tree.SetItemText(selectedItem,tmpstr);
    delete[] tmpstr;
  }
}

void CTacticDesignerDlgBar::AddTacticEntry(HTREEITEM insertAfter)
{
   HTREEITEM tmpitem; 
   HTREEITEM tmpitem2; 
   HTREEITEM tmpitem3;
   int i,j;
   char* tmpstr = new char[20];
   sprintf(tmpstr, "Tactic Entry %d", TECount++);
   HTREEITEM tmpchild = m_Tree.InsertItem(tmpstr,root,insertAfter);
   m_Tree.SetItemData(tmpchild,-4);
   // adding needed Options
   tmpitem2 = m_Tree.InsertItem("needed Options",tmpchild);
   m_Tree.SetItemData(tmpitem2,-1);
   for (i=0; i < Player::numOfPlayerNumbers; ++i) {
     tmpitem = m_Tree.InsertItem("DoNothing",tmpitem2);
     m_Tree.SetItemData(tmpitem,-3);
     tmpitem3 = m_Tree.InsertItem("1.00",tmpitem);
     m_Tree.SetItemData(tmpitem3,-6);
   }
 
   // adding allowed Dogs
   tmpitem = m_Tree.InsertItem("allowed Dogs",tmpchild);
   m_Tree.SetItemData(tmpitem,-1);
   for (i=0; i < Player::numOfPlayerNumbers; ++i) {
     sprintf(tmpstr, "allowed Dog %d", i);
     tmpitem2 = m_Tree.InsertItem(tmpstr,tmpitem);
     m_Tree.SetItemData(tmpitem2,-1);
     for (j=0; j <Player::numOfPlayerNumbers; ++j) {
       tmpitem3 = m_Tree.InsertItem("true",tmpitem2);
       m_Tree.SetItemData(tmpitem3,-5);
     }
   }
 
   // adding weight
   tmpitem = m_Tree.InsertItem("Weight",tmpchild);
   m_Tree.SetItemData(tmpitem,-1);
   tmpitem2 = m_Tree.InsertItem("1.00",tmpitem);
   m_Tree.SetItemData(tmpitem2,-6);
 
   // adding GlobalAnalysersInfo
   tmpitem = m_Tree.InsertItem("global Analysers Info",tmpchild);
   m_Tree.SetItemData(tmpitem,-1);
   for (i=0; i < RateableOptions::numOfGlobalAnalysers; ++i) {
     tmpitem2 = m_Tree.InsertItem(
  RateableOptions::getGlobalAnalyserName((RateableOptions::GlobalAnalyserID)i),
                                  tmpitem);
     m_Tree.SetItemData(tmpitem2,i);
     tmpitem3 = m_Tree.InsertItem(
                     RateableOptions::getTETIDName(
                       RateableOptions::getGlobalAnalyserNeutralTETID(
                        (RateableOptions::GlobalAnalyserID)i)),
                     tmpitem2);
     m_Tree.SetItemData(tmpitem3,-9);
   }

   m_Tree.Expand(root,TVE_EXPAND);
   delete[] tmpstr;

}

void CTacticDesignerDlgBar::OnAddButton()
{
  HTREEITEM selectedItem = m_Tree.GetSelectedItem();
  if (selectedItem != NULL)
  {
    int seltype = m_Tree.GetItemData(selectedItem);
    switch (seltype) {

      case -2: { // TacticEntryArray selected, so add a tactic entry
                 AddTacticEntry(TVI_LAST);
               } break;

      case -4: { // TacticEntry selected, so add a tactic entry
                 AddTacticEntry(selectedItem);
               } break;

    
    }  
  }
}


void CTacticDesignerDlgBar::OnDelButton()
{
  HTREEITEM selectedItem = m_Tree.GetSelectedItem();
  if (selectedItem != NULL)
  {
    int seltype = m_Tree.GetItemData(selectedItem);
    switch (seltype) {

      case -4:
      case -7: { 
                 m_Tree.DeleteItem(selectedItem);
               } break;
   
    }  
  }
}

void CTacticDesignerDlgBar::OnNewButton()
{
  m_Tree.DeleteAllItems();
  root = m_Tree.InsertItem("TacticEntryArray");
  m_Tree.SetItemData(root,-2);
}

void CTacticDesignerDlgBar::OnOpenButton()
{
  AddFromFile(false);
}

void CTacticDesignerDlgBar::OnMergeButton()
{
  AddFromFile(true);
}

void CTacticDesignerDlgBar::fillTacticEntry(TacticEntryArray& tacticEntryArray)
{
  HTREEITEM tmpitem;
  HTREEITEM tmpitem2;
  HTREEITEM tmpitem3;
  HTREEITEM tmpchild;

  // setting EntryCount...
  int entryCount = 0;
  tmpitem = m_Tree.GetChildItem(root);
  while (tmpitem != NULL) {
    entryCount++;
    tmpitem = m_Tree.GetNextSiblingItem(tmpitem);
  }

  tacticEntryArray.setEntryCount(entryCount);

  // writing the entries
  int k = -1;
  int i,j;
  tmpchild = m_Tree.GetChildItem(root);
  while (tmpchild != NULL) {
    ++k;
    strcpy(tacticEntryArray.entrys[k].name,m_Tree.GetItemText(tmpchild));
    tmpitem  = m_Tree.GetChildItem(tmpchild); // needed Options
    tmpitem2 = m_Tree.GetChildItem(tmpitem);  // first option
    i = -1;
    while (tmpitem2 != NULL) {
      ++i;
      tacticEntryArray.entrys[k].neededOptions[i] =
        RateableOptions::getOptionID(m_Tree.GetItemText(tmpitem2));
      tmpitem3 = m_Tree.GetChildItem(tmpitem2); // floatvalue
      tacticEntryArray.entrys[k].optionWeights[i] =
        atof(m_Tree.GetItemText(tmpitem3));
      tmpitem2 = m_Tree.GetNextSiblingItem(tmpitem2);
    }


    // maxval
    tacticEntryArray.entrys[k].maxVal = 0;
    for (i = 0; i < Player::numOfPlayerNumbers; ++i)
      tacticEntryArray.entrys[k].maxVal +=
        tacticEntryArray.entrys[k].optionWeights[i] * 100;


    tmpitem = m_Tree.GetNextSiblingItem(tmpitem); // allowed Dogs
    tmpitem2 = m_Tree.GetChildItem(tmpitem);      // first dog
    i = -1;
    while (tmpitem2 != NULL) {
      ++i;
      tmpitem3 = m_Tree.GetChildItem(tmpitem2);   // first bool
      j = -1;
      while (tmpitem3 != NULL) {
        ++j;
        if (strcmp("true",m_Tree.GetItemText(tmpitem3)) == 0)
          tacticEntryArray.entrys[k].allowedDogs[i][j] = true;
        else
          tacticEntryArray.entrys[k].allowedDogs[i][j] = false;

        tmpitem3 = m_Tree.GetNextSiblingItem(tmpitem3);
      }
      tmpitem2 = m_Tree.GetNextSiblingItem(tmpitem2);
    }

    tmpitem = m_Tree.GetNextSiblingItem(tmpitem); // weight
    tmpitem2 = m_Tree.GetChildItem(tmpitem);      // weight value

    tacticEntryArray.entrys[k].weight = atof(m_Tree.GetItemText(tmpitem2));

    tmpitem = m_Tree.GetNextSiblingItem(tmpitem); // globalAnalysersInfo
    tmpitem2 = m_Tree.GetChildItem(tmpitem);      // first engine
    i = -1;
    while (tmpitem2 != NULL) {
      ++i;
      tmpitem3 = m_Tree.GetChildItem(tmpitem2);
      tacticEntryArray.entrys[k].globalAnalysersInfo[i] =
        RateableOptions::getTETID((RateableOptions::GlobalAnalyserID)i,
                                  m_Tree.GetItemText(tmpitem3));

      tmpitem2 = m_Tree.GetNextSiblingItem(tmpitem2);
    }

    tmpitem = m_Tree.GetNextSiblingItem(tmpitem); // first following Option
    tmpitem2 = tmpitem; // backup
    // counting folling options
    i = 0;
    while (tmpitem != NULL) {
      i++; 
      tmpitem = m_Tree.GetNextSiblingItem(tmpitem);
    }

    tmpitem = tmpitem2;
    tacticEntryArray.entrys[k].setFollowingEntryCount(i);
    i = -1;
    while (tmpitem != NULL) {
      ++i; 
      tmpitem2 = m_Tree.GetChildItem(tmpitem); // Name of folling Entry
      // searching the entry..
      tmpitem3 = m_Tree.GetChildItem(root);
      j = -1;
      while (tmpitem3 != NULL) {
        ++j;
        if (strcmp(m_Tree.GetItemText(tmpitem2),m_Tree.GetItemText(tmpitem3)) == 0)
          break;
        tmpitem3 = m_Tree.GetNextSiblingItem(tmpitem3);  
      }
      if ((j >= 0) && (i < tacticEntryArray.entrys[k].followingEntryCount)) {
        tacticEntryArray.entrys[k].followingEntrys[i] = j;
        tmpitem3 = m_Tree.GetNextSiblingItem(tmpitem2); // weight of the entry
        tacticEntryArray.entrys[k].followingEntryWeights[i] = 
          atof(m_Tree.GetItemText(tmpitem3));
      } else { // not found, make a "safe" entry
        tacticEntryArray.entrys[k].followingEntrys[i] = 0;
        tacticEntryArray.entrys[k].followingEntryWeights[i] = 1.0;
      }

      tmpitem = m_Tree.GetNextSiblingItem(tmpitem);
    }



    tmpchild = m_Tree.GetNextSiblingItem(tmpchild);
  }
}

void CTacticDesignerDlgBar::OnSaveButton()
{
  CString defaultPath = File::getGTDir();
  defaultPath += "/Config/";
  defaultPath.Replace('/','\\');
  CString pathName = AfxGetApp()->GetProfileString("Tactic Designer", "path", defaultPath);
  pathName += "*.dtt";
      
  CFileDialog fileDialog(false, ".dtt",pathName,
    OFN_HIDEREADONLY | OFN_EXPLORER | OFN_ENABLESIZING | OFN_NOCHANGEDIR | OFN_NONETWORKBUTTON
    , "Tactic Data (*.dtt)|*.dtt||", this);
  if (fileDialog.DoModal()==IDOK)
  {
    pathName = fileDialog.GetPathName().Left(
      fileDialog.GetPathName().GetLength() - fileDialog.GetFileName().GetLength());
    AfxGetApp()->WriteProfileString("Tactic Designer", "path", pathName);
    if (strcmp(fileDialog.GetFileExt(),"dtt")==0)
    {
      TacticEntryArray tacticEntryArray;
      fillTacticEntry(tacticEntryArray);

      OutBinaryFile stream(fileDialog.GetPathName());
      stream << tacticEntryArray;
    }
    else
    {
  		AfxMessageBox("Could not write " + fileDialog.GetPathName());
    }
  }


}

void CTacticDesignerDlgBar::OnSendButton()
{
  TacticEntryArray tacticEntryArray;
  fillTacticEntry(tacticEntryArray);
  // Sending the tacticEntryArray
  getQueues().toPhysical.allRobots.out.bin << tacticEntryArray;
  getQueues().toPhysical.allRobots.out.finishMessage(idTacticEntryArray);

  getQueues().toSimulated.allRobots.out.bin << tacticEntryArray;
  getQueues().toSimulated.allRobots.out.finishMessage(idTacticEntryArray);
}

void CTacticDesignerDlgBar::OnFreezeButton()
{
  // Sending the freeze message
  getQueues().toPhysical.allRobots.out.bin << (int)true;
  getQueues().toPhysical.allRobots.out.finishMessage(idFreezeRequest);

  getQueues().toSimulated.allRobots.out.bin << (int)true;
  getQueues().toSimulated.allRobots.out.finishMessage(idFreezeRequest);
}

void CTacticDesignerDlgBar::OnUnfreezeButton()
{
  // Sending the unfreeze message
  getQueues().toPhysical.allRobots.out.bin << (int)false;
  getQueues().toPhysical.allRobots.out.finishMessage(idFreezeRequest);

  getQueues().toSimulated.allRobots.out.bin << (int)false;
  getQueues().toSimulated.allRobots.out.finishMessage(idFreezeRequest);
}

void CTacticDesignerDlgBar::onItemTextEdited( NMHDR * pNotifyStruct, LRESULT * result )
{
  (*result) = true;
}

/*
 * Change log :
 * 
 * $Log: TacticDesignerDlgBar.cpp,v $
 * Revision 1.9  2004/02/19 18:11:13  kerdels
 * made a backup of default.dtt in tbaseV3.dtt,
 * added insert functionality to TacticDesigner.
 *
 * Revision 1.8  2004/02/17 19:04:26  kerdels
 * removed save-bug in tacticDesigner,
 * set all TacticEntrys in default.dtt to GoalieCoach::Neutral,
 * commented out some OUPUT stuff in GoalieCoach.cpp
 *
 * Revision 1.7  2004/02/12 20:40:50  kerdels
 * renamed the tactics to .dtt from .dat to prevent confusions
 *
 * Revision 1.6  2004/02/09 13:23:46  kerdels
 * added merge-button
 *
 * Revision 1.5  2004/02/05 17:31:49  kerdels
 * create a base tactics.dat
 *
 * Revision 1.4  2004/01/19 20:13:07  kerdels
 * added name capability to tacticentrys
 *
 * Revision 1.3  2004/01/12 17:17:52  kerdels
 * added freeze functionality to tacticDesigner
 *
 * Revision 1.2  2004/01/07 14:56:09  kerdels
 * added send functionality to TacticDesigner
 *
 * Revision 1.1  2004/01/04 00:08:55  kerdels
 * TacticDesigner hinzugefgt
 *
 */

