/**
* @file TSLColorTableToolDlgBar.h
*
* Declaration of class CTSLColorTableToolDlgBar
*
* @author <a href="mailto:robocup@andreosterhues.de">Andr Osterhues</a>
*/

#ifndef __TSLColorTableToolDlgBar_h_
#define __TSLColorTableToolDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"

#include "Representations/Perception/Image.h"
#include "Representations/Perception/ColorTableTSL.h"
#include "Representations/Perception/ColorTable64.h"
#include "Modules/ImageProcessor/ImageProcessorTools/MSH2004ColorCorrector.h"


/**
* @class CTSLColorTableToolDlgBar 
* 
* A color calibration tool based on the TSL color space.
*/
class CTSLColorTableToolDlgBar : public CRobotControlDialogBar
{
public:
  /**
  * Default constructor.
  */
  CTSLColorTableToolDlgBar();

  ~CTSLColorTableToolDlgBar();   

	//{{AFX_DATA(CTSLColorTableToolDlgBar)
	enum { IDD = IDD_DIALOG_BAR_TSLCOLORTABLETOOL };
	CListBox    m_ColorSelect;
	CListBox    m_OrderList;
	CButton	    m_OrderUp;
	CButton	    m_OrderDown;
	CButton	    m_Load;
	CButton	    m_Save;
  CButton     m_SaveYUV;
	CButton	    m_Send;
  CButton     m_Auto;
	CSliderCtrl	m_TMinSlider;
	CSliderCtrl	m_TMaxSlider;
	CEdit	      m_TMinNumber;
	CEdit	      m_TMaxNumber;
	CSliderCtrl	m_SMinSlider;
	CSliderCtrl	m_SMaxSlider;
	CEdit	      m_SMinNumber;
	CEdit	      m_SMaxNumber;
	CSliderCtrl	m_LMinSlider;
	CSliderCtrl	m_LMaxSlider;
	CEdit	      m_LMinNumber;
	CEdit	      m_LMaxNumber;
  CSliderCtrl m_NoiseSlider;
  CEdit       m_NoiseNumber;
	//}}AFX_DATA

  /** 
  * Called from a MessageQueue to distribute messages 
  * @param message The message that can be read.
  * @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message);


	//{{AFX_VIRTUAL(CTSLColorTableToolDlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    
    virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL

protected:

	// Generated message map functions
	//{{AFX_MSG(CTSLColorTableToolDlgBar)
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnTSLColorTableToolColorSelect();
  afx_msg void OnTSLColorTableToolOrderList();
	afx_msg void OnTSLColorTableToolLoad();
	afx_msg void OnTSLColorTableToolSave();
	afx_msg void OnTSLColorTableToolSaveYUV();
	afx_msg void OnTSLColorTableToolSend();
	afx_msg void OnTSLColorTableToolAuto();
	afx_msg void OnTSLColorTableToolOrderUp();
	afx_msg void OnTSLColorTableToolOrderDown();
  afx_msg void OnTSLColorTableToolTMinNumber();
  afx_msg void OnTSLColorTableToolTMaxNumber();
  afx_msg void OnTSLColorTableToolSMinNumber();
  afx_msg void OnTSLColorTableToolSMaxNumber();
  afx_msg void OnTSLColorTableToolLMinNumber();
  afx_msg void OnTSLColorTableToolLMaxNumber();
  afx_msg void OnTSLColorTableToolNoiseNumber();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
  void doColorCorrection(Image& image);	
  void createBitmaps();
  void deleteBitmaps();
  void updateSegmentedImage();
  void createHistograms(
    Image& image
    );
  void convertTSLToRGB(
    unsigned char t, 
    unsigned char s, 
    unsigned char l,
    unsigned char *r,
    unsigned char *g,
    unsigned char *b
    );
  void generateNoiseImage(
    Image& rawImage, 
    Image& noiseImage, 
    unsigned int noise
    );
	
  BITMAPINFOHEADER* pBufferTHistogram;
  BITMAPINFOHEADER* pBufferSHistogram;
  BITMAPINFOHEADER* pBufferLHistogram;
  unsigned int THistogram[256];
  unsigned int SHistogram[256];
  unsigned int LHistogram[256];
  int avgT;
  int avgS;
  int avgL;
  int leftT;
  int rightT;
  int leftS;
  int rightS;
  int leftL;
  int rightL;

  Image rawImage;
  Image noiseImage;
  ColorClassImage segmentedImage;
  unsigned int imageNoise;

  ColorTableTSL colorTableTSL;
  ColorTable64 colorTable64;

  colorClass selectedColorClass;
  colorClass orderColorClass;

  int regionX1;
  int regionY1;
  int regionX2;
  int regionY2;
  MSH2004ColorCorrector corrector;
};

//{{AFX_INSERT_LOCATION}}

#endif // __TSLColorTableToolDlgBar_h_

/*
* Change log :
* 
* $Log: TSLColorTableToolDlgBar.h,v $
* Revision 1.2  2004/03/04 09:55:50  schmidtb
* color correction integrated
*
* Revision 1.1  2003/10/07 10:09:38  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/26 15:28:24  juengel
* Renamed DataTypes to representations.
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.9  2003/05/11 23:46:36  dueffert
* Depend now works with RobotControl too
*
* Revision 1.8  2003/02/20 12:35:27  osterhues
* Added auto functionality
*
* Revision 1.7  2003/02/20 03:16:40  deutsch
* Save image function added
*
* Revision 1.6  2003/02/12 06:21:32  osterhues
* Start of change log
*
*
*/