/**
* @file SimulatorObjectViewerDlgBar.h
*
* Declaration of class CSimulatorObjectViewerDlgBar.
*
* @author Martin Ltzsch
*/
#ifndef __SimulatorObjectViewerDlgBar_h_
#define __SimulatorObjectViewerDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"

#include "SimRobot/SimRobotDocument.h"

/**
* A docking window for the simulator object viewer
*
* @author Martin Ltzsch
*/
class CSimulatorObjectViewerDlgBar : public CRobotControlDialogBar
{
public:
  CSimulatorObjectViewerDlgBar();
  ~CSimulatorObjectViewerDlgBar();

  //{{AFX_DATA(CMessageViewerDlgBar)
  enum { IDD = IDD_DIALOG_BAR_SIMULATOR_OBJECT_VIEWER};
  CScrollBar m_hScrollBar;
  CScrollBar m_vScrollBar;
  //}}AFX_DATA
  
  //{{AFX_VIRTUAL(CMotionTesterDlgBar)
protected:
  virtual void DoDataExchange(CDataExchange* pDX);  
  virtual BOOL OnInitDialog();
  virtual void OnDraw(CDC* pDC); 
  //}}AFX_VIRTUAL
private:
  CLICKINFO CalcClickInfo(CPoint point);
public:  
  void Repaint();
  void DoDraw(CDC& dc);
  CSimRobotDocument* GetDocument();

  /** 
  * Handles control notifications which arrived in the main frame 
  * @param command The id of the control, menu, accelerator etc.
  * @return If the command was handled.
  */
  virtual bool handleCommand(UINT command);

  /** 
  * Enables the controls in the toolbar. 
  * This function is called from the main window for all controls. 
  * @param pCmdUI An interface to the control that allows enabling/disabling, checking etc.
  */
  virtual void updateUI(CCmdUI* pCmdUI);

  /** 
  * Is called when a configuration is loaded. Can be used by the dialogs and 
  * bars to load configuration dependand settings.
  * @param sectionName The registry section for the current configuration
  */
  virtual void OnConfigurationLoad(CString sectionName);

  /** 
  * Is called when a configuration is saved. Can be used by the dialogs and 
  * bars to save configuration dependand settings.
  * @param sectionName The registry section for the current configuration
  */
  virtual void OnConfigurationSave(CString sectionName);

protected:  


  UINT m_nZoom,
    m_nDistortion,
    m_nDetailLevel;
  bool m_bHidden,
       m_bRepaint;
  SIM3DOBJECT m_obj;
  CBitmap* m_pBitmap;
  CRect m_rect;

  BOOL m_bTurn;
  
  CMenu m_menuPopup;
  
  void OnScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    
public:
  //{{AFX_MSG(CSimulatorObjectViewerDlgBar)
	afx_msg void OnPaint();
  afx_msg void OnSize(UINT nType, int cx, int cy);
  afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
  afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
  afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
  afx_msg BOOL OnEraseBkgnd(CDC* pDC);
  afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
  afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
  afx_msg void OnMouseMove(UINT nFlags, CPoint point);
  afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
  afx_msg void OnDestroy();
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP();
};


#endif //__SimulatorObjectViewerDlgBar_h_

/*
* Change Log:
*
* $Log: SimulatorObjectViewerDlgBar.h,v $
* Revision 1.2  2003/12/06 06:31:20  loetzsch
* no message
*
* Revision 1.1  2003/10/07 10:09:38  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.3  2003/05/11 23:46:35  dueffert
* Depend now works with RobotControl too
*
* Revision 1.2  2003/03/22 16:39:33  loetzsch
* continued GUI for simulated robots
*
* Revision 1.1  2002/09/10 15:49:05  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.4  2002/08/30 17:13:56  dueffert
* doxygen parser bugs fixed, docu added
*
* Revision 1.3  2002/08/07 10:50:21  loetzsch
* - removed direct access to the dialogs
* - faster starting of RobotControl application and main window
* - general clean up
*
*/
