/**
* @file PotentialfieldViewerDlgBar.h
*
* Declaration of class CPotentialfieldViewerDlgBar
*
* @author <a href="mailto:timlaue@informatik.uni-bremen.de">Tim Laue</a>
*/

#ifndef PotentialfieldViewerDlgBar_h_
#define PotentialfieldViewerDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"
#include "Representations/Cognition/ObstaclesModel.h"
#include "Representations/Cognition/RobotPose.h"
#include "Representations/Cognition/BallModel.h"
#include "Representations/Cognition/PlayerPoseCollection.h"
#include "Representations/WLan/TeamMessageCollection.h"

class BBPotentialfields;


class CPotentialFieldViewerDlgBar : public CRobotControlDialogBar
{
public:
	CPotentialFieldViewerDlgBar(CWnd* pParent = NULL);   

  bool handleMessage(InMessage& message);

	//{{AFX_DATA(CPotentialFieldViewerDlgBar)
	enum { IDD = IDD_DIALOG_BAR_POTENTIAL_FIELD_VIEWER };
	CStatic	m_fieldDisplay;
	CComboBox	m_fieldChooser;
	CButton	m_viewSelector;
	CButton	m_openButton;
	//}}AFX_DATA


	//{{AFX_VIRTUAL(CPotentialFieldViewerDlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    
  virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL


protected:
	//{{AFX_MSG(CPotentialFieldViewerDlgBar)
	afx_msg void OnPaint();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnPotentialfieldViewerOpenButton();
	afx_msg void OnPotentialfieldViewerSwitchButton();
	afx_msg void OnSelchangePotentialfieldViewerFieldChooser();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

  enum FieldViewType {POTENTIAL, VECTORS} fieldViewType;

  HGLRC m_hGLContext;
  HDC m_openGLDC;

  int stepsX, stepsY;
  double minX, minY, maxX, maxY;
  double maximum, stepWidthX, stepWidthY;
  double viewDistance;
  double value[3200];
  double dirX[3200];
  double dirY[3200];
  bool somethingLoaded;
  
  RobotPose robotPose;
  BallModel ballPosition;
  PlayerPoseCollection playerPoseCollection;
  ObstaclesModel obstaclesModel;
  BBPotentialfields* potentialfields;
  TeamMessageCollection teamMessageCollection;

  void drawField();
  void getValues();
  void initView();
};

//{{AFX_INSERT_LOCATION}}

#endif //PotentialfieldViewerDlgBar_h_


/*
 * $Log: PotentialFieldViewerDlgBar.h,v $
 * Revision 1.2  2004/04/09 14:07:11  tim
 * integrated changes from GO2004
 *
 * Revision 1.2  2004/04/01 22:16:11  tim
 * Changed behavior
 *
 * Revision 1.1  2004/03/22 10:19:33  tim
 * added potential field viewer
 *
 */
