/**
* @file PotentialFieldViewerDlgBar.cpp
*
* Implementation of class PotentialFieldViewerDlgBar
*
* @author Tim Laue
*/

#include "StdAfx.h"
#include <string>
#include <assert.h>
#include "PotentialFieldViewerDlgBar.h"
#include "Visualization/OpenGLMethods.h"
#include "Tools/FieldDimensions.h"
#include "Representations/Cognition/RobotState.h"
#include <gl/gl.h>
#include <gl/glu.h>
#include "Modules/BehaviorControl/BB2004BehaviorControl/BBPotentialfields.h"



CPotentialFieldViewerDlgBar::CPotentialFieldViewerDlgBar(CWnd* pParent)
	: CRobotControlDialogBar(IDD)
{
	//{{AFX_DATA_INIT(CPotentialFieldViewerDlgBar)
	//}}AFX_DATA_INIT
  m_hGLContext = NULL;
  potentialfields = new BBPotentialfields();
  fieldViewType = POTENTIAL;
  somethingLoaded = false;
  minX = xPosOwnGoal;
  minY = yPosRightFlags;
  maxX = xPosOpponentGoal;
  maxY = yPosLeftFlags;
  stepsX = 40;
  stepsY = 40;
  stepWidthX = (maxX - minX) / (double) stepsX;
  stepWidthY = (maxY - minY) / (double) stepsY;
  teamMessageCollection.numberOfTeamMessages = 0;
}


BOOL CPotentialFieldViewerDlgBar::OnInitDialog() 
{
  CDynamicBarDlg::OnInitDialog();
  AddSzControl(m_openButton,mdRepos,mdRepos);
  AddSzControl(m_viewSelector,mdRepos,mdRepos);
  AddSzControl(m_fieldChooser,mdRepos,mdRepos);
  m_openGLDC = ::GetDC(GetSafeHwnd());//::GetDC(hdrawingArea);
  if(OpenGLMethods::setWindowPixelFormat(m_openGLDC) == false)
  {
    assert(1>2);
    return 0;
  }
  if(OpenGLMethods::createViewGLContext(m_openGLDC, m_hGLContext) == false)
  {
    assert(1>2);
    return 0;
  }
  initView();
  return TRUE;
}


void CPotentialFieldViewerDlgBar::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPotentialFieldViewerDlgBar)
	DDX_Control(pDX, IDC_POTENTIALFIELD_SELECTOR, m_fieldChooser);
	DDX_Control(pDX, IDC_POTENTIALFIELD_SWITCH, m_viewSelector);
	DDX_Control(pDX, IDC_POTENTIALFIELD_OPEN, m_openButton);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPotentialFieldViewerDlgBar, CDialog)
	//{{AFX_MSG_MAP(CPotentialFieldViewerDlgBar)
  ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_POTENTIALFIELD_OPEN, OnPotentialfieldViewerOpenButton)
	ON_BN_CLICKED(IDC_POTENTIALFIELD_SWITCH, OnPotentialfieldViewerSwitchButton)
	ON_CBN_SELCHANGE(IDC_POTENTIALFIELD_SELECTOR, OnSelchangePotentialfieldViewerFieldChooser)
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


bool CPotentialFieldViewerDlgBar::handleMessage(InMessage& message) 
{
  if((this->IsWindowVisible()) && somethingLoaded && 
      (message.getMessageID() == idWorldState))
  {
    RobotState robotState;
    CameraMatrix cameraMatrix;
    CameraInfo cameraInfo;
    message.bin >> RECEIVE_WORLDSTATE(robotPose, ballPosition
                  ,playerPoseCollection, obstaclesModel, robotState, cameraMatrix, cameraInfo);
    getValues();
    InvalidateRect(NULL,FALSE);
    return true;
  }
  else
  {
    return false;
  }
}


void CPotentialFieldViewerDlgBar::OnPaint() 
{
  CRobotControlDialogBar::OnPaint();
  if(somethingLoaded)
  {
	  wglMakeCurrent(m_openGLDC,m_hGLContext);
    CPaintDC dc(this);
    initView();
    drawField();
    glFinish();
    SwapBuffers(dc.m_hDC);
    wglMakeCurrent(NULL,NULL);
  }
}


int CPotentialFieldViewerDlgBar::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CRobotControlDialogBar::OnCreate(lpCreateStruct) == -1)
  {
		return -1;
  }
  return 0;
}


void CPotentialFieldViewerDlgBar::OnDestroy() 
{
	CRobotControlDialogBar::OnDestroy();
  
  if(wglGetCurrentContext() != NULL)
    wglMakeCurrent(NULL,NULL);
  
  if(m_hGLContext != NULL)
  {
    wglDeleteContext(m_hGLContext);
    m_hGLContext = NULL;
  }
  m_fieldChooser.ResetContent();
  somethingLoaded = false;
  delete potentialfields;
}


void CPotentialFieldViewerDlgBar::OnPotentialfieldViewerOpenButton() 
{
	CString pathName = 
    AfxGetApp()->GetProfileString("PotentialfieldViewerDlg", "openPath", "t:\\");
  pathName.Insert(10000, "*.pfc");
  
  CFileDialog fileDialog(true, ".pfc",pathName,
    OFN_HIDEREADONLY | OFN_EXPLORER | OFN_ENABLESIZING | OFN_NOCHANGEDIR | OFN_NONETWORKBUTTON
    , "potential field configuration files (*.pfc)|*.pfc||", this);
  
  if (fileDialog.DoModal()==IDOK)
  {
    m_fieldChooser.ResetContent();
    CString fileName = fileDialog.GetFileName();
    CString pathAndFileName = fileDialog.GetPathName();
    pathName = 
      pathAndFileName.Left(
      pathAndFileName.GetLength() -
      fileName.GetLength()
      );
    AfxGetApp()->WriteProfileString("PotentialfieldViewerDlg", "openPath", pathName);
    CString relName(pathAndFileName);
    int pfieldPos(relName.Find("Pfield"));
    relName.Delete(0,pfieldPos+7);
    potentialfields->load((LPCTSTR)relName);
    std::vector<std::string> fieldNames;
    potentialfields->getFieldNames(fieldNames);
    for(unsigned int i = 0; i<fieldNames.size(); i++)
    {
      m_fieldChooser.AddString(fieldNames[i].c_str());
    }
    m_fieldChooser.SetCurSel(0);
    getValues();
    somethingLoaded = true;
    InvalidateRect(NULL,FALSE);
  }
}


void CPotentialFieldViewerDlgBar::OnPotentialfieldViewerSwitchButton() 
{
  if(fieldViewType == POTENTIAL)
  {
    fieldViewType = VECTORS;
  }
  else if(fieldViewType == VECTORS)
  {
    fieldViewType = POTENTIAL;
  }
  InvalidateRect(NULL,FALSE);
}


void CPotentialFieldViewerDlgBar::OnSelchangePotentialfieldViewerFieldChooser() 
{
  getValues();
  InvalidateRect(NULL,FALSE);
}


void CPotentialFieldViewerDlgBar::drawField()
{
  if(fieldViewType == VECTORS)
  {
    //Draw field
    glColor3d(131.0/255.0,211.0/255.0,95.0/255.0);
    glBegin(GL_POLYGON);
    glVertex3d(minX, minY, 0.0);
    glVertex3d(maxX, minY, 0.0);
    glVertex3d(maxX, maxY, 0.0);
    glVertex3d(minX, maxY, 0.0);
    glEnd();
    glColor3f(0.0,0.0,0.0);
    glPointSize(3.0);
    for (int y = 0; y < stepsY - 1; y++)
    {
      for (int x = 0; x < stepsX; x++)
      {
        PfVec p1, p2, pCenter, direction, arrowL, arrowR;
        direction.x = dirX[y * stepsX + x];
        direction.y = dirY[y * stepsX + x];
        if(direction.length() != 0.0)
        {
          pCenter.x = minX + (x+0.5) * stepWidthX;
          pCenter.y = minY + (y+0.5) * stepWidthY;
          p1.x = pCenter.x + (direction.x * stepWidthX/2);
          p1.y = pCenter.y + (direction.y * stepWidthY/2);
          p2.x = pCenter.x - (direction.x * stepWidthX/2);
          p2.y = pCenter.y - (direction.y * stepWidthY/2);
          arrowL.x = (direction.x * stepWidthX/2) * 0.5;
          arrowL.y = (direction.y * stepWidthY/2) * 0.5;
          arrowR = arrowL;
          arrowL.rotate(1.67);
          arrowR.rotate(-1.67);
          arrowL += pCenter;
          arrowR += pCenter;
          glBegin(GL_LINES);
            glVertex3d(p1.x, p1.y, 10);
            glVertex3d(p2.x, p2.y, 10);
          glEnd();
          glBegin(GL_LINES);
            glVertex3d(p1.x, p1.y, 10);
            glVertex3d(arrowL.x, arrowL.y, 10);
          glEnd();
          glBegin(GL_LINES);
            glVertex3d(p1.x, p1.y, 10);
            glVertex3d(arrowR.x, arrowR.y, 10);
          glEnd();
        }
      }
    }
    // Draw own Position
    if(getPlayer().getTeamColor() == Player::red)
    {
      glColor3f(1.0,0.0,0.0);
    }
    else
    {
      glColor3f(0.0,0.0,1.0); 
    }
    PfVec pl1,pl2,pl3,pl4;
    pl1.x = 30; pl1.y = 40;
    pl2.x = 30; pl2.y = -40;
    pl3.x = -170; pl3.y = -40;
    pl4.x = -170; pl4.y = 40;
    pl1.rotate(robotPose.rotation);
    pl2.rotate(robotPose.rotation);
    pl3.rotate(robotPose.rotation);
    pl4.rotate(robotPose.rotation);
    PfVec translation;
    translation.x = robotPose.translation.x;
    translation.y = robotPose.translation.y;
    pl1 += translation;
    pl2 += translation;
    pl3 += translation;
    pl4 += translation;
    glBegin(GL_POLYGON);
      glVertex3d(pl1.x, pl1.y, 30);
      glVertex3d(pl2.x, pl2.y, 30);
      glVertex3d(pl3.x, pl3.y, 30);
      glVertex3d(pl4.x, pl4.y, 30);
    glEnd();
    // Draw Ball
    glColor3f(1.0,0.5,0.0);
    glTranslated(ballPosition.seen.x,ballPosition.seen.y,50.0);
    gluSphere(gluNewQuadric(), 50, 15, 15);
    glTranslated(-ballPosition.seen.x,-ballPosition.seen.y,-50.0);
    // Draw Opponent Robots
    if(getPlayer().getTeamColor() == Player::red)
    {
      glColor3f(0.0,0.0,1.0);
    }
    else
    {
      glColor3f(1.0,0.0,0.0); 
    }
    PlayerPose playerPose;
    for(int i=0; i<playerPoseCollection.numberOfOpponentPlayers; i++)
    {
      playerPose = playerPoseCollection.getOpponentPlayerPose(i);
      glTranslated(playerPose.getPose().translation.x,
                   playerPose.getPose().translation.y, 50.0);
      gluSphere(gluNewQuadric(), 50, 15, 15);
      glTranslated(-playerPose.getPose().translation.x,
                   -playerPose.getPose().translation.y, -50.0);
    }
    // Draw Teammates
    if(getPlayer().getTeamColor() == Player::red)
    {
      glColor3f(1.0,0.0,0.0);
    }
    else
    {
      glColor3f(0.0,0.0,1.0); 
    }
    for(int j=0; j<playerPoseCollection.numberOfOpponentPlayers; j++)
    {
      playerPose = playerPoseCollection.getOwnPlayerPose(j);
      glTranslated(playerPose.getPose().translation.x,
                   playerPose.getPose().translation.y, 50.0);
      gluSphere(gluNewQuadric(), 50, 15, 15);
      glTranslated(-playerPose.getPose().translation.x,
                   -playerPose.getPose().translation.y, -50.0);
    }
  }
  else if(fieldViewType == POTENTIAL)
  {
    double normedHeight;
    for (int y = 0; y < stepsY - 1; y++)
    {
      glBegin(GL_QUAD_STRIP);
      for (int x = 0; x < stepsX; x++)
      {
        normedHeight = 1 - (value[y * stepsX + x] / maximum);
        glColor3d(normedHeight, normedHeight, normedHeight);
        glVertex3d (minX + x * stepWidthX,
                    minY + y * stepWidthY,0);
        normedHeight = 1 - (value[(y+1) * stepsX + x] / maximum);
        glColor3d(normedHeight, normedHeight, normedHeight);
        glVertex3d (minX + x * stepWidthX,
                    minY + (y+1) * stepWidthY,0);
      }
      glEnd();
    }
  }
}


void CPotentialFieldViewerDlgBar::getValues()
{
  std::string fieldToLoad;
  int selectedPos = m_fieldChooser.GetCurSel();
  CString dummyString;
  m_fieldChooser.GetLBText(selectedPos, dummyString);
  fieldToLoad = (const char*)dummyString;
  PfVec directions[3200];
  potentialfields->getValueArray(robotPose, ballPosition, playerPoseCollection, obstaclesModel,
    teamMessageCollection, fieldToLoad, minX, minY, maxX, maxY, stepsX, stepsY, value, maximum);
  potentialfields->getDirectionArray(robotPose, ballPosition, playerPoseCollection, obstaclesModel,
    teamMessageCollection, fieldToLoad, minX, minY, maxX, maxY, stepsX, stepsY, directions);
  for(int i=0; i<3200; i++)
  {
    dirX[i] = directions[i].x;
    dirY[i] = directions[i].y;
  }
}


void CPotentialFieldViewerDlgBar::initView()
{
  CRect drawingAreaRect;
  this->GetClientRect(&drawingAreaRect);
  double width = drawingAreaRect.right;
  double height = drawingAreaRect.bottom;

  glViewport (0, 0, (int)width, (int)height);

  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
 // double angleRatio = (width > height) ? (width / height) : (height / height);
  double angleRatio = width / height;
  gluPerspective (60.0, angleRatio, 200, 10000);

  glMatrixMode (GL_MODELVIEW);
  glLoadIdentity ();
  glTranslatef (0.0, 0.0, 0.0);

  glShadeModel (GL_SMOOTH);
  glEnable(GL_LINE_SMOOTH);
  glEnable (GL_DEPTH_TEST);

  //set new view
  viewDistance = ((maxX-minX)/2.0) / tan(fromDegrees(30.0*angleRatio));
  gluLookAt (0.0, 0.0, viewDistance, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);

  // Clear
  glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
}


/*
 * $Log: PotentialFieldViewerDlgBar.cpp,v $
 * Revision 1.4  2004/04/09 14:07:11  tim
 * integrated changes from GO2004
 *
 * Revision 1.4  2004/04/01 22:16:11  tim
 * Changed behavior
 *
 * Revision 1.3  2004/03/23 17:23:58  dueffert
 * spelling fixed
 *
 * Revision 1.2  2004/03/22 12:19:56  tim
 * removed warnings
 *
 * Revision 1.1  2004/03/22 10:19:33  tim
 * added potential field viewer
 *
 */
