/**
* @file MultipleFieldsDlgBar.cpp
*
* Implementation of class CMultipleFieldsDlgBar
*
* @author Martin Ltzsch
*/

#include "StdAfx.h"
#include "MultipleFieldsDlgBar.h"
#include "Visualization/PaintMethodsWin32.h"

CMultipleFieldsDlgBar::CMultipleFieldsDlgBar()
	: CRobotControlDialogBar(IDD)
{
	//{{AFX_DATA_INIT(CMultipleFieldsDlgBar)
	//}}AFX_DATA_INIT

  bmpOffScreen = NULL;
  oldBitmap = NULL;
}

CMultipleFieldsDlgBar::~CMultipleFieldsDlgBar()
{
  if(bmpOffScreen)
  {
    dcOffScreen.SelectObject(oldBitmap);
    bmpOffScreen->DeleteObject();
    delete(bmpOffScreen);
  }
}

BEGIN_MESSAGE_MAP(CMultipleFieldsDlgBar, CDynamicBarDlg)
	//{{AFX_MSG_MAP(CMultipleFieldsDlgBar)
	ON_WM_PAINT()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CMultipleFieldsDlgBar::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMultipleFieldsDlgBar)
	//}}AFX_DATA_MAP
}

BOOL CMultipleFieldsDlgBar::OnInitDialog() 
{
	CDynamicBarDlg::OnInitDialog();

  return TRUE;
}

void CMultipleFieldsDlgBar::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
  CBrush backGroundBrush(RGB(255,0,0));
  dcOffScreen.FillRect(&currentRect, &backGroundBrush);

  dc.BitBlt(paintRect.left, paintRect.top, paintRect.right, paintRect.bottom,
    &dcOffScreen, 0, 0, SRCCOPY);
}

void CMultipleFieldsDlgBar::OnSize(UINT nType, int cx, int cy) 
{
  paintRect.top = 0;
  paintRect.bottom = cy;
  paintRect.left = 0;
  paintRect.right = cx - 0;

  currentRect.top = 0;
  currentRect.left = 0;
  currentRect.bottom = paintRect.bottom - paintRect.top;
  currentRect.right = paintRect.right - paintRect.left;

	CPaintDC dc(this); // device context for painting

  if(!dcOffScreen)
    dcOffScreen.CreateCompatibleDC(&dc);
  
  if(bmpOffScreen)
  {
    dcOffScreen.SelectObject(oldBitmap);
    bmpOffScreen->DeleteObject();
    delete(bmpOffScreen);
  }
  bmpOffScreen = new CBitmap;
  bmpOffScreen->CreateCompatibleBitmap(
    &dc, paintRect.right, paintRect.bottom - paintRect.top);
  oldBitmap = dcOffScreen.SelectObject(bmpOffScreen);


  RedrawWindow(NULL, NULL, RDW_INVALIDATE);

  CDynamicBarDlg::OnSize(nType,cx,cy);
}

/*
 * Change log :
 * 
 * $Log: MultipleFieldsDlgBar.cpp,v $
 * Revision 1.1  2003/12/09 18:15:31  loetzsch
 * added dialog bar "multiple fields"
 *
 */


