
/** 
* @file MotionOptimizerDlgBar.h
* Declaration of class CMotionOptimizerDlgBar
* @author Sebastian Petters
* @author Dirk Thomas
*/

#ifndef __MotionOptimizerDlgBar_h_
#define __MotionOptimizerDlgBar_h_

// #include <list>
#include "RobotControlDialogBar.h"
// #include "Tools/MessageQueue/MessageQueue.h"

#include "Modules/BehaviorControl/MotionRatingBehaviorControl/MotionRatingBehaviorMessage.h"
#include "Modules/WalkingEngine/InvKinWalkingEngine.h"

class CMotionOptimizerDlgBar;

#include "MotionOptimizerController.h"
#include "MotionOptimizer.h"
#include "MotionOptimizerRobot.h"
#include "MotionOptimizerRobotList.h"

// typedef std::list<MotionOptimizerRobot*> RobotList;

class CMotionOptimizerDlgBar : public CRobotControlDialogBar, public MotionOptimizerController
{
// Konstruktion
public:
	CMotionOptimizerDlgBar(CWnd* pParent = NULL);   // Standardkonstruktor
	~CMotionOptimizerDlgBar();

// Dialogfelddaten
	//{{AFX_DATA(CMotionOptimizerDlgBar)
	enum { IDD = IDD_DIALOG_BAR_MOTIONOPTIMIZER };
	CButton	m_checkUseSimulated;
	CButton	m_checkStarted;
	CButton	m_checkTimer;
	CListCtrl	m_List;
	CButton	m_buttonReset;
	CButton	m_buttonTest;
	CEdit	m_messageBox;
	//}}AFX_DATA


  bool handleMessage ( InMessage& message );
  void printMessage ( char* message );
  void setResult ( int paramSetId, double result );
  void updateList ( MotionOptimizerRobot* robot );

// berschreibungen
	// Vom Klassen-Assistenten generierte virtuelle Funktionsberschreibungen
	//{{AFX_VIRTUAL(CMotionOptimizerDlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung
	virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL

// Implementierung
protected:

  int colId, colMessages, colBattery, colState, colParamSetId, colWalk, colCurrSpeed, colAvgSpeed;

  bool useSimulated;
  bool started;

  UINT timer;

  // MotionOptimizerPhysicalRobot* robots[8];

  // RobotList robots;
  MotionOptimizerRobotList* robotList;
  MotionOptimizer* optimizer;

  /*
  bool hasWaitingRobot();
  MotionOptimizerRobot* getWaitingRobot();
  bool hasSleepingRobot();
  MotionOptimizerRobot* getSleepingRobot();
  */

	// Generierte Nachrichtenzuordnungsfunktionen
	//{{AFX_MSG(CMotionOptimizerDlgBar)
	afx_msg void OnMotionoptimizerButtonTest();
	afx_msg void OnMotionoptimizerButtonReset();
	afx_msg void OnMotionoptimizerCheckUseSimulated();
	afx_msg void OnMotionoptimizerCheckStarted();
	afx_msg void OnMotionoptimizerCheckTimer();
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}

#endif //  __MotionOptimizerDlgBar_h_
