// MotionOptimizerDlgBar.cpp: Implementierungsdatei
//

#include "StdAfx.h"

#include "MotionOptimizerDlgBar.h"

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CMotionOptimizerDlgBar 


CMotionOptimizerDlgBar::CMotionOptimizerDlgBar(CWnd* pParent /*=NULL*/)
	: CRobotControlDialogBar(CMotionOptimizerDlgBar::IDD)
{
  started = false;

  robotList = new MotionOptimizerRobotList();

  optimizer = new MotionOptimizer ( *this );
  optimizer->reset();

	//{{AFX_DATA_INIT(CMotionOptimizerDlgBar)
	//}}AFX_DATA_INIT
}

CMotionOptimizerDlgBar::~CMotionOptimizerDlgBar()
{
  delete robotList;
  delete optimizer;
}

BOOL CMotionOptimizerDlgBar::OnInitDialog() 
{
  CDynamicBarDlg::OnInitDialog();
  AddSzControl(m_List,mdResize,mdNone);
  AddSzControl(m_messageBox,mdResize,mdResize);

  m_checkUseSimulated.SetCheck ( 0 );
  useSimulated = m_checkUseSimulated.GetCheck() == 1;

  m_checkStarted.SetCheck ( 0 );
  started = m_checkStarted.GetCheck() == 1;

  m_checkTimer.SetCheck ( 0 );

  colId         = m_List.InsertColumn ( 0, "Robot",       LVCFMT_LEFT, 70, 1 );
  colMessages   = m_List.InsertColumn ( 1, "Messages",    LVCFMT_LEFT, 70, 2 );
  colBattery    = m_List.InsertColumn ( 2, "Battery",     LVCFMT_LEFT, 70, 3 );
  colState      = m_List.InsertColumn ( 3, "State",       LVCFMT_LEFT, 70, 4 );
  colParamSetId = m_List.InsertColumn ( 4, "ParamSetId",  LVCFMT_LEFT, 70, 5 );
  colWalk       = m_List.InsertColumn ( 5, "Walk",        LVCFMT_LEFT, 70, 6 );
  colCurrSpeed  = m_List.InsertColumn ( 6, "curr. Speed", LVCFMT_LEFT, 70, 7 );
  colAvgSpeed   = m_List.InsertColumn ( 7, "avg. Speed",  LVCFMT_LEFT, 70, 8 );

  return TRUE;
}

void CMotionOptimizerDlgBar::updateList ( MotionOptimizerRobot* robot )
{
  int item = robot->getItem();
  char str[50];

  sprintf ( str, (robot->isPhysical() ? "phys. robot %d" : "sim. robot %d" ), robot->getId() );
  m_List.SetItemText ( item, colId, str );
  
  sprintf ( str, "%d", robot->getMessageCount() );
  m_List.SetItemText ( item, colMessages, str );
  
  sprintf ( str, "%d%%", robot->getRemainingPower() );
  m_List.SetItemText ( item, colBattery, str );
  
  m_List.SetItemText ( item, colState, robot->getStateName() );
  
  sprintf ( str, "%d", robot->getParamSetId() );
  m_List.SetItemText ( item, colParamSetId, str );

  sprintf ( str, "%d of %d", robot->getCurrentWalk(), robot->getWalkCount() );
  m_List.SetItemText ( item, colWalk, str );

  if ( robot->getAverageSpeed() == 0.0 ) m_List.SetItemText ( item, colAvgSpeed, "unknown" );
  else 
  {
    sprintf ( str, "%.2fcm/s", 100.0 * robot->getAverageSpeed() );
    m_List.SetItemText ( item, colAvgSpeed, str );
  }

  if ( robot->getCurrentSpeed() == 0.0 ) m_List.SetItemText ( item, colCurrSpeed, "unknown" );
  else 
  {
    sprintf ( str, "%.2fcm/s", 100.0 * robot->getCurrentSpeed() );
    m_List.SetItemText ( item, colCurrSpeed, str );
  }
}

void CMotionOptimizerDlgBar::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMotionOptimizerDlgBar)
	DDX_Control(pDX, IDC_MOTIONOPTIMIZER_LIST, m_List);
	DDX_Control(pDX, IDC_MOTIONOPTIMIZER_BUTTON_TEST, m_buttonTest);
	DDX_Control(pDX, IDC_MOTIONOPTIMIZER_CHECK_START, m_checkStarted);
	DDX_Control(pDX, IDC_MOTIONOPTIMIZER_CHECK_TIMER, m_checkTimer);
	DDX_Control(pDX, IDC_MOTIONOPTIMIZER_CHECK_USE_SIMULATED, m_checkUseSimulated);
	DDX_Control(pDX, IDC_MOTIONOPTIMIZER_MESSAGEBOX, m_messageBox);
	//}}AFX_DATA_MAP
}

void CMotionOptimizerDlgBar::setResult ( int paramSetId, double result )
{
  optimizer->setResult ( paramSetId, result );
}

bool CMotionOptimizerDlgBar::handleMessage(InMessage& message)
{
  // only use MotionRatingMessages
  if ( message.getMessageID() != idMotionRatingBehaviorMessage ) return false;

  int robotId = message.getRobotNumber();
  bool physical = message.getMessageWasSentFromAPhysicalRobot();

  // test if we want to use simulated robots
  if ( physical == useSimulated ) return true;

  MotionRatingBehaviorMessage msg;
  message.bin >> msg;
  
  MotionOptimizerRobot* robot;

  robot = robotList->getRobot ( robotId, physical );
  if ( robot == 0 ) 
  {
    printMessage ( "creating new robot\r\n" );
    int item = m_List.InsertItem ( m_List.GetItemCount(), "robot" );
    robot = new MotionOptimizerRobot ( this, robotId, physical, item );
    robotList->addRobot ( robot );
  }
  robot->handleMessage ( msg );

  if ( started && optimizer->hasNext() )
  {
    robot = robotList->getWaitingRobot();
    if ( robot != 0 )
    {
      int pid = 0;
      InvKinWalkingParameters paramset;
      pid = optimizer->getNext ( paramset );
      robot->test ( pid, paramset );
    }

    robot = robotList->getSleepingRobot();
    if ( robot != 0 ) robot->init ( (robot->getId() % 3) + 1 );
  }

  return true;
}

void CMotionOptimizerDlgBar::printMessage ( char* message )
{
  if (m_messageBox)
  {
    m_messageBox.SetSel ( 10000000, 10000000 );
    m_messageBox.ReplaceSel  ( message );
    m_messageBox.LineScroll ( 2 );
  }
}

BEGIN_MESSAGE_MAP(CMotionOptimizerDlgBar, CDynamicBarDlg)
	//{{AFX_MSG_MAP(CMotionOptimizerDlgBar)
	ON_BN_CLICKED(IDC_MOTIONOPTIMIZER_BUTTON_TEST, OnMotionoptimizerButtonTest)
	ON_BN_CLICKED(IDC_MOTIONOPTIMIZER_BUTTON_RESET, OnMotionoptimizerButtonReset)
	ON_BN_CLICKED(IDC_MOTIONOPTIMIZER_CHECK_START, OnMotionoptimizerCheckStarted)
	ON_BN_CLICKED(IDC_MOTIONOPTIMIZER_CHECK_USE_SIMULATED, OnMotionoptimizerCheckUseSimulated)
	ON_BN_CLICKED(IDC_MOTIONOPTIMIZER_CHECK_TIMER, OnMotionoptimizerCheckTimer)
  ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CMotionOptimizerDlgBar 

void CMotionOptimizerDlgBar::OnMotionoptimizerButtonTest() 
{
  // do something usefull
}

void CMotionOptimizerDlgBar::OnMotionoptimizerButtonReset() 
{
  // do something usefull

  // clear robot list
  // clear listbox
  // reset optimizer
  optimizer->reset();
}

void CMotionOptimizerDlgBar::OnMotionoptimizerCheckUseSimulated() 
{
  useSimulated = m_checkUseSimulated.GetCheck() == 1;
}

void CMotionOptimizerDlgBar::OnMotionoptimizerCheckStarted() 
{
  started = m_checkStarted.GetCheck() == 1;
}

void CMotionOptimizerDlgBar::OnMotionoptimizerCheckTimer() 
{
  bool start = m_checkTimer.GetCheck() == 1;

  if ( start ) {
    timer = SetTimer(4711, 5000, 0);
    if ( timer == 0 ) m_checkTimer.SetCheck ( 0 );
  } else {
    KillTimer ( timer );
  }
}

void CMotionOptimizerDlgBar::OnTimer(UINT nIDEvent)
{
  /*
  RobotList::const_iterator pos;
  for ( pos = robots.begin(); pos != robots.end(); pos++ ) 
    (*pos)->notify();
  */

  CDynamicBarDlg::OnTimer(nIDEvent);
}
