#include "StdAfx.h"

#include "MotionOptimizer.h"
#include "Modules/WalkingEngine/InvKinWalkingParameterSets.h"

/////////////////////////////////////////////////////////////////////////////
// Motion Optimizer

MotionOptimizer::MotionOptimizer ( MotionOptimizerController& controller ) : controller(controller)
{
  fileIn = "optin.txt";
  fileOut = "optout.txt";
}

void MotionOptimizer::reset()
{
  // reset number of read/written records
  read = 0;
  written = 0;
  input.clear();
  assigned.clear();
  output.clear();
  // delete fileIn and fileOut
  //OutTextFile fhIn(fileIn,false);
  OutTextFile fhOut(fileOut,false);

  /*InvKinWalkingParameters p,q;
  int i,j;
  readInput();
  i = getNext(p);
  j = getNext(q);
  setResult(j, 7.3);
  setResult(i, 5.8);*/
}

// return if there is a paramset in input-map or if a new one can be read by readInput
bool MotionOptimizer::hasNext()
{
  if(!input.empty())
    return true;
  return readInput();
}

// return first paramset from input-map and move this entry to assigned-map
int MotionOptimizer::getNext ( InvKinWalkingParameters &paramset )
{
  std::map<int,InvKinWalkingParameters>::iterator it=input.begin();
  int id = it->first;
  paramset = it->second;
  input.erase(it);
  char msg[255];
  sprintf(msg,"OPT: assigned id %d\r\n", id);
  controller.printMessage ( msg );
  assigned[id] = paramset;
  return id;
}

void MotionOptimizer::setResult ( int paramSetId, double result )
{
  std::map<int,InvKinWalkingParameters>::iterator it=assigned.find(paramSetId);
  if(it != assigned.end()) {
    char msg[255];
    sprintf(msg,"OPT: finished id %d result %f\r\n", paramSetId, result);
    controller.printMessage ( msg );
    output[paramSetId] = result;
    //std::pair<int,double> p(paramSetId,result);
    //output.insert(output.end(), p);
    assigned.erase(paramSetId);
    writeOutput ( paramSetId, result );
  }
}

void MotionOptimizer::printParamset(const InvKinWalkingParameters& params, char* msg)
{
  sprintf(msg, "%3.3f %3.3f %3.3f %3.3f %3.3f %3.3f %3.3f %3.3f %3.3f %3.3f %3.3f %3.3f %3.3f %3.3f %3.3f %3.3f %3.3f %3.3f %d", params.foreHeight, params.foreWidth, params.foreCenterX, params.hindHeight, params.hindWidth, params.hindCenterX, params.foreFootLift, params.hindFootLift, params.foreFootTilt, params.hindFootTilt, params.legSpeedFactorX, params.legSpeedFactorY, params.legSpeedFactorR, params.maxStepSizeX, params.maxStepSizeY, params.maxSpeedXChange, params.maxSpeedYChange, params.maxRotationChange, params.stepLen);
}

bool MotionOptimizer::readInput()
{
  InTextFile fh(fileIn);
  int i = 0;
  bool readNew = false;
  
  while(fh.exists() && !fh.eof())
  {
    i++;
    int paramId;
    fh >> paramId;
    if(paramId == 0) break;
    InvKinWalkingParameters params;
    strcpy(params.name,"QuickUNSWClone");
    fh >> params.foreHeight;
    fh >> params.foreWidth;
    fh >> params.foreCenterX;
    fh >> params.hindHeight;
    fh >> params.hindWidth;
    fh >> params.hindCenterX;
    fh >> params.foreFootLift;
    fh >> params.hindFootLift;
    fh >> params.foreFootTilt;
    fh >> params.hindFootTilt;
    fh >> params.legSpeedFactorX;
    fh >> params.legSpeedFactorY;
    fh >> params.legSpeedFactorR;
    fh >> params.maxStepSizeX;
    fh >> params.maxStepSizeY;
    fh >> params.maxSpeedXChange;
    fh >> params.maxSpeedYChange;
    fh >> params.maxRotationChange;
    fh >> params.stepLen;
    
    if(i>read) {
      read++;
      readNew = true;
      char msg[255];
      sprintf(msg,"OPT: read new id %d\r\n", paramId);
      controller.printMessage ( msg );
      input[paramId] = params;
    }
  }
  //char msg[255];
  //sprintf(msg,"debug: %d lines from in-file\r\n",input.size());
  //controller.printMessage ( msg );
  return readNew;
}

void MotionOptimizer::writeOutput ( int paramSetId, double result )
{
  OutTextRawFile fh(fileOut,true);

  char msg[255];
  sprintf(msg,"OPT: write %d with %f to out-file\r\n", paramSetId, result);
  controller.printMessage ( msg );

  char str[63];
  sprintf(str,"%d %f\n", paramSetId, result);
  fh << str;

  /*OutTextFile fh(fileOut,true);
  int i = 0;

  //std::vector<int,double>::iterator it=output.begin();
  for(std::map<int,double>::iterator it=output.begin();it!=output.end();++it) {
    i++;
    int id = it->first;
    double result = it->second;
      char msg[255];
      sprintf(msg,"OPT: could be write %d with %f to out-file\r\n", id, result);
      controller.printMessage ( msg );
    if(i>written) {
      written++;
      //char msg[255];
      //sprintf(msg,"OPT: write %d with %f to out-file\r\n", id, result);
      //controller.printMessage ( msg );
      char str[63];
      sprintf(str,"%d %f\n", id, result);
      fh << str;
    }
  }*/
}
