/**
* @file ImageViewerDlgBar.cpp
*
* Implementation of class CImageViewerDlgBar
*
* @author Matthias Jngel
*/ 

#include "StdAfx.h"
#include "ImageViewerDlgBar.h"

#include "Visualization/DebugDrawingManager/DebugDrawingManager.h"
#include "Visualization/DebugDrawingManager/DebugDrawingManagerUI.h"

CImageViewerDlgBar::CImageViewerDlgBar()
: CRobotControlDialogBar(IDD)
{
  //{{AFX_DATA_INIT(CImageViewerDlgBar)
  //}}AFX_DATA_INIT
}

CImageViewerDlgBar::~CImageViewerDlgBar()
{
}

void CImageViewerDlgBar::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CImageViewerDlgBar)
  //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CImageViewerDlgBar, CDynamicBarDlg)
//{{AFX_MSG_MAP(CImageViewerDlgBar)
ON_WM_PAINT()
ON_WM_SIZE()
ON_WM_TIMER()
	ON_WM_CONTEXTMENU()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CImageViewerDlgBar::OnInitDialog() 
{
  CDynamicBarDlg::OnInitDialog();

  registerDrawingPaper(DrawingPapers::imageViewer1, this);
  registerDrawingPaper(DrawingPapers::imageViewer2, this);
  registerDrawingPaper(DrawingPapers::imageViewer3, this);
  registerDrawingPaper(DrawingPapers::imageViewer4, this);
  registerDrawingPaper(DrawingPapers::imageViewer5, this);
  registerDrawingPaper(DrawingPapers::imageViewer6, this);
  registerDrawingPaper(DrawingPapers::imageViewer7, this);
  registerDrawingPaper(DrawingPapers::imageViewer8, this);

  return TRUE;
}
void CImageViewerDlgBar::OnPaint() 
{
  CPaintDC dc(this); // device context for painting

  changeLayout();

  paintDrawingPaper(&rectImage1, DrawingPapers::imageViewer1);
  paintDrawingPaper(&rectImage2, DrawingPapers::imageViewer2);
  paintDrawingPaper(&rectImage3, DrawingPapers::imageViewer3);
  paintDrawingPaper(&rectImage4, DrawingPapers::imageViewer4);
  paintDrawingPaper(&rectImage5, DrawingPapers::imageViewer5);
  paintDrawingPaper(&rectImage6, DrawingPapers::imageViewer6);
  paintDrawingPaper(&rectImage7, DrawingPapers::imageViewer7);
  paintDrawingPaper(&rectImage8, DrawingPapers::imageViewer8);
}


void CImageViewerDlgBar::OnSize(UINT nType, int cx, int cy) 
{
  dialogWidth = cx;
  dialogHeight = cy;

  changeLayout();
  RedrawWindow(NULL, NULL, RDW_INVALIDATE);
}

void CImageViewerDlgBar::changeLayout()
{
  int imageWidth;
  int imageHeight;

  imageWidth = getDebugImageCameraInfo().resolutionWidth;
  imageHeight = getDebugImageCameraInfo().resolutionHeight;
  
  rectImage1.left = 0;
  rectImage1.right = imageWidth;
  rectImage1.top = 0;
  rectImage1.bottom = imageHeight;

  if(dialogWidth < imageWidth + 1 + imageWidth + 1 && dialogHeight > imageHeight + imageHeight / 2)
  {
    //vertical layout
    rectImage2.left = 0;
    rectImage2.right = imageWidth;
    rectImage2.top = imageHeight + 1;
    rectImage2.bottom = imageHeight + 1 + imageHeight;
    
    rectImage3.left = 0;
    rectImage3.right = imageWidth;
    rectImage3.top = imageHeight + 1 + imageHeight + 1;
    rectImage3.bottom = imageHeight + 1 + imageHeight + 1 + imageHeight;
    
    rectImage4.left = 0;
    rectImage4.right = imageWidth;
    rectImage4.top = imageHeight + 1 + imageHeight + 1 + imageHeight + 1;
    rectImage4.bottom = imageHeight + 1 + imageHeight + 1 + imageHeight + 1 + imageHeight;

    rectImage5.left = imageWidth + 1;
    rectImage5.right = imageWidth + 1 + imageWidth;
    rectImage5.top = 0;
    rectImage5.bottom = imageHeight;

    rectImage6.left = imageWidth + 1;
    rectImage6.right = imageWidth + 1 + imageWidth;
    rectImage6.top = imageHeight + 1;
    rectImage6.bottom = imageHeight + 1 + imageHeight;
    
    rectImage7.left = imageWidth + 1;
    rectImage7.right = imageWidth + 1 + imageWidth;
    rectImage7.top = imageHeight + 1 + imageHeight + 1;
    rectImage7.bottom = imageHeight + 1 + imageHeight + 1 + imageHeight;
    
    rectImage8.left = imageWidth + 1;
    rectImage8.right = imageWidth + 1 + imageWidth;
    rectImage8.top = imageHeight + 1 + imageHeight + 1 + imageHeight + 1;
    rectImage8.bottom = imageHeight + 1 + imageHeight + 1 + imageHeight + 1 + imageHeight;
  }
  else if(dialogHeight < imageHeight + imageHeight)
  {
    //horizontal layout
    rectImage2.left = imageWidth + 1;
    rectImage2.right = imageWidth + 1 + imageWidth;
    rectImage2.top = 0;
    rectImage2.bottom = imageHeight;
    
    rectImage3.left = imageWidth + 1 + imageWidth + 1;
    rectImage3.right = imageWidth + 1 + imageWidth + 1 + imageWidth;
    rectImage3.top = 0;
    rectImage3.bottom = imageHeight;
    
    rectImage4.left = imageWidth + 1 + imageWidth + 1 + imageWidth + 1;
    rectImage4.right = imageWidth + 1 + imageWidth + 1 + imageWidth + 1 + imageWidth;
    rectImage4.top = 0;
    rectImage4.bottom = imageHeight;
    
    rectImage5.left = 0;
    rectImage5.right = imageWidth;
    rectImage5.top = imageHeight + 1;
    rectImage5.bottom = imageHeight + 1 + imageHeight;

    rectImage6.left = imageWidth + 1;
    rectImage6.right = imageWidth + 1 + imageWidth;
    rectImage6.top = imageHeight + 1;
    rectImage6.bottom = imageHeight + 1 + imageHeight;
    
    rectImage7.left = imageWidth + 1 + imageWidth + 1;
    rectImage7.right = imageWidth + 1 + imageWidth + 1 + imageWidth;
    rectImage7.top = imageHeight + 1;
    rectImage7.bottom = imageHeight + 1 + imageHeight;
    
    rectImage8.left = imageWidth + 1 + imageWidth + 1 + imageWidth + 1;
    rectImage8.right = imageWidth + 1 + imageWidth + 1 + imageWidth + 1 + imageWidth;
    rectImage8.top = imageHeight + 1;
    rectImage8.bottom = imageHeight + 1 + imageHeight;
    
  }
  else
  {
    //compact layout
    rectImage2.left = imageWidth + 1;
    rectImage2.right = imageWidth + 1 + imageWidth;
    rectImage2.top = 0;
    rectImage2.bottom = imageHeight;
    
    rectImage3.left = 0;
    rectImage3.right = imageWidth;
    rectImage3.top = imageHeight + 1;
    rectImage3.bottom = imageHeight + 1 + imageHeight;
    
    rectImage4.left = imageWidth + 1;
    rectImage4.right = imageWidth + 1 + imageWidth;
    rectImage4.top = imageHeight + 1;
    rectImage4.bottom = imageHeight + 1 + imageHeight;

    rectImage5.left = 0;
    rectImage5.right = imageWidth;
    rectImage5.top = imageHeight + 1 + imageHeight + 1;
    rectImage5.bottom = imageHeight + 1 + imageHeight + 1 + imageHeight;

    rectImage6.left = imageWidth + 1;
    rectImage6.right = imageWidth + 1 + imageWidth;
    rectImage6.top = imageHeight + 1 + imageHeight + 1;
    rectImage6.bottom = imageHeight + 1 + imageHeight + 1 + imageHeight;
    
    rectImage7.left = 0;
    rectImage7.right = imageWidth;
    rectImage7.top = imageHeight + 1 + imageHeight + 1 + imageHeight + 1;
    rectImage7.bottom = imageHeight + 1 + imageHeight + 1 + imageHeight + 1 + imageHeight;
    
    rectImage8.left = imageWidth + 1;
    rectImage8.right = imageWidth + 1 + imageWidth;
    rectImage8.top = imageHeight + 1 + imageHeight + 1 + imageHeight + 1;
    rectImage8.bottom = imageHeight + 1 + imageHeight + 1 + imageHeight + 1 + imageHeight;
  }
}


void CImageViewerDlgBar::OnContextMenu(CWnd* pWnd, CPoint point) 
{
  CRect windowRect;
  this->GetWindowRect(&windowRect);
  CPoint selectedPoint = point - CPoint(windowRect.left, windowRect.top);
  if(
    rectImage1.left <= selectedPoint.x &&
    rectImage1.right > selectedPoint.x &&
    rectImage1.top <= selectedPoint.y &&
    rectImage1.bottom > selectedPoint.y 
    )
  {
    DebugDrawingManagerUI::showContextMenu(
      DrawingPapers::imageViewer1, point,
      GetParentFrame()
      );
  }

  if(
    rectImage2.left <= selectedPoint.x &&
    rectImage2.right > selectedPoint.x &&
    rectImage2.top <= selectedPoint.y &&
    rectImage2.bottom > selectedPoint.y 
    )
  {
    DebugDrawingManagerUI::showContextMenu(
      DrawingPapers::imageViewer2, point,
      GetParentFrame()
      );
  }
  
  if(
    rectImage3.left <= selectedPoint.x &&
    rectImage3.right > selectedPoint.x &&
    rectImage3.top <= selectedPoint.y &&
    rectImage3.bottom > selectedPoint.y 
    )
  {
    DebugDrawingManagerUI::showContextMenu(
      DrawingPapers::imageViewer3, point,
      GetParentFrame()
      );
  }

  if(
    rectImage4.left <= selectedPoint.x &&
    rectImage4.right > selectedPoint.x &&
    rectImage4.top <= selectedPoint.y &&
    rectImage4.bottom > selectedPoint.y 
    )
  {
    DebugDrawingManagerUI::showContextMenu(
      DrawingPapers::imageViewer4, point,
      GetParentFrame()
      );
  }

  if(
    rectImage5.left <= selectedPoint.x &&
    rectImage5.right > selectedPoint.x &&
    rectImage5.top <= selectedPoint.y &&
    rectImage5.bottom > selectedPoint.y 
    )
  {
    DebugDrawingManagerUI::showContextMenu(
      DrawingPapers::imageViewer5, point,
      GetParentFrame()
      );
  }

  if(
    rectImage6.left <= selectedPoint.x &&
    rectImage6.right > selectedPoint.x &&
    rectImage6.top <= selectedPoint.y &&
    rectImage6.bottom > selectedPoint.y 
    )
  {
    DebugDrawingManagerUI::showContextMenu(
      DrawingPapers::imageViewer6, point,
      GetParentFrame()
      );
  }

  if(
    rectImage7.left <= selectedPoint.x &&
    rectImage7.right > selectedPoint.x &&
    rectImage7.top <= selectedPoint.y &&
    rectImage7.bottom > selectedPoint.y 
    )
  {
    DebugDrawingManagerUI::showContextMenu(
      DrawingPapers::imageViewer7, point,
      GetParentFrame()
      );
  }

  if(
    rectImage8.left <= selectedPoint.x &&
    rectImage8.right > selectedPoint.x &&
    rectImage8.top <= selectedPoint.y &&
    rectImage8.bottom > selectedPoint.y 
    )
  {
    DebugDrawingManagerUI::showContextMenu(
      DrawingPapers::imageViewer8, point,
      GetParentFrame()
      );
  }

}

/*
 * Change log :
 * 
 * $Log: ImageViewerDlgBar.cpp,v $
 * Revision 1.3  2004/01/04 12:08:28  juengel
 * adaptation for larger images
 *
 * Revision 1.2  2003/12/15 11:47:05  juengel
 * Introduced CameraInfo
 *
 * Revision 1.1  2003/10/07 10:09:37  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/08/25 17:22:29  juengel
 * ImageViewer displays 8 images now.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.4  2003/05/11 23:46:33  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.3  2003/03/28 14:30:20  juengel
 * Changed resizeing.
 *
 * Revision 1.2  2002/09/20 23:28:34  juengel
 * Moved instance of DebugDrawingManager to RobotControlMainFrame.
 *
 * Revision 1.1  2002/09/10 15:49:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.2  2002/07/23 13:43:36  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - empty constructors in bars / dialogs
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 */
