/**
 *  @file HSIColorTableToolDlgBar.cpp
 *  Implementation of class CHSIColorTableToolDlgBar.
 *  @author<A href=mailto:kspiess@informatik.uni-bremen.de>Kai Spiess</A>
 */

#include "StdAfx.h"
#include "HSIColorTableToolDlgBar.h"

#include "Visualization/ImageMethods.h"
#include "Platform/Sensors.h"

CHSIColorTableToolDlgBar::CHSIColorTableToolDlgBar()
	: CRobotControlDialogBar(IDD)
{
	//{{AFX_DATA_INIT(CHSIColorTableToolDlgBar)
	//}}AFX_DATA_INIT
}


void CHSIColorTableToolDlgBar::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHSIColorTableToolDlgBar)
	DDX_Control(pDX, IDC_HSICOLORTABLETOOL_CAPTURE_BUTTON1, m_captureButton1);
	DDX_Control(pDX, IDC_HSICOLORTABLETOOL_UPDATE_CHECK, m_updateImageFromQueue);
	DDX_Control(pDX, IDC_HSICOLORTABLETOOL_COLORCHOOSER, m_hsiColorChooser);
	DDX_Control(pDX, IDC_HSICOLORTABLETOOL_IMIN_VALUE, m_IminValue);
	DDX_Control(pDX, IDC_HSICOLORTABLETOOL_IMAX_VALUE, m_ImaxValue);
	DDX_Control(pDX, IDC_HSICOLORTABLETOOL_SMIN_VALUE, m_SminValue);
	DDX_Control(pDX, IDC_HSICOLORTABLETOOL_SMAX_VALUE, m_SmaxValue);
	DDX_Control(pDX, IDC_HSICOLORTABLETOOL_HMIN_VALUE, m_HminValue);
	DDX_Control(pDX, IDC_HSICOLORTABLETOOL_HMAX_VALUE, m_HmaxValue);
	DDX_Control(pDX, IDC_HSICOLORTABLETOOL_IMIN_SLIDER, m_IminSlider);
	DDX_Control(pDX, IDC_HSICOLORTABLETOOL_IMAX_SLIDER, m_ImaxSlider);
	DDX_Control(pDX, IDC_HSICOLORTABLETOOL_SMIN_SLIDER, m_SminSlider);
	DDX_Control(pDX, IDC_HSICOLORTABLETOOL_SMAX_SLIDER, m_SmaxSlider);
	DDX_Control(pDX, IDC_HSICOLORTABLETOOL_HMIN_SLIDER, m_HminSlider);
	DDX_Control(pDX, IDC_HSICOLORTABLETOOL_HMAX_SLIDER, m_HmaxSlider);
	DDX_Control(pDX, IDC_HSICOLORTABLETOOL_HPALETTE_BITMAP_STATIC, m_HPaletteBitmapFrame);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CHSIColorTableToolDlgBar, CDynamicBarDlg)
	//{{AFX_MSG_MAP(CHSIColorTableToolDlgBar)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_HSICOLORTABLETOOL_LOADCOLORTABLE_BUTTON, OnHsicolortabletoolLoadcolortableButton)
	ON_BN_CLICKED(IDC_HSICOLORTABLETOOL_SAVECOLORTABLE_BUTTON, OnHsicolortabletoolSavecolortableButton)
	ON_BN_CLICKED(IDC_HSICOLORTABLETOOL_CAPTURE_BUTTON1, OnHsicolortabletoolCaptureButton1)
	ON_BN_CLICKED(IDC_HSICOLORTABLETOOL_CAPTURE_BUTTON2, OnHsicolortabletoolCaptureButton2)
	ON_BN_CLICKED(IDC_HSICOLORTABLETOOL_CAPTURE_BUTTON3, OnHsicolortabletoolCaptureButton3)
	ON_BN_CLICKED(IDC_HSICOLORTABLETOOL_CAPTURE_BUTTON4, OnHsicolortabletoolCaptureButton4)
	ON_CBN_SELCHANGE(IDC_HSICOLORTABLETOOL_COLORCHOOSER, OnSelchangeHsicolortabletoolColorchooser)
	ON_BN_CLICKED(IDC_HSICOLORTABLETOOL_UPDATE_CHECK, OnHsicolortabletoolUpdateCheck)
	ON_WM_HSCROLL()
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


BOOL CHSIColorTableToolDlgBar::OnInitDialog() 
{
	CDynamicBarDlg::OnInitDialog();

  this->m_HmaxSlider.SetRange(0, 255, TRUE);
  this->m_HminSlider.SetRange(0, 255, TRUE);
  this->m_SmaxSlider.SetRange(0, 255, TRUE);
  this->m_SminSlider.SetRange(0, 255, TRUE);
  this->m_ImaxSlider.SetRange(0, 255, TRUE);
  this->m_IminSlider.SetRange(0, 255, TRUE);

 	CPaintDC dc(this);
	CDC dcMem;
  dcMem.CreateCompatibleDC(&dc);
	CBitmap hPalettePicture;
  hPalettePicture.CreateCompatibleBitmap(&dc, 340, 15);
	HBITMAP hBitmap = (HBITMAP)::LoadBitmap(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_HSICOLORTABLETOOL_HPALETTE_BITMAP));
  this->m_HPaletteBitmapFrame.SetBitmap(hBitmap);

  this->m_rgbImagePlace[0] = CPoint(10, 20);
  this->m_rgbImagePlace[1] = CPoint(200, 20);
  this->m_rgbImagePlace[2] = CPoint(390, 20);
  this->m_rgbImagePlace[3] = CPoint(580, 20);
  this->m_segmentedImagePlace[0] = CPoint(10, 215);
  this->m_segmentedImagePlace[1] = CPoint(200, 215);
  this->m_segmentedImagePlace[2] = CPoint(390, 215);
  this->m_segmentedImagePlace[3] = CPoint(580, 215);

  this->m_imageWidth = 176;
  this->m_imageHeight = 144;

  this->m_hsiColorChooser.SetCurSel(0);
  this->m_choosenColor = 0;

  this->m_hsiToolCore.init();

  this->setSlidersForColorClass(0);

  this->UpdateData(false);

  return TRUE;
}


void CHSIColorTableToolDlgBar::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
  for(int i=0; i < HSIColorTableToolCore::NUMBER_OF_IMAGES; i++)
  {
    if(this->m_hsiToolCore.isImageAtPlace[i])
    {
      ImageMethods::paintImage2CDCAsYUV(
        dc, this->m_hsiToolCore.originalYUVImages[i],
        CRect(this->m_rgbImagePlace[i].x, this->m_rgbImagePlace[i].y, 
              this->m_rgbImagePlace[i].x + 176, this->m_rgbImagePlace[i].y + 144 ) );
      ImageMethods::paintColorClassImage2CDC(
        dc, this->m_hsiToolCore.colorClassImages[i],
        CRect(this->m_segmentedImagePlace[i].x, this->m_segmentedImagePlace[i].y, 
              this->m_segmentedImagePlace[i].x + 176, this->m_segmentedImagePlace[i].y + 144 ) );

    }
  }
	
	// Kein Aufruf von CDynamicBarDlg::OnPaint() fr Zeichnungsnachrichten
}


void CHSIColorTableToolDlgBar::OnHsicolortabletoolLoadcolortableButton() 
{
	CFileDialog loadFileDlg(TRUE);

	char defpath[512];
	sprintf(defpath,"%s/Config/",File::getGTDir());
	loadFileDlg.m_ofn.lpstrInitialDir = defpath;
  loadFileDlg.m_ofn.lpstrFilter = "HSI colortable (.hsi)\0*.hsi";

	if(loadFileDlg.DoModal() == IDOK)
	{
		CString loadFile = loadFileDlg.GetPathName();
    int p = loadFile.ReverseFind('.');
    if(p != -1)
      loadFile = loadFile.Left(p);
		this->m_hsiToolCore.loadHSIColorTableFromFile(loadFile + ".hsi");
	}

  this->m_hsiColorChooser.SetCurSel(0);
  this->m_choosenColor = 0;
  this->setSlidersForColorClass(m_choosenColor);

  this->m_hsiToolCore.doImageSegmentation();

  this->UpdateData(false);
  Invalidate(false);
}


void CHSIColorTableToolDlgBar::OnHsicolortabletoolSavecolortableButton() 
{
	CFileDialog saveFileDlg(FALSE);

	char defpath[512];
	sprintf(defpath,"%s/Config/",File::getGTDir());
	saveFileDlg.m_ofn.lpstrInitialDir = defpath;
  saveFileDlg.m_ofn.lpstrFilter = "HSI colortable (.hsi)\0*.hsi";
	if(saveFileDlg.DoModal() == IDOK)
	{
		CString saveFile= saveFileDlg.GetPathName();
    int p(saveFile.ReverseFind('.'));
    if(p != -1)
      saveFile = saveFile.Left(p);
//		this->m_hsiToolCore.saveHSIColorTableToFile(saveFile + ".hsi");
		this->m_hsiToolCore.saveHSIColorTableToFile(saveFile);
//    this->m_hsiToolCore.createColorTable64FromHSIColorTable(this->m_hsiToolCore.colorTable64);
	}
	
}


void CHSIColorTableToolDlgBar::OnHsicolortabletoolCaptureButton1() 
{
	this->captureImageInPlace(0);
}

void CHSIColorTableToolDlgBar::OnHsicolortabletoolCaptureButton2() 
{
	this->captureImageInPlace(1);
}

void CHSIColorTableToolDlgBar::OnHsicolortabletoolCaptureButton3() 
{
  this->captureImageInPlace(2);
}

void CHSIColorTableToolDlgBar::OnHsicolortabletoolCaptureButton4() 
{
  this->captureImageInPlace(3);	

//  this->m_hsiToolCore.updateSegmentedImagesWithColorTable64();
//  Invalidate(false);
}


void CHSIColorTableToolDlgBar::OnSelchangeHsicolortabletoolColorchooser() 
{
  this->m_choosenColor = this->m_hsiColorChooser.GetCurSel();
  this->setSlidersForColorClass(m_choosenColor);
}

void CHSIColorTableToolDlgBar::OnHsicolortabletoolUpdateCheck() 
{
  //if possible, the left capture button has to be disabled/enabled depending 
  //of the check state
  if(this->m_updateImageFromQueue.GetCheck())
  {
    this->m_hsiToolCore.setImageToPlace(this->m_rawYUVImage, 0);
    this->m_captureButton1.ShowWindow(SW_HIDE);
  }
  else
  {
    this->m_captureButton1.ShowWindow(SW_SHOW);
  }
  Invalidate(false);
}

void CHSIColorTableToolDlgBar::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
  CString string;
  switch(pScrollBar->GetDlgCtrlID())
	{
	  case IDC_HSICOLORTABLETOOL_HMAX_SLIDER	:
        m_hsiToolCore.hsiColorTable.colorClasses[m_choosenColor].H_max = m_HmaxSlider.GetPos();
        string.Format("%i", m_HmaxSlider.GetPos());
  		  this->m_HmaxValue.SetWindowText(string);
        break;
	  case IDC_HSICOLORTABLETOOL_HMIN_SLIDER	:
        m_hsiToolCore.hsiColorTable.colorClasses[m_choosenColor].H_min = m_HminSlider.GetPos();
        string.Format("%i", m_HminSlider.GetPos());
  		  this->m_HminValue.SetWindowText(string); break;
	  case IDC_HSICOLORTABLETOOL_SMAX_SLIDER	:
        m_hsiToolCore.hsiColorTable.colorClasses[m_choosenColor].S_max = m_SmaxSlider.GetPos();
        string.Format("%i", m_SmaxSlider.GetPos());
  		  this->m_SmaxValue.SetWindowText(string); break;
	  case IDC_HSICOLORTABLETOOL_SMIN_SLIDER	:
        m_hsiToolCore.hsiColorTable.colorClasses[m_choosenColor].S_min = m_SminSlider.GetPos();
        string.Format("%i", m_SminSlider.GetPos());
  		  this->m_SminValue.SetWindowText(string); break;
	  case IDC_HSICOLORTABLETOOL_IMAX_SLIDER	:
        m_hsiToolCore.hsiColorTable.colorClasses[m_choosenColor].I_max = m_ImaxSlider.GetPos();
        string.Format("%i", m_ImaxSlider.GetPos());
  		  this->m_ImaxValue.SetWindowText(string); break;
	  case IDC_HSICOLORTABLETOOL_IMIN_SLIDER	:
        m_hsiToolCore.hsiColorTable.colorClasses[m_choosenColor].I_min = m_IminSlider.GetPos();
        string.Format("%i", m_IminSlider.GetPos());
  		  this->m_IminValue.SetWindowText(string); break;
		}


  this->m_hsiToolCore.doImageSegmentation();

  //ScrollBar released:
  //  create ColorTable64 from HSIColorTable;
  //  segment image with colorTable64;
  //  paint c64-segmented image to hsi tool;
  if(nSBCode == TB_THUMBPOSITION)
  {
//    MessageBox("Scrollbar losgelassen");
//    this->m_hsiToolCore.updateSegmentedImagesWithColorTable64();
  }

  Invalidate(false);
	
	CDynamicBarDlg::OnHScroll(nSBCode, nPos, pScrollBar);
}


void CHSIColorTableToolDlgBar::captureImageInPlace(int index)
{
  this->m_hsiToolCore.setImageToPlace(this->m_rawYUVImage, index);
//  this->m_hsiToolCore.updateSegmentedImagesWithColorTable64();
  Invalidate(false);
}

bool CHSIColorTableToolDlgBar::handleMessage(InMessage& message)
{
  if (message.getMessageID() == idImage)
  {
    message.bin >> m_rawYUVImage;
    if(this->m_updateImageFromQueue.GetCheck())
      this->captureImageInPlace(0);
    return true;
  }
  else
    return false;
}

void CHSIColorTableToolDlgBar::setSlidersForColorClass(int colorClass)
{
  this->m_HmaxSlider.SetPos(this->m_hsiToolCore.hsiColorTable.colorClasses[colorClass].H_max);
  this->m_HminSlider.SetPos(this->m_hsiToolCore.hsiColorTable.colorClasses[colorClass].H_min);
  this->m_SmaxSlider.SetPos(this->m_hsiToolCore.hsiColorTable.colorClasses[colorClass].S_max);
  this->m_SminSlider.SetPos(this->m_hsiToolCore.hsiColorTable.colorClasses[colorClass].S_min);
  this->m_ImaxSlider.SetPos(this->m_hsiToolCore.hsiColorTable.colorClasses[colorClass].I_max);
  this->m_IminSlider.SetPos(this->m_hsiToolCore.hsiColorTable.colorClasses[colorClass].I_min);

  CString string;
  string.Format("%i", m_hsiToolCore.hsiColorTable.colorClasses[colorClass].H_max);
  this->m_HmaxValue.SetWindowText(string);
  string.Format("%i", m_hsiToolCore.hsiColorTable.colorClasses[colorClass].H_min);
  this->m_HminValue.SetWindowText(string);
  string.Format("%i", m_hsiToolCore.hsiColorTable.colorClasses[colorClass].S_max);
  this->m_SmaxValue.SetWindowText(string);
  string.Format("%i", m_hsiToolCore.hsiColorTable.colorClasses[colorClass].S_min);
  this->m_SminValue.SetWindowText(string);
  string.Format("%i", m_hsiToolCore.hsiColorTable.colorClasses[colorClass].I_max);
  this->m_ImaxValue.SetWindowText(string);
  string.Format("%i", m_hsiToolCore.hsiColorTable.colorClasses[colorClass].I_min);
  this->m_IminValue.SetWindowText(string);
}


void CHSIColorTableToolDlgBar::OnLButtonDown(UINT nFlags, CPoint point) 
{
  CWnd* zoomWnd = this->GetWindow(IDD_DIALOG_HSICOLORTABLETOOL_ZOOM);
  if(zoomWnd != 0)
  {
    MessageBox("Es ist bereits ein Zoom-Fenster geffnet!");
  }
  else
  {
    int zoomImageIndex = -1;

    //RGB image 1 selected
    if((point.x >= this->m_rgbImagePlace[0].x) && (point.x <= this->m_rgbImagePlace[0].x + this->m_imageWidth)
      && (point.y >= this->m_rgbImagePlace[0].y) && (point.y <= this->m_rgbImagePlace[0].y + this->m_imageHeight))
    {
      zoomImageIndex = 0;
    }
    
    //RGB image 2 selected
    if(point.x >= this->m_rgbImagePlace[1].x && point.x <= this->m_rgbImagePlace[1].x + this->m_imageWidth
      && point.y >= this->m_rgbImagePlace[1].y && point.y <= this->m_rgbImagePlace[1].y + this->m_imageHeight)
    {
      zoomImageIndex = 1;
    }
    
    //RGB image 3 selected
    if(point.x >= this->m_rgbImagePlace[2].x && point.x <= this->m_rgbImagePlace[2].x + this->m_imageWidth
      && point.y >= this->m_rgbImagePlace[2].y && point.y <= this->m_rgbImagePlace[2].y + this->m_imageHeight)
    {
      zoomImageIndex = 2;
    }
    
    //RGB image 4 selected
    if(point.x >= this->m_rgbImagePlace[3].x && point.x <= this->m_rgbImagePlace[3].x + this->m_imageWidth
      && point.y >= this->m_rgbImagePlace[3].y && point.y <= this->m_rgbImagePlace[3].y + this->m_imageHeight)
    {
      zoomImageIndex = 3;
    }

    if(zoomImageIndex > -1 && this->m_hsiToolCore.isImageAtPlace[zoomImageIndex])
    {
      this->m_hsiToolZoomDialog.m_indexOfZoomedImage = zoomImageIndex;
      this->m_hsiToolZoomDialog.setHSIToolCore(&this->m_hsiToolCore);
      this->m_hsiToolZoomDialog.Create(IDD_DIALOG_HSICOLORTABLETOOL_ZOOM, this);
      this->m_hsiToolZoomDialog.m_colorChooser.SetCurSel(this->m_choosenColor);
      this->m_hsiToolZoomDialog.ShowWindow(SW_SHOW);
    }

  }
  
	CDynamicBarDlg::OnLButtonDown(nFlags, point);
}


/*
 * Change log :
 * 
 * $Log: HSIColorTableToolDlgBar.cpp,v $
 * Revision 1.4  2004/05/01 17:09:33  roefer
 * Streamlined HSI stuff
 *
 * Revision 1.3  2004/03/16 13:20:12  tim
 * Fixed bug in colortable conversion
 *
 * Revision 1.2  2004/01/17 17:07:41  roefer
 * HSI-Toolbar does not crash anymore, but image size is still 176x144
 *
 * Revision 1.1  2003/10/07 10:09:37  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.6  2003/05/11 23:46:33  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.5  2002/11/28 14:06:08  dueffert
 * docu improved
 *
 * Revision 1.4  2002/11/18 17:21:17  dueffert
 * RobotControl should be startable in any path now
 *
 * Revision 1.3  2002/09/18 16:35:13  loetzsch
 * made GT2003 compilable,
 * rechanged message ids
 *
 * Revision 1.2  2002/09/17 23:55:23  loetzsch
 * - unraveled several datatypes
 * - changed the WATCH macro
 * - completed the process restructuring
 *
 * Revision 1.1  2002/09/10 15:49:04  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.3  2002/07/23 13:43:36  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - empty constructors in bars / dialogs
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 *
 * Revision 1.2  2002/05/30 17:06:56  roefer
 * HSITool improved
 *
 * Revision 1.1.1.1  2002/05/10 12:40:20  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.7  2002/04/08 18:09:32  kspiess
 * verschwinden des ersten capture-button bei update eingebaut
 *
 * Revision 1.6  2002/04/05 08:14:40  kspiess
 * gleichzeitiges Speichern von HSI und C64 Farbtabelle eingebaut
 *
 * Revision 1.5  2002/02/11 00:53:33  loetzsch
 * ::Paint Methoden in ::paint umbenannt
 *
 * Revision 1.4  2002/02/08 14:24:41  kspiess
 * Funktionalitt fr das HSIColorTableTool eingebaut.
 * Neuen Zoom-Dialog fr das HSIColorTableTool integriert.
 *
 * Revision 1.3  2002/02/04 23:39:48  kspiess
 * Erste Teile der Funktionalitt fr das HSIColorTableTool eingebaut
 *
 * Revision 1.2  2002/01/14 22:37:39  loetzsch
 * Doxygen comment error fixed
 *
 * Revision 1.1  2002/01/13 14:12:02  kspiess
 * HSIColorTableTool-Dialog in RobotControl eingebaut; Implementierung der Funktionalitaet kommt bald
 *
 *
 */

