/**
* @file GridImageProcessor2DlgBar.h
*
* Declaration of class CGridImageProcessor2DlgBar
*
* @author Matthias Jngel
*/

#ifndef __GridImageProcessor2DlgBar_h_
#define __GridImageProcessor2DlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"
#include "Modules/ImageProcessor/GridImageProcessor2/GridImageProcessor2Parameters.h"

/**
* @class CGridImageProcessor2DlgBar 
* 
* A dialog bar to adjust parameters for the GridImageProcessor2
*/
class CGridImageProcessor2DlgBar : public CRobotControlDialogBar
{
public:
  /**
  * Default constructor.
  */
  CGridImageProcessor2DlgBar();

	~CGridImageProcessor2DlgBar();   
  
  /** 
  * Called from a MessageQueue to distribute messages 
  * @param message The message that can be read.
  * @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message);

	//{{AFX_DATA(CGridImageProcessor2DlgBar)
	enum { IDD = IDD_DIALOG_BAR_GRID_IMAGE_PROCESSOR_2 };
	CButton	m_autoColorCalibrationCheck;
	CButton	m_autoThresholdCalibrationCheck;
	CButton	m_longScanLinesOnlyCheck;
	CButton	m_resetColorCalibrationCheck;
	CButton	m_setColorTableToDefaultCheck;
	CEdit	m_spacingEdit;
	CSliderCtrl	m_spacingSlider;
	CButton	m_fixedHorizonCheck;
	CButton	m_receiveParametersCheck;
	CButton	m_sendOnChangeCheck;
	CButton	m_loadButton;
  CButton	m_sendButton;
	CButton	m_saveButton;
	CSliderCtrl	m_thresholdYSlider;
	CSliderCtrl	m_thresholdUSlider;
	CSliderCtrl	m_thresholdVSlider;
	CEdit	m_thresholdYEdit;
	CEdit	m_thresholdUEdit;
	CEdit	m_thresholdVEdit;
	//}}AFX_DATA


	//{{AFX_VIRTUAL(CGridImageProcessor2DlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    
  virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL

protected:

	//{{AFX_MSG(CGridImageProcessor2DlgBar)
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnSaveButton();
	afx_msg void OnLoadButton();
	afx_msg void OnSendButton();
	afx_msg void OnReceiveParametersCheck();
	afx_msg void OnSendOnChangeCheck();
	afx_msg void OnAutoColorCalibrationCheck();
	afx_msg void OnAutoThresholdCalibrationCheck();
	afx_msg void OnLongScanLinesOnlyCheck();
	afx_msg void OnResetColorCalibrationCheck();
	afx_msg void OnSetColorTableToDefaultCheck();
	afx_msg void OnUseFixedHorizonCheck();
	afx_msg void OnChangeValue();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();
private:
	void setSliders();
  void load();
  void save();
  void sendParameters();

  bool sendOnChange;
  bool receiveParameters;
  GridImageProcessor2Parameters parameters;
};

//{{AFX_INSERT_LOCATION}}

#endif //__GridImageProcessor2DlgBar_h_

/*
 * Change log :
 * 
 * $Log: GridImageProcessor2DlgBar.h,v $
 * Revision 1.2  2003/11/07 11:21:19  juengel
 * GridImageProcessor2 has more parameters now.
 *
 * Revision 1.1  2003/10/07 10:09:37  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.3  2003/08/25 17:24:02  juengel
 * Removed unused functions
 *
 * Revision 1.2  2003/08/18 12:08:42  juengel
 * Removed some parameters.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.4  2003/05/11 23:46:33  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.3  2003/05/05 12:24:44  juengel
 * Moved GridImageProcessor2Parameters from DataTypes.
 * Changed GridImageProcessor2Parameters.
 *
 * Revision 1.2  2003/03/15 13:29:57  juengel
 * Added checkBox "useColorTable" to GridImageProcessor2DlgBar.
 *
 * Revision 1.1  2003/03/04 14:56:32  juengel
 * Added GridImageProcessor2DlgBar
 *
 *
 */
