/**
* @file GridImageProcessor2DlgBar.cpp
*
* Implementation of class CGridImageProcessor2DlgBar
*
* @author Matthias Jngel
*/

#include "StdAfx.h"
#include "GridImageProcessor2DlgBar.h"
#include "RobotControlQueues.h"
#include "RobotControlDebugKeyTables.h"


CGridImageProcessor2DlgBar::CGridImageProcessor2DlgBar()
: CRobotControlDialogBar(IDD)
{
  //{{AFX_DATA_INIT(CGridImageProcessor2DlgBar)
	//}}AFX_DATA_INIT
}

CGridImageProcessor2DlgBar::~CGridImageProcessor2DlgBar()
{
}


void CGridImageProcessor2DlgBar::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CGridImageProcessor2DlgBar)
	DDX_Control(pDX, IDC_GIP2_AUTO_COLOR_CALIBRATION_CHECK, m_autoColorCalibrationCheck);
	DDX_Control(pDX, IDC_GIP2_AUTO_THRESHOLD_CALIBRATION_CHECK, m_autoThresholdCalibrationCheck);
	DDX_Control(pDX, IDC_GIP2_LONG_SCAN_LINES_ONLY_CHECK, m_longScanLinesOnlyCheck);
	DDX_Control(pDX, IDC_GIP2_RESET_COLOR_CALIBRATION_CHECK, m_resetColorCalibrationCheck);
	DDX_Control(pDX, IDC_GIP2_SET_COLOR_TABLE_TO_DEFAULT_CHECK, m_setColorTableToDefaultCheck);
	DDX_Control(pDX, IDC_GIP2_SPACING_EDIT, m_spacingEdit);
	DDX_Control(pDX, IDC_GIP2_SPACING_SLIDER, m_spacingSlider);
	DDX_Control(pDX, IDC_GIP2_USE_FIXED_HORIZON_CHECK, m_fixedHorizonCheck);
	DDX_Control(pDX, IDC_GIP2_RECEIVE_PARAMETERS_CHECK, m_receiveParametersCheck);
	DDX_Control(pDX, IDC_GIP2_SEND_ON_CHANGE_CHECK, m_sendOnChangeCheck);
	DDX_Control(pDX, IDC_GIP2_LOAD_BUTTON, m_loadButton);
	DDX_Control(pDX, IDC_GIP2_SEND_BUTTON, m_sendButton);
	DDX_Control(pDX, IDC_GIP2_SAVE_BUTTON, m_saveButton);
	DDX_Control(pDX, IDC_GIP2_THRESHOLD_Y_SLIDER, m_thresholdYSlider);
	DDX_Control(pDX, IDC_GIP2_THRESHOLD_U_SLIDER, m_thresholdUSlider);
	DDX_Control(pDX, IDC_GIP2_THRESHOLD_V_SLIDER, m_thresholdVSlider);
	DDX_Control(pDX, IDC_GIP2_THRESHOLD_Y_EDIT, m_thresholdYEdit);
	DDX_Control(pDX, IDC_GIP2_THRESHOLD_U_EDIT, m_thresholdUEdit);
	DDX_Control(pDX, IDC_GIP2_THRESHOLD_V_EDIT, m_thresholdVEdit);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGridImageProcessor2DlgBar, CDynamicBarDlg)
//{{AFX_MSG_MAP(CGridImageProcessor2DlgBar)
ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_GIP2_SAVE_BUTTON, OnSaveButton)
	ON_BN_CLICKED(IDC_GIP2_LOAD_BUTTON, OnLoadButton)
	ON_BN_CLICKED(IDC_GIP2_SEND_BUTTON, OnSendButton)
	ON_BN_CLICKED(IDC_GIP2_RECEIVE_PARAMETERS_CHECK, OnReceiveParametersCheck)
	ON_BN_CLICKED(IDC_GIP2_SEND_ON_CHANGE_CHECK, OnSendOnChangeCheck)
	ON_BN_CLICKED(IDC_GIP2_AUTO_COLOR_CALIBRATION_CHECK, OnAutoColorCalibrationCheck)
	ON_BN_CLICKED(IDC_GIP2_AUTO_THRESHOLD_CALIBRATION_CHECK, OnAutoThresholdCalibrationCheck)
	ON_BN_CLICKED(IDC_GIP2_LONG_SCAN_LINES_ONLY_CHECK, OnLongScanLinesOnlyCheck)
	ON_BN_CLICKED(IDC_GIP2_RESET_COLOR_CALIBRATION_CHECK, OnResetColorCalibrationCheck)
	ON_BN_CLICKED(IDC_GIP2_SET_COLOR_TABLE_TO_DEFAULT_CHECK, OnSetColorTableToDefaultCheck)
	ON_BN_CLICKED(IDC_GIP2_USE_FIXED_HORIZON_CHECK, OnUseFixedHorizonCheck)
	ON_EN_KILLFOCUS(IDC_GIP2_THRESHOLD_Y_EDIT, OnChangeValue)
	ON_EN_KILLFOCUS(IDC_GIP2_THRESHOLD_U_EDIT, OnChangeValue)
	ON_EN_KILLFOCUS(IDC_GIP2_THRESHOLD_V_EDIT, OnChangeValue)
	ON_EN_KILLFOCUS(IDC_GIP2_SPACING_EDIT, OnChangeValue)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


BOOL CGridImageProcessor2DlgBar::OnInitDialog() 
{
  CDynamicBarDlg::OnInitDialog();

  receiveParameters = false;
  sendOnChange = true;

  m_thresholdYSlider.SetRange(0,255);
  m_thresholdUSlider.SetRange(0,255);
  m_thresholdVSlider.SetRange(0,255);
  m_spacingSlider.SetRange(1,100);

  load();
  setSliders();
  return TRUE;
}

bool CGridImageProcessor2DlgBar::handleMessage(InMessage& message)
{
  if (message.getMessageID() == idParametersFromGridImageProcessor2)
  {
    message.bin >> parameters;
    setSliders();

    return true;
  }
  return false;
}


void CGridImageProcessor2DlgBar::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)  
{
  parameters.threshold[0] = m_thresholdYSlider.GetPos();
  parameters.threshold[1] = m_thresholdUSlider.GetPos();
  parameters.threshold[2] = m_thresholdVSlider.GetPos();
  parameters.scanLineSpacing = m_spacingSlider.GetPos();

  setSliders();
  if(sendOnChange) sendParameters();

  CDynamicBarDlg::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CGridImageProcessor2DlgBar::setSliders()
{
  m_thresholdYSlider.SetPos(parameters.threshold[0]);
  m_thresholdUSlider.SetPos(parameters.threshold[1]);
  m_thresholdVSlider.SetPos(parameters.threshold[2]);
  m_spacingSlider.SetPos(parameters.scanLineSpacing);

  CString string;
  string.Format("%d", parameters.threshold[0]); m_thresholdYEdit.SetWindowText(string);
  string.Format("%d", parameters.threshold[1]); m_thresholdUEdit.SetWindowText(string);
  string.Format("%d", parameters.threshold[2]); m_thresholdVEdit.SetWindowText(string);
  string.Format("%d", parameters.scanLineSpacing); m_spacingEdit.SetWindowText(string);
}

void CGridImageProcessor2DlgBar::save()
{
  	char filename[512];
  	sprintf(filename,"%s/Config/gi2param.cfg",File::getGTDir());
    OutTextFile paramsFile(filename);
    paramsFile << parameters;
}

void CGridImageProcessor2DlgBar::load()
{
  char filename[512];
  sprintf(filename,"%s/Config/gi2param.cfg",File::getGTDir());
  InTextFile paramsFile(filename);
  if (paramsFile.exists())
  {
    paramsFile >> parameters;
  }
  else 
  { 
    getQueues().toGUI.out.text << "GridImageProcessor2DlgBar could not load gi2param.cfg"; 
    getQueues().toGUI.out.finishMessage(idText);
  }
  
  setSliders();
  m_fixedHorizonCheck.SetCheck(parameters.useFixedHorizon);
  m_longScanLinesOnlyCheck.SetCheck(parameters.useLongScanLinesOnly);
  m_autoColorCalibrationCheck.SetCheck(parameters.enableAutoColorCalibration);
  m_autoThresholdCalibrationCheck.SetCheck(parameters.enableThresholdCalibration);
  m_resetColorCalibrationCheck.SetCheck(parameters.resetAutoCalibration);
  m_setColorTableToDefaultCheck.SetCheck(parameters.setColorTableToDefault);
  m_sendOnChangeCheck.SetCheck(sendOnChange);
  m_receiveParametersCheck.SetCheck(receiveParameters);
}

void CGridImageProcessor2DlgBar::sendParameters()
{
  getQueues().toPhysical.selectedRobot.out.bin << parameters;
  getQueues().toPhysical.selectedRobot.out.finishMessage(idParametersForGridImageProcessor2);

  getQueues().toSimulated.selectedRobot.out.bin << parameters;
  getQueues().toSimulated.selectedRobot.out.finishMessage(idParametersForGridImageProcessor2);
}

void CGridImageProcessor2DlgBar::OnSaveButton() 
{
  save();
}

void CGridImageProcessor2DlgBar::OnLoadButton() 
{
  load();
}

void CGridImageProcessor2DlgBar::OnSendButton() 
{
  sendParameters();
}

void CGridImageProcessor2DlgBar::OnReceiveParametersCheck() 
{
/*  if(m_receiveParametersCheck.GetCheck()) receiveParameters = true;
  else receiveParameters = false;

  if(receiveParameters)
    getDebugKeyTables().forPhysicalRobots.set(DebugKeyTable::sendColorTableReferenceColor, DebugKey::always);
  else
    getDebugKeyTables().forPhysicalRobots.set(DebugKeyTable::sendColorTableReferenceColor, DebugKey::disabled);

  if(receiveParameters)
    getDebugKeyTables().forSimulatedRobots.set(DebugKeyTable::sendColorTableReferenceColor, DebugKey::always);
  else
    getDebugKeyTables().forSimulatedRobots.set(DebugKeyTable::sendColorTableReferenceColor, DebugKey::disabled);

  getDebugKeyTables().sendForPhysicalRobots();
  getDebugKeyTables().sendForSimulatedRobots();
*/
}

void CGridImageProcessor2DlgBar::OnSendOnChangeCheck() 
{
  if(m_sendOnChangeCheck.GetCheck()) sendOnChange = true;
  else sendOnChange = false;
  if(sendOnChange) sendParameters();
}



void CGridImageProcessor2DlgBar::OnAutoColorCalibrationCheck() 
{
  if(m_autoColorCalibrationCheck.GetCheck()) parameters.enableAutoColorCalibration = true;
  else parameters.enableAutoColorCalibration = false;
  if(sendOnChange) sendParameters();
}

void CGridImageProcessor2DlgBar::OnAutoThresholdCalibrationCheck() 
{
  if(m_autoThresholdCalibrationCheck.GetCheck()) parameters.enableThresholdCalibration = true;
  else parameters.enableThresholdCalibration = false;
  if(sendOnChange) sendParameters();
}

void CGridImageProcessor2DlgBar::OnLongScanLinesOnlyCheck() 
{
  if(m_longScanLinesOnlyCheck.GetCheck()) parameters.useLongScanLinesOnly = true;
  else parameters.useLongScanLinesOnly = false;
  if(sendOnChange) sendParameters();
}

void CGridImageProcessor2DlgBar::OnResetColorCalibrationCheck() 
{
  if(m_resetColorCalibrationCheck.GetCheck()) parameters.resetAutoCalibration = true;
  else parameters.resetAutoCalibration = false;
  if(sendOnChange) sendParameters();
}

void CGridImageProcessor2DlgBar::OnSetColorTableToDefaultCheck() 
{
  if(m_setColorTableToDefaultCheck.GetCheck()) parameters.setColorTableToDefault = true;
  else parameters.setColorTableToDefault = false;
  if(sendOnChange) sendParameters();
}

void CGridImageProcessor2DlgBar::OnUseFixedHorizonCheck() 
{
  if(m_fixedHorizonCheck.GetCheck()) parameters.useFixedHorizon = true;
  else parameters.useFixedHorizon = false;
  if(sendOnChange) sendParameters();
}

void CGridImageProcessor2DlgBar::OnChangeValue()
{
  CString string[4];
  m_thresholdYEdit.GetWindowText(string[0]);
  m_thresholdUEdit.GetWindowText(string[1]);
  m_thresholdVEdit.GetWindowText(string[2]);
  m_spacingEdit.GetWindowText(string[3]);

  sscanf(string[0].GetBuffer(string[0].GetLength()), "%d", &(parameters.threshold[0]));
  sscanf(string[1].GetBuffer(string[1].GetLength()), "%d", &(parameters.threshold[1]));
  sscanf(string[2].GetBuffer(string[2].GetLength()), "%d", &(parameters.threshold[2]));
  sscanf(string[3].GetBuffer(string[3].GetLength()), "%d", &(parameters.scanLineSpacing));
 
  setSliders();
  if(sendOnChange) sendParameters();
}



/*
* Change log :
* 
* $Log: GridImageProcessor2DlgBar.cpp,v $
* Revision 1.5  2003/12/09 19:49:25  loetzsch
* Renamed some of the main queues of RobotControl.
*
* Added possibility to send messages to specific simulated or physical robots.
*
* Revision 1.4  2003/11/10 11:32:00  juengel
* sendOnChange is initialized with true
*
* Revision 1.3  2003/11/07 11:21:19  juengel
* GridImageProcessor2 has more parameters now.
*
* Revision 1.2  2003/10/23 07:24:21  juengel
* Renamed ColorTableAuto to ColorTableReferenceColor.
*
* Revision 1.1  2003/10/07 10:09:37  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.3  2003/08/25 17:24:02  juengel
* Removed unused functions
*
* Revision 1.2  2003/08/18 12:08:42  juengel
* Removed some parameters.
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.6  2003/05/11 23:46:33  dueffert
* Depend now works with RobotControl too
*
* Revision 1.5  2003/05/05 12:24:44  juengel
* Moved GridImageProcessor2Parameters from DataTypes.
* Changed GridImageProcessor2Parameters.
*
* Revision 1.4  2003/03/23 19:11:06  loetzsch
* OUTPUT not allowed in the RobotControl thread anymore.
* Use getQueues().toGUI.out instead.
*
* Revision 1.3  2003/03/15 13:29:57  juengel
* Added checkBox "useColorTable" to GridImageProcessor2DlgBar.
*
* Revision 1.2  2003/03/05 17:09:27  loetzsch
* redesign of the queues and debug key tables in RobotControl
*
* Revision 1.1  2003/03/04 14:56:32  juengel
* Added GridImageProcessor2DlgBar
*
*
*/
