/**
* @file ColorTable64DlgBar.h
*
* Declaration of class CColorTable64DlgBar
*
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Jngel</a>
*/

#ifndef __ColorTable64DlgBar_h_
#define __ColorTable64DlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"

#include "Representations/Perception/Image.h"
#include "Representations/Perception/ColorTable64.h"

/**
* @class CColorTable64DlgBar 
* 
* A color calibration tool.
*/
class CColorTable64DlgBar : public CRobotControlDialogBar
{
public:
  /**
  * Default constructor.
  */
  CColorTable64DlgBar();

  ~CColorTable64DlgBar();   

	//{{AFX_DATA(CColorTable64DlgBar)
	enum { IDD = IDD_DIALOG_BAR_COLORTABLE64 };
	CButton	m_selectedColorOnlyCheck;
	CButton	m_sendButton;
	CSliderCtrl	m_rangeSlider;
	CStatic	m_rangeStatic;
	CSliderCtrl	m_penSlider;
	CStatic	m_penStatic;
	CComboBox	m_ct64ColorClassCombo;
  CButton m_automedian;
  CButton m_medianAllColors;
  CButton m_medianAllowReassign;
  CButton m_autoremove;
	CSliderCtrl	m_medianRangeSlider;
	CSliderCtrl	m_medianDistanceSlider;
	CSliderCtrl	m_medianNeighbourSlider;
	CStatic	m_medianRangeStatic;
	CStatic	m_medianDistanceStatic;
	CStatic	m_medianNeighbourStatic;
  CComboBox m_ct64ImageCombo;
  CButton m_highRes;
	//}}AFX_DATA

  /** 
  * Called from a MessageQueue to distribute messages 
  * @param message The message that can be read.
  * @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message);


	//{{AFX_VIRTUAL(CColorTable64DlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    
  virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL

protected:

	//{{AFX_MSG(CColorTable64DlgBar)
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnCt64ClearColorTable();
	afx_msg void OnCt64ClearChannel();
	afx_msg void OnCt64Open();
	afx_msg void OnCt64Save();
	afx_msg void OnSelchangeCt64ColorClassCombo();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnCt64Undo();
	afx_msg void OnCt64SendToRobot();
  afx_msg void OnCt64Remove();
  afx_msg void OnCt64Median();
	afx_msg void OnClearChannelInImage();
	afx_msg void OnSelectedColorOnly();
  afx_msg void OnSelchangeCt64ImageCombo();
  afx_msg void OnMouseMove(UINT nFlags, CPoint point);
  afx_msg void OnCapture1();
  afx_msg void OnCapture2();
  afx_msg void OnCapture3();
  afx_msg void OnCapture4();
  afx_msg void OnHighRes();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();
private:
  void generateSegmentedImage();
  void sendLocal();
  void setClickRangeSlider(unsigned char newPosition);
  void setPenSlider(unsigned char newPosition);
  void setMedianRangeSlider(unsigned char newPosition);
  void setMedianDistanceSlider(unsigned char newPosition);
  void setMedianNeighbourSlider(unsigned char newPosition);

//  void removeColor();
  void smoothImage();
  void removeColorClassFromImage();

  Image rawImage[5];
  ColorClassImage segmentedImage[5];
  bool imageCaptured[5];

  bool useHighRes;

  ColorTable64 colorTable;
  ColorTable64 previousColorTable; // for undo

  bool repaintRawImage;
  bool repaintSegmentedImage;
  bool undoColorTablePossible; // for undo

  colorClass selectedColorClass;
  unsigned char clickRange;
  unsigned char penSize;

  unsigned char medianRange;
  unsigned char medianDistance;
  unsigned char medianNeighbour;

  bool showSelectedColorClassOnly;

  int xPosRawImage[5];
  int yPosRawImage;

  int xPosSegmentedImage[5];
  int yPosSegmentedImage;

  int debugImageID;

  int xPosPreviewPixel[5];
  int yPosPreviewPixel[5];
};

//{{AFX_INSERT_LOCATION}}

#endif //__ColorTable64DlgBar_h_

/*
 * Change log :
 * 
 * $Log: ColorTable64DlgBar.h,v $
 * Revision 1.7  2004/04/07 13:00:46  risler
 * ddd checkin after go04 - second part
 *
 * Revision 1.2  2004/04/05 14:58:34  risler
 * colortable dialog now can show both resolutions
 *
 * Revision 1.1.1.1  2004/03/29 08:28:44  Administrator
 * initial transfer from tamara
 *
 * Revision 1.6  2004/03/28 18:39:36  risler
 * colortable64 dialog multiple image support
 *
 * Revision 1.5  2004/03/18 15:03:50  risler
 * added pixel preview
 *
 * Revision 1.4  2004/03/18 10:35:36  risler
 * simplified image selection
 *
 * Revision 1.3  2004/03/17 17:24:47  risler
 * ColorTable64Dlg can segment debug images
 *
 * Revision 1.2  2004/01/04 16:36:41  juengel
 * adaptation for larger images
 *
 * Revision 1.1  2003/10/07 10:09:37  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 15:28:23  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.6  2003/05/11 23:46:32  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.5  2003/04/16 17:46:46  juengel
 * clean up in ColorTable64DlgBar
 *
 * Revision 1.4  2003/04/15 15:52:09  risler
 * DDD GO 2003 code integrated
 *
 * Revision 1.3  2003/04/07 21:13:10  Charlie
 * added more functionality to ct64 dialog
 *
 * Revision 1.3  2003/04/14 16:17:07  loetzsch
 * ATH after GermanOpen CVS merge
 *
 * improved dialog
 *
 * Revision 1.2  2003/04/10 07:57:58  juengel
 * no message
 *
 * Revision 1.2  2002/09/20 23:28:34  juengel
 * Moved instance of DebugDrawingManager to RobotControlMainFrame.
 *
 * Revision 1.1  2002/09/10 15:49:04  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.3  2002/08/30 17:13:55  dueffert
 * doxygen parser bugs fixed, docu added
 *
 * Revision 1.2  2002/07/23 13:43:36  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - empty constructors in bars / dialogs
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 *
 * Revision 1.1.1.1  2002/05/10 12:40:20  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.11  2002/04/23 17:45:17  loetzsch
 * - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
 * - removed Modules Toolbar
 * - removed access for dialogs and toolbars to solutionRequest.
 * - changed access for dialogs and toolbars to debug queues
 * - removed the instance of SolutionRequest in CRobotControlApp
 * - only the log player, local processes and the robot put messages into queueToRobotControl
 *
 * Revision 1.10  2002/03/22 16:56:39  loetzsch
 * added a send to robot button to the color table 64 tool
 *
 * Revision 1.9  2002/02/12 16:34:49  risler
 * finished MofTester
 *
 * Revision 1.8  2002/02/07 16:27:12  loetzsch
 * colortables are sent twice on every change of the color table
 * for synchronization with the processes
 *
 * Revision 1.7  2002/01/19 21:36:26  risler
 * added HeadMotionTester, HeadControlSelector
 *
 * Revision 1.6  2002/01/15 13:50:34  bach
 * Undo button in color table tool added (Joscha)
 *
 * Revision 1.5  2001/12/20 19:19:52  juengel
 * Slider eingebaut
 *
 * Revision 1.4  2001/12/20 14:36:34  juengel
 * Methoden zum Zeichnen der ColorTable zeichnen jetzt in Bitmaps und nicht mehr in CDCs
 *
 * Revision 1.3  2001/12/19 10:45:21  juengel
 * An der Anzeige gefrickelt.
 *
 * Revision 1.2  2001/12/17 19:22:58  juengel
 * Grundfunktionalitt hergestellt.
 *
 * Revision 1.1  2001/12/15 19:26:13  juengel
 * ColorTable, ColorTable64, ColorTable64DlgBar hinzugefgt.
 *
 *
 */
