/**
* @file CameraParametersToolBar.h
* 
* Definition of the camera parameters toolbar.
*
* @author Joscha Bach
* @author Martin Ltzsch
*/

#ifndef __CameraParametersToolBar_h_ 
#define __CameraParametersToolBar_h_ 

#include "StdAfx.h"
#include "RobotControlToolBar.h"
#include "Representations/Perception/CameraParameters.h"

/**
* @class CCameraParametersToolBar
* A ToolBar for selecting camera parameters
*/
class CCameraParametersToolBar : public CRobotControlToolBar
{
  DECLARE_DYNAMIC( CCameraParametersToolBar );
public:
    /** Initializes the tool bar */
  virtual void Init(); 

  /** 
  * Handles control notifications which arrived in the main frame 
  * @param command The id of the control, menu, accelerator etc.
  * @return If the command was handled.
  */
  virtual bool handleCommand(UINT command);

  /** 
  * Handles selection change events for combo boxes. That function must be called from the 
  * main frame window for all combo boxes of the toolbar. 
  * @param nID the command id of the combo box
  * @return if the message was handled
  */
  virtual bool handleSelChange(UINT nID);

protected:
  /** Sends the parameters */
  void send();

  /** Determines if the buttons have a text */
  virtual bool HasButtonText( UINT nID );

private:
  /** The edited CameraParameters */
  CameraParameters cameraParameters;

  /** A combo for the white balance */
  CComboBox m_wndWhiteBalanceCombo;

  /** A combo for the shutter speed */
  CComboBox m_wndShutterSpeedCombo;

  /** A combo for the gain */
  CComboBox m_wndGainCombo;

  CStatic label1, label2, label3;
};


#endif //__CameraParametersToolBar_h_ 
/*
* Change log :
* 
* $Log: CameraParametersToolBar.h,v $
* Revision 1.3  2004/02/23 13:27:25  jhoffman
* - changes to Main-menu are shown ... this currently results in one additional menu (!) somebody please fix this!
* - added GenericModalBinary-dialog: can be used to create a modal dialog where you can specify the button labels and the descriptive text (like APX...ModalDialog but you can specify what is written on the buttons)
* - CameraToolBar: mode, shutter, gain extracted from dropdown
* - ToolBarEx: added AddString method to write const. strings on a toolbar
*
* Revision 1.2  2003/12/06 06:31:20  loetzsch
* no message
*
* Revision 1.1  2003/10/07 10:09:37  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/26 15:28:23  juengel
* Renamed DataTypes to representations.
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.2  2003/05/11 23:46:32  dueffert
* Depend now works with RobotControl too
*
* Revision 1.1  2002/09/10 15:49:04  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.5  2002/08/30 17:13:55  dueffert
* doxygen parser bugs fixed, docu added
*
* Revision 1.4  2002/08/13 12:55:10  loetzsch
* - Added base class CRobotControlToolBar for tool bars
* - Moved command handling from CRobotControlMainFrame to the tool bars
*
* Revision 1.3  2002/07/23 13:43:36  loetzsch
* - new streaming classes
* - removed many #include statements
* - 5 instead of 3 debug queues in RobotControl
* - exchanged StaticQueue with MessageQueue
* - new debug message handling
* - empty constructors in bars / dialogs
* - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
* - general clean up
*
* Revision 1.2  2002/06/10 12:00:41  dueffert
* commentation bugs fixed
*
* Revision 1.1.1.1  2002/05/10 12:40:20  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.5  2002/04/23 17:45:17  loetzsch
* - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
* - removed Modules Toolbar
* - removed access for dialogs and toolbars to solutionRequest.
* - changed access for dialogs and toolbars to debug queues
* - removed the instance of SolutionRequest in CRobotControlApp
* - only the log player, local processes and the robot put messages into queueToRobotControl
*
* Revision 1.4  2001/12/14 17:05:15  loetzsch
* CameraParameters Toolbar fertig
*
* Revision 1.3  2001/12/14 12:26:12  loetzsch
* CameraParameters Toolbar weitergemacht
*
* Revision 1.2  2001/12/13 17:20:39  loetzsch
* CameraParameters Toolbar weitergemacht
*
* Revision 1.1  2001/12/13 15:36:44  loetzsch
* CameraParameters Toolbar
*
*
*/
