/**
 * @file SoundRequest.h
 * 
 * Declaration of class SoundRequest
 * 
 * @author Oliver Giese
 *
 */ 
#ifndef __SoundRequest_h_
#define __SoundRequest_h_

#include "Platform/SystemCall.h"

#include "Tools/Streams/InOut.h"

/** 
* @class SoundRequest 
*
* Represents an acoustic message
*/
class SoundRequest
{
public:
  /** 
  ** ids for all acoustic message Ids
  ** signals have to be enumerated first
  **/
  enum SoundID{
    none,
      test,
      bark1,
      bark2,
      bark3,
      hurtdog,
      howl,
      growl,
      startMe,
      ring,
      space,
      bing01,
      bing02,
      bing03,
      bing04,
      bing05,
      bing06,
      bing07,
      rob001,
      rob002,
      rob003,
      rob004,
      rob005,
      rob006,
      rob101,
			okay,
			notokay,
      accuracy,
      impressive,
      excellent,
    numOfSoundIDs
  };

  static const char* getSoundIDName(SoundID id)
  {
    switch (id)
    {
    case none: return "none";
    case test: return "test";
    case bark1: return "bark1";
    case bark2: return "bark2";
    case bark3: return "bark3";
    case hurtdog: return "hurtdog";
    case howl: return "howl";
    case growl: return "growl";
    case startMe: return "startMe";
    case ring: return "ring";
    case space: return "space";
    case bing01: return "bing01";
    case bing02: return "bing02";
    case bing03: return "bing03";
    case bing04: return "bing04";
    case bing05: return "bing05";
    case bing06: return "bing06";
    case bing07: return "bing07";
    case rob001: return "rob001";
    case rob002: return "rob002";
    case rob003: return "rob003";
    case rob004: return "rob004";
    case rob005: return "rob005";
    case rob006: return "rob006";
    case rob101: return "rob101";
    case okay: return "okay";
    case notokay: return "notokay";
    case accuracy: return "accuracy";
    case impressive: return "imprssve";
    case excellent: return "xcellent";
    default: return "please edit SoundRequest::getSoundRequestName";
    }
  }

  /** constructor */
  SoundRequest() 
    :soundID(none)
  {
  }
  
  bool operator==(const SoundRequest& other) const
  {
    return (soundID == other.soundID);
  }

  bool operator!=(const SoundRequest& other) const
  { return !(*this==other); }

  /** the id of the request */
  SoundID soundID;
};

/**
 * Streaming operator that reads a SoundRequest from a stream.
 * @param stream The stream from which is read.
 * @param soundRequest The SoundRequest object.
 * @return The stream.
 */ 
In& operator>>(In& stream,SoundRequest& soundRequest);
 
/**
 * Streaming operator that writes a SoundRequest to a stream.
 * @param stream The stream to write on.
 * @param soundRequest The SoundRequest object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const SoundRequest& soundRequest);



#endif //__SoundRequest_h_

/*
 * Change log :
 * 
 * $Log: SoundRequest.h,v $
 * Revision 1.3  2004/02/26 16:42:19  kindler
 * added some sounds.
 *
 * Revision 1.2  2003/12/09 16:27:14  jhoffman
 * "okay" and "notokay" sounds added
 *
 * Revision 1.1  2003/10/07 10:09:36  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/07/03 14:43:17  risler
 * new sounds
 *
 * Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.7  2003/06/19 12:11:30  juengel
 * Removed some Sounds.
 *
 * Revision 1.6  2003/06/18 18:12:36  goehring
 * Sounds added
 *
 * Revision 1.5  2003/04/15 15:52:12  risler
 * DDD GO 2003 code integrated
 *
 * Revision 1.4  2003/04/06 12:32:44  max
 * added ddd sound stuff
 *
 * Revision 1.4  2003/04/06 13:22:15  wachter
 * added startMe.wav
 *
 * Revision 1.3  2002/11/28 18:56:28  juengel
 * Added some sounds
 *
 * Revision 1.2  2002/11/18 17:30:31  loetzsch
 * Sound requests generated from BehaviorControl are now automatically sent
 * to RobotControl and played there.
 *
 * Revision 1.1  2002/09/10 15:26:41  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.11  2002/07/23 13:32:56  loetzsch
 * new streaming classes
 *
 * removed many #include statements
 *
 * Revision 1.10  2002/06/03 19:20:49  dueffert
 * sound only once
 *
 * Revision 1.9  2002/06/03 18:54:43  dueffert
 * messagetype in AcousticMessage is now private
 *
 * Revision 1.8  2002/05/27 16:16:57  schley
 * ballposition can be transmitted
 *
 * Revision 1.7  2002/05/22 13:47:18  fischer
 * Changed SoundInProcessor interface to accept WorldState
 *
 * Revision 1.6  2002/05/21 15:43:03  hebbel
 * acoustic signals can be detected now
 *
 * Revision 1.5  2002/05/21 11:43:09  hebbel
 * Changed order of acousticIDs, added transmitBallposition
 *
 * Revision 1.4  2002/05/17 11:21:20  fischer
 * ball position exchange via acoustic communication
 *
 * Revision 1.3  2002/05/15 07:26:05  hebbel
 * Wavefiles for patternchallenge can be played
 *
 * Revision 1.2  2002/05/13 13:30:23  schley
 * Added signals
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.3  2002/05/06 15:06:12  schley
 * Added another Signal
 *
 * Revision 1.2  2002/05/03 13:46:30  giese
 * Added timestamp to AcousticMessage
 *
 * Revision 1.1  2002/04/28 19:09:52  giese
 * SoundPlay added...
 *
 */
