/**
 * @file SoundRequest.cpp
 * 
 * Implementation of class SoundRequest
 * 
 * @author Oliver Giese
 */ 
#include "SoundRequest.h"

In& operator>>(In& stream,SoundRequest& soundRequest)
{
  stream.read(&soundRequest,sizeof(SoundRequest));
  return stream;
}

Out& operator<<(Out& stream,const SoundRequest& soundRequest)
{
  stream.write(&soundRequest,sizeof(SoundRequest));
  return stream;
}


/*
 * Change log :
 * 
 * $Log: SoundRequest.cpp,v $
 * Revision 1.1  2003/10/07 10:09:36  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2002/09/10 15:26:41  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.1  2002/04/28 19:09:52  giese
 * SoundPlay added...
 *
 *
 *
 */
