/**
* @file SensorDataBuffer.cpp
*
* Implementation of class SensorDataBuffer
*
* @author Max Risler
*/

#include "SensorDataBuffer.h"

SensorDataBuffer::SensorDataBuffer() :
  numOfFrames(0)
{
}

/*
In& operator>>(In& stream,SensorDataBuffer& sensorDataBuffer)
{
  stream >> sensorDataBuffer.numOfFrames;
  for (int i=0;i<sensorDataBuffer.numOfFrames;i++)
  {
    stream >> sensorDataBuffer.frame[i];
  }
  return stream;
}
*/
  
/**
 * Streaming operator that writes a SensorDataBuffer to a stream.
 * @param stream The stream to write on.
 * @param sensorDataBuffer The SensorDataBuffer object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const SensorDataBuffer& sensorDataBuffer)
{
  stream << sensorDataBuffer.numOfFrames;
  for (int i=0;i<sensorDataBuffer.numOfFrames;i++)
  {
    stream << sensorDataBuffer.frame[i];
  }
  return stream;
}

/*
 * Change log :
 * 
 * $Log: SensorDataBuffer.cpp,v $
 * Revision 1.1  2003/10/07 10:09:36  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2003/05/02 18:45:40  risler
 * SensorDataBuffer added
 * replaced SensorData with SensorDataBuffer
 * full SensorData resolution now accessible
 *
*/
