/**
 * @file PlayersPercept.cpp
 *
 * Implementation of class PlayersPercept.
 */

#include "PlayersPercept.h"


PlayersPercept::PlayersPercept()
{
  reset(0);
}


PlayersPercept::~PlayersPercept()
{
}


void PlayersPercept::reset(unsigned long frameNumber)
{
  this->frameNumber = frameNumber;
  numberOfRedPlayers=0;
  numberOfBluePlayers=0;
}


void PlayersPercept::addRedPlayer(const SinglePlayerPercept& percept)
{
  if(numberOfRedPlayers < maxNumberOfRedPlayerPercepts)
    redPlayers[numberOfRedPlayers++] = percept;
}


void PlayersPercept::addBluePlayer(const SinglePlayerPercept& percept)
{
  if(numberOfRedPlayers < maxNumberOfBluePlayerPercepts)
    bluePlayers[numberOfBluePlayers++] = percept;
}


In& operator>>(In& stream,PlayersPercept& playersPercept)
{
  stream >> playersPercept.frameNumber;
  int i;
  stream >> playersPercept.numberOfBluePlayers;
  stream >> playersPercept.numberOfRedPlayers;
  for(i=0; i<playersPercept.numberOfBluePlayers; i++)
  {
    stream.read(&playersPercept.bluePlayers[i], sizeof(SinglePlayerPercept));
  }
  for(i=0; i<playersPercept.numberOfRedPlayers; i++)
  {
    stream.read(&playersPercept.redPlayers[i], sizeof(SinglePlayerPercept));
  }

  return stream;
}

 
Out& operator<<(Out& stream, const PlayersPercept& playersPercept)
{
  stream << playersPercept.frameNumber;
  int i;
  stream << playersPercept.numberOfBluePlayers;
  stream << playersPercept.numberOfRedPlayers;
  for(i=0; i<playersPercept.numberOfBluePlayers; i++)
  {
    stream.write(&playersPercept.bluePlayers[i], sizeof(SinglePlayerPercept));
  }
  for(i=0; i<playersPercept.numberOfRedPlayers; i++)
  {
    stream.write(&playersPercept.redPlayers[i], sizeof(SinglePlayerPercept));
  }

  return stream;
}

/*
 * Change log :
 * 
 * $Log: PlayersPercept.cpp,v $
 * Revision 1.3  2004/01/19 14:53:46  dueffert
 * all frameNumbers (and not only some of them) are unsigned long now
 *
 * Revision 1.2  2003/11/12 16:19:35  goehring
 * frameNumber added to percepts
 *
 * Revision 1.1  2003/10/07 10:09:36  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2003/03/26 09:46:06  roefer
 * LinesImageProcessor2 generates player percepts
 *
 * Revision 1.2  2002/09/17 23:55:20  loetzsch
 * - unraveled several datatypes
 * - changed the WATCH macro
 * - completed the process restructuring
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.6  2002/04/02 13:10:18  dueffert
 * big change: odometryData and cameraMatrix in image now, old logfiles may be obsolete
 *
 * Revision 1.5  2001/12/17 00:16:55  tim
 * validity hinzugefgt
 *
 * Revision 1.4  2001/12/15 18:21:39  tim
 * PlayersPercept fertig (voererst ;-)
 *
 * Revision 1.3  2001/12/10 17:47:06  risler
 * change log added
 *
 */
