/**
 * @file LowResImage.h
 * 
 * Declaration of class LowResImage
 *
 * @author Max Risler
 */ 

#ifndef __LowResImage_h_
#define __LowResImage_h_

#include "Image.h"

class LowResImage;

/**
 * Streaming operator that writes a low resolution image to a stream.
 * @param stream The stream to write on.
 * @param image The LowResImage object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream,const LowResImage& lrImage);

/**
 * Streaming operator that reads a low resolution image from a stream.
 * @param stream The stream to read from.
 * @param image The LowResImage object.
 * @return The stream.
 */ 
In& operator>>(In& stream,LowResImage& lrImage);

/**
 * Definition of a class for streaming images in low resolution i.e. without the three additional y channels.
 */
class LowResImage
{
  private:
    /**
    * A reference to the image
    */
    Image &image;

  public:
    /** 
     * Constructor.
     */
    LowResImage(Image& src) : image(src) {}

  friend Out& operator<<(Out& stream,const LowResImage& image);
  friend In& operator>>(In& stream,LowResImage& image);
};

#endif //__LowResImage_h_

/*
 * Change log :
 * 
 * $Log: LowResImage.h,v $
 * Revision 1.1  2004/04/07 13:00:44  risler
 * ddd checkin after go04 - second part
 *
 * Revision 1.1  2004/04/07 11:45:14  risler
 * added sending low res images
 * added Image::setCameraInfo
 *
 *
 */
