/**
 * @file LinesPercept.h
 * 
 * Declaration of class LinesPercept
 * @author <A href=mailto:juengel@informatik.hu-berlin.de>Matthias Juengel</A>
 */ 

#ifndef __LinesPercept_h_
#define __LinesPercept_h_


#include "Tools/Streams/InOut.h"
#include "Tools/Math/Vector2.h"

/**
* The class represents a percepted line on the field with its type and a Vector of points belonging to it.
*/
class LinesPercept
{
  public:
    enum LineType
    {
      field,
      border,
      yellowGoal, 
      skyblueGoal,
//      sideOfPenaltyArea,
      numberOfLineTypes,
      redRobot = numberOfLineTypes,
      blueRobot,
      ball,
      numberOfTypes
    }; /**< Defines the different kinds of lines. */
    enum {maxNumberOfPoints = 200}; /**< Specifies the maximum number of points per line type. */

    Vector2<int> points[numberOfTypes][maxNumberOfPoints]; /**< The points on lines. */
    int numberOfPoints[numberOfTypes]; /**< The number of points per line type. */
    unsigned long frameNumber; /**< The frame number when perceived. */
    /**
     * Constructor.
     */
    LinesPercept() {reset(0);}

    /**
     * The function empties the line percept.
     */
    void reset(unsigned long frameNumber);

    /**
     * The function adds a new point to the lines percept.
     * @param type The line type of the point.
     * @param point The point.
     */
    void add(LineType type,const Vector2<int>& point);
};

/**
 * Streaming operator that reads a LinesPercept from a stream.
 * @param stream The stream from which is read.
 * @param linesPercept The LinesPercept object.
 * @return The stream.
 */ 
In& operator>>(In& stream,LinesPercept& linesPercept);
 
/**
 * Streaming operator that writes a LinesPercept to a stream.
 * @param stream The stream to write on.
 * @param linesPercept The LinesPercept object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const LinesPercept& linesPercept);


#endif //__LinesPercept_h_

/*
 * Change log :
 * 
 * $Log: LinesPercept.h,v $
 * Revision 1.3  2004/01/19 14:53:46  dueffert
 * all frameNumbers (and not only some of them) are unsigned long now
 *
 * Revision 1.2  2003/11/12 16:19:35  goehring
 * frameNumber added to percepts
 *
 * Revision 1.1  2003/10/07 10:09:36  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/25 11:23:52  juengel
 * Removed BlobCollection.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.8  2003/03/22 11:06:25  roefer
 * Progress in LinesImageProcessor2
 *
 * Revision 1.7  2003/03/10 13:53:11  juengel
 * Prepared new type sideOfPenaltyArea
 *
 * Revision 1.6  2002/12/04 12:20:37  juengel
 * Changed the data type of the points in the LinesPercept from Vector2<double> to Vector2<int>.
 *
 * Revision 1.5  2002/11/27 13:54:07  dueffert
 * doxygen docu added
 *
 * Revision 1.4  2002/09/22 18:40:50  risler
 * added new math functions, removed GTMath library
 *
 * Revision 1.3  2002/09/19 12:05:49  loetzsch
 * MathLib -> Mathlib
 *
 * Revision 1.2  2002/09/17 23:55:20  loetzsch
 * - unraveled several datatypes
 * - changed the WATCH macro
 * - completed the process restructuring
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.4  2002/07/23 13:32:57  loetzsch
 * new streaming classes
 *
 * removed many #include statements
 *
 * Revision 1.3  2002/06/12 11:34:53  roefer
 * Improvements in LinesSelfLocator
 *
 * Revision 1.2  2002/06/02 23:21:08  roefer
 * Single color table and progress in LinesSelfLocator
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.5  2002/04/02 13:10:18  dueffert
 * big change: odometryData and cameraMatrix in image now, old logfiles may be obsolete
 *
 * Revision 1.4  2002/03/24 17:47:02  juengel
 * LinesPercept defined and LinesPerceptor added.
 *
 * Revision 1.3  2001/12/10 17:47:06  risler
 * change log added
 *
 */
