/**
 * @file LinesPercept.cpp
 *
 * Implementation of class LinesPercept.
 * @author <A href=mailto:juengel@informatik.hu-berlin.de>Matthias Juengel</A>
 */

#include "LinesPercept.h"

void LinesPercept::reset(unsigned long frameNumber)
{
  this->frameNumber = frameNumber;
  for(int i = 0; i < numberOfTypes; ++i)
    numberOfPoints[i] = 0;
}

void LinesPercept::add(LineType type,const Vector2<int>& point)
{
  if(numberOfPoints[type] < maxNumberOfPoints)
    points[type][numberOfPoints[type]++] = point;
}

In& operator>>(In& stream,LinesPercept& linesPercept)
{
  stream >> linesPercept.frameNumber;
  for(int i = 0; i < LinesPercept::numberOfTypes; ++i)
  {
    stream >> linesPercept.numberOfPoints[i];
    for(int j = 0; j < linesPercept.numberOfPoints[i]; j++)
      stream >> linesPercept.points[i][j].x >> linesPercept.points[i][j].y;
  }
  return stream;
}
 
Out& operator<<(Out& stream, const LinesPercept& linesPercept)
{
  stream << linesPercept.frameNumber;
  for(int i = 0; i < LinesPercept::numberOfTypes; ++i)
  {
    stream << linesPercept.numberOfPoints[i];
    for(int j = 0; j < linesPercept.numberOfPoints[i]; j++)
      stream << linesPercept.points[i][j].x << linesPercept.points[i][j].y;
  }
  return stream;
}

/*
 * Change log :
 * 
 * $Log: LinesPercept.cpp,v $
 * Revision 1.3  2004/01/19 14:53:46  dueffert
 * all frameNumbers (and not only some of them) are unsigned long now
 *
 * Revision 1.2  2003/11/12 16:19:35  goehring
 * frameNumber added to percepts
 *
 * Revision 1.1  2003/10/07 10:09:36  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.5  2003/03/22 11:06:25  roefer
 * Progress in LinesImageProcessor2
 *
 * Revision 1.4  2002/12/04 12:20:38  juengel
 * Changed the data type of the points in the LinesPercept from Vector2<double> to Vector2<int>.
 *
 * Revision 1.3  2002/09/22 18:40:50  risler
 * added new math functions, removed GTMath library
 *
 * Revision 1.2  2002/09/17 23:55:20  loetzsch
 * - unraveled several datatypes
 * - changed the WATCH macro
 * - completed the process restructuring
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.2  2002/06/02 23:21:08  roefer
 * Single color table and progress in LinesSelfLocator
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.6  2002/04/02 13:10:18  dueffert
 * big change: odometryData and cameraMatrix in image now, old logfiles may be obsolete
 *
 * Revision 1.5  2002/03/28 14:06:52  risler
 * numOfLines was uninitialized
 *
 * Revision 1.4  2002/03/24 17:47:02  juengel
 * LinesPercept defined and LinesPerceptor added.
 *
 * Revision 1.3  2001/12/10 17:47:06  risler
 * change log added
 *
 */
