/**
 * @file CalibrationRequest.cpp
 * 
 *
 * Implementation of class CalibrationRequest
 * 
 * @author Matthias Juengel
 */ 

#include "CalibrationRequest.h"

CalibrationRequest::CalibrationRequest() :
mode(none),
feedback(noFeedback)
{

}

CalibrationRequest::~CalibrationRequest()
{
}


In& operator>>(In& stream,CalibrationRequest& calibrationRequest)
{
  stream.read(&calibrationRequest,sizeof(CalibrationRequest));
  return stream;
}

Out& operator<<(Out& stream,const CalibrationRequest& calibrationRequest)
{
  stream.write(&calibrationRequest,sizeof(CalibrationRequest));
  return stream;
}


/*
 * Change log :
 * 
 * $Log: CalibrationRequest.cpp,v $
 * Revision 1.2  2004/03/21 12:46:28  juengel
 * CalibrationRequest distinguishes between "mode" and "feedback".
 *
 * Revision 1.1  2003/10/12 11:44:58  juengel
 * Added CalibrationRequest.
 *
 *
 */
