/**
 * @file BodyPercept.cpp
 *
 * Implementation of class BodyPercept.
 */

#include "BodyPercept.h"

BodyPercept::BodyPercept()
{
  state = undefined;
  switches = 0;
  tailPosition = tailCenterCenter;
  mouthState = mouthClosed;
  acceleration = Vector3<double>(0,0,0);
}

BodyPercept::~BodyPercept()
{
}

void BodyPercept::operator = (const BodyPercept& other)
{
  state = other.getState();
  switches = other.getSwitches();
  tailPosition = other.getTailPosition();
  mouthState = other.getMouthState();
  acceleration = other.acceleration;
}

In& operator>>(In& stream,BodyPercept& bodyPercept)
{
  stream >> bodyPercept.frameNumber;
  stream.read(&bodyPercept,sizeof(BodyPercept));
  return stream;
}
 
Out& operator<<(Out& stream, const BodyPercept& bodyPercept)
{
  stream << bodyPercept.frameNumber;
  stream.write(&bodyPercept,sizeof(BodyPercept));
  return stream;
}


/*
 * Change log :
 * 
 * $Log: BodyPercept.cpp,v $
 * Revision 1.3  2004/01/28 08:31:47  dueffert
 * acceleration added
 *
 * Revision 1.2  2003/11/14 19:02:25  goehring
 * frameNumber added
 *
 * Revision 1.1  2003/10/07 10:09:36  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2003/04/01 22:40:45  cesarz
 * added mouth states
 *
 * Revision 1.2  2003/01/30 11:26:47  juengel
 * Added tailPosition to bodyPercept
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.6  2002/02/23 16:37:15  risler
 * State in RobotState like BodyPercept state
 *
 * Revision 1.5  2002/02/05 03:30:52  loetzsch
 * replaced direct member access by
 * inline const VALUE& get...() const   and
 * inline void set...(const Value&) methods.
 *
 * Revision 1.4  2002/01/18 11:19:41  petters
 * data fields and access methods added
 *
 * Revision 1.3  2001/12/10 17:47:05  risler
 * change log added
 *
 */
