/**
* @file OdometryData.h
* Contains the OdometryData class.
*
* @author Max Risler
*/

#ifndef __OdometryData_h_
#define __OdometryData_h_

#include "Tools/Math/Pose2D.h"
#include "Tools/Streams/InOut.h"

/**
* OdometryData
* OdometryData contains an approximation of overall movement the robot has done.
* @attention Only use differences of OdometryData at different times.
* Position in mm
*/
class OdometryData : public Pose2D
{
public:
  OdometryData();
  ~OdometryData();
  
  bool operator==(const OdometryData& other) const 
  {
    return (const Pose2D&) *this == other;
  }
  
  bool operator!=(const OdometryData& other) const
  {return !(*this == other);}
};

/**
* Streaming operator that reads a OdometryData from a stream.
* @param stream The stream from which is read.
* @param odometryData The OdometryData object.
* @return The stream.
*/ 
In& operator>>(In& stream,OdometryData& odometryData);

/**
* Streaming operator that writes a OdometryData to a stream.
* @param stream The stream to write on.
* @param odometryData The OdometryData object.
* @return The stream.
*/ 
Out& operator<<(Out& stream, const OdometryData& odometryData);


#endif //__OdometryData_h_

/*
* Change log :
* 
* $Log: OdometryData.h,v $
* Revision 1.1  2003/10/07 10:07:01  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.4  2002/11/19 15:43:03  dueffert
* doxygen comments corrected
*
* Revision 1.3  2002/09/22 18:40:54  risler
* added new math functions, removed GTMath library
*
* Revision 1.2  2002/09/17 23:55:20  loetzsch
* - unraveled several datatypes
* - changed the WATCH macro
* - completed the process restructuring
*
* Revision 1.1  2002/09/10 15:26:40  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed Challenge Code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.2  2002/07/23 13:32:57  loetzsch
* new streaming classes
*
* removed many #include statements
*
* Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.10  2002/05/04 12:43:37  loetzsch
* The currently executed MotionRequest is now sent from the MotionControl
* to the BehaviorControl via the OdometryData structure
*
* Revision 1.9  2002/05/03 16:34:50  loetzsch
* added currentMotionRequest
*
* Revision 1.8  2002/04/23 10:38:30  risler
* renamed headOdometry to headState
*
* Revision 1.7  2002/04/18 10:25:31  roefer
* Bremen GO
*
* Revision 1.2  2001/12/01 21:21:59  roefer
* HeadOdometry used in simulation
*
* Revision 1.6  2002/04/02 13:10:18  dueffert
* big change: odometryData and cameraMatrix in image now, old logfiles may be obsolete
*
* Revision 1.5  2002/03/19 18:37:18  risler
* added neckHeight, stableMotion
*
* Revision 1.4  2001/12/13 14:14:39  risler
* OdometryData derived from Pose2D
*
* Revision 1.3  2001/12/10 17:47:06  risler
* change log added
*
*/
