/**
 * @file MotorCommands.h
 * Declaration of class MotorCommands
 *
 * @author <A href="mailto:roefer@tzi.de">Thomas Rfer</A>
 */ 

#ifndef __MotorCommands_h_
#define __MotorCommands_h_

#include "JointDataBuffer.h"
#include "LEDValue.h"
#include "PIDData.h"

/**
 * A class representing a motor commands vector. 
 */
class MotorCommands
{
public:
  /**
  * a buffer with joint data sets sent in one cycle
  */
  JointDataBuffer jointDataBuffer;

  /**
  * the current LED values
  */
  LEDValue ledValue;

  /**
  * the current PID values
  */
  PIDData pidData;

  /**
   * constructs a MotorCommands.
   */ 
  MotorCommands();

  /**
   * deconstructs a MotorCommands.
   */
  ~MotorCommands();

  /**
   * Fills the joint data buffer.
   * @param buffer The values that will be copied.
   */
  void setVector(const JointDataBuffer &buffer) {jointDataBuffer = buffer;}

  /**
   * Fills the led buffer.
   * @param led The values that will be copied.
   */
  void setLED(const LEDValue &led) {ledValue = led;}
};

/**
 * System-independent operator that reads motor commands from a stream.
 * @param stream The stream from which is read.
 * @param motorCommands The system independent motor commands object.
 * @return The stream.
 */ 
In& operator>>(In& stream,MotorCommands& motorCommands);

#endif //__MotorCommands_h_


/*
 * Change log :
 * 
 * $Log: MotorCommands.h,v $
 * Revision 1.1  2003/10/07 10:07:01  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2002/11/19 17:08:48  risler
 * added datatype PIDData
 * support for sending new pid values at runtime
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.4  2001/12/28 09:01:15  roefer
 * Streaming operator inserted
 *
 * Revision 1.3  2001/12/10 17:47:06  risler
 * change log added
 *
 */
