/**
* @file JointDataBuffer.cpp
*
* Implementation of class JointDataBuffer
*
* @author Martin Ltzsch
* @author Max Risler
*/

#include "JointDataBuffer.h"

JointDataBuffer::JointDataBuffer()
{
}

In& operator>>(In& stream,JointDataBuffer& jointDataBuffer)
{
  for (int i=0;i<jointDataBufferNumOfFrames;i++)
  {
    stream >> jointDataBuffer.frame[i];
  }
  return stream;
}
 
/**
 * Streaming operator that writes a JointDataBuffer to a stream.
 * @param stream The stream to write on.
 * @param jointDataBuffer The JointDataBuffer object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const JointDataBuffer& jointDataBuffer)
{
  for (int i=0;i<jointDataBufferNumOfFrames;i++)
  {
    stream << jointDataBuffer.frame[i];
  }
  return stream;
}

/*
 * Change log :
 * 
 * $Log: JointDataBuffer.cpp,v $
 * Revision 1.1  2003/10/07 10:07:01  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.3  2001/12/12 18:08:55  loetzsch
 * Streaming- Operatoren fr Bilder eingebaut, DebugKeyTable nicht- statisch gemacht, Debuggin Mechanismen weitergemacht, Bilder aus Logfiles in RobotControl anzeigen, Logfiles in HU1/Debug auf den Stick schreiben
 *
 * Revision 1.2  2001/12/10 17:47:05  risler
 * change log added
 *
 */
