/**
* @file HeadState.h
*
* Contains the HeadState class.
*
* @author <A href=mailto:dueffert@informatik.hu-berlin.de>Uwe Dffert</A>
*/

#ifndef __HeadState_h_
#define __HeadState_h_


#include "Tools/Streams/InOut.h"


/**
* HeadState
* HeadState contains neck height body tilt
*/
class HeadState
{
public:
  
/**
* neckHeight
* current height of neck joint in mm
  */
  double neckHeight;
  double bodyTilt,
         bodyRoll;

  /**
  * stableMotion
  * If this flag is false the robots current motion is instable
  * this means that position of robot is unknown so camera image should not be used
  * also current odometry values will be inaccurate. 
  */
  bool stableMotion;

  /**
  * headBlocked
  * If this flag is true headcontrol could not reach a position
  */
  bool headBlocked;
  bool calculated; /** head state is already calculated, don't change. */

  HeadState();
  ~HeadState();

  bool operator==(const HeadState& other) const
    {return neckHeight == other.neckHeight &&
            bodyTilt == other.bodyTilt &&
            bodyRoll == other.bodyRoll;}

  bool operator!=(const HeadState& other) const
    {return !(*this == other);}
};

/**
* Streaming operator that reads a HeadState from a stream.
* @param stream The stream from which is read.
* @param headState The HeadState object.
* @return The stream.
*/ 
In& operator>>(In& stream,HeadState& headState);

/**
* Streaming operator that writes a HeadState to a stream.
* @param stream The stream to write on.
* @param headState The HeadState object.
* @return The stream.
*/ 
Out& operator<<(Out& stream, const HeadState& headState);


#endif //__HeadState_h_

/*
* Change log :
* 
* $Log: HeadState.h,v $
* Revision 1.3  2004/03/20 09:55:27  roefer
* Preparation for improved odometry
*
* Revision 1.2  2004/03/18 23:35:43  hodie
* Some tests of the new HeadControlModes
*
* Revision 1.1  2003/10/07 10:07:01  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.5  2003/04/01 16:26:23  roefer
* Indention corrected
*
* Revision 1.4  2002/11/19 15:43:03  dueffert
* doxygen comments corrected
*
* Revision 1.3  2002/10/14 13:14:24  dueffert
* doxygen comments corrected
*
* Revision 1.2  2002/09/22 18:40:54  risler
* added new math functions, removed GTMath library
*
* Revision 1.1  2002/09/10 15:26:40  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed Challenge Code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.2  2002/07/23 13:32:57  loetzsch
* new streaming classes
*
* removed many #include statements
*
* Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.1  2002/04/23 14:08:03  risler
* renamed headOdometry to headState
*
* Revision 1.3  2002/04/18 10:25:31  roefer
* Bremen GO
*
* Revision 1.2  2001/12/01 21:21:59  roefer
* HeadOdometry used in simulation
*
* Revision 1.2  2002/04/08 17:49:40  risler
* removed body tilt from odometry
*
* Revision 1.1  2002/04/02 13:10:18  dueffert
* big change: odometryData and cameraMatrix in image now, old logfiles may be obsolete
*
*
*/
