/**
 * @file PlayerPoseCollection.cpp
 *
 * Implementation of class PlayerPoseCollection.
 */

#include "PlayerPoseCollection.h"

void PlayerPose::operator = (const PlayerPose& other)
{
  pose = other.pose;
  speed = other.speed;
  validity = other.validity;
  playerNumber = other.playerNumber;
  sigmaMin = other.sigmaMin;
  sigmaMaj = other.sigmaMaj;
  cosAngle = other.cosAngle;
  sinAngle = other.sinAngle;
}

PlayerPoseCollection::PlayerPoseCollection()
{
  this->numberOfOpponentPlayers = 0;
  this->numberOfOwnPlayers = 0;
}

PlayerPoseCollection::~PlayerPoseCollection()
{
}

PlayerPoseCollection::PlayerPoseCollection(PlayerPoseCollection& other)
{
  *this = other;
}

void PlayerPoseCollection::operator = (const PlayerPoseCollection& other)
{
  int i;
  for (i=0; i<other.numberOfOwnPlayers;i++)
  {
    setOwnPlayerPose(i,other.getOwnPlayerPose(i));
  }
  for (i=0; i<other.numberOfOpponentPlayers;i++)
  {
    setOpponentPlayerPose(i,other.getOpponentPlayerPose(i));
  }
  numberOfOwnPlayers = other.numberOfOwnPlayers;
  numberOfOpponentPlayers = other.numberOfOpponentPlayers;
}

In& operator>>(In& stream,PlayerPoseCollection& playerPoseCollection)
{
  int sizeOfPlayerPose;
  int i;
  sizeOfPlayerPose = sizeof(PlayerPose);
  stream >> playerPoseCollection.numberOfOpponentPlayers;
  stream >> playerPoseCollection.numberOfOwnPlayers;
  for(i=0; i < playerPoseCollection.numberOfOpponentPlayers; i++)
  {
    stream.read(&playerPoseCollection.opponentPlayerPoses[i], sizeOfPlayerPose);
  }
  for(i=0; i < playerPoseCollection.numberOfOwnPlayers; i++)
  {
    stream.read(&playerPoseCollection.ownPlayerPoses[i], sizeOfPlayerPose);
  }
  //  stream.read(&playerPoseCollection, sizeof(PlayerPoseCollection));
  return stream;
}


Out& operator<<(Out& stream, const PlayerPoseCollection& playerPoseCollection)
{
  int sizeOfPlayerPose;
  int i;
  sizeOfPlayerPose = sizeof(PlayerPose);
  stream << playerPoseCollection.numberOfOpponentPlayers;
  stream << playerPoseCollection.numberOfOwnPlayers;
  for(i=0; i < playerPoseCollection.numberOfOpponentPlayers; i++)
  {
    stream.write(&playerPoseCollection.opponentPlayerPoses[i], sizeOfPlayerPose);
  }
  for(i=0; i < playerPoseCollection.numberOfOwnPlayers; i++)
  {
    stream.write(&playerPoseCollection.ownPlayerPoses[i], sizeOfPlayerPose);
  }
  //  stream.write(&playerPoseCollection, sizeof(PlayerPoseCollection));
  return stream;
}


//Streamin operators for PlayerPose
In& operator>>(In& stream,PlayerPose& playerPose)
{
  stream.read(&playerPose,sizeof(PlayerPose));
  return stream;
}


Out& operator<<(Out& stream, const PlayerPose& playerPose)
{
  stream.write(&playerPose,sizeof(PlayerPose));
  return stream;
}


/*
 * Change log :
 * 
 * $Log: PlayerPoseCollection.cpp,v $
 * Revision 1.2  2003/12/06 17:45:33  loetzsch
 * replaced Player::playerRole (goalie, defender, striker1, striker2)
 * by Player::playerNumber (one, two, three, four)
 *
 * Revision 1.1  2003/10/07 10:07:01  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/03/16 20:15:12  thiel
 * changed set-methods from const double& to const double
 * operator= completed with missing attributs
 *
 * Revision 1.1  2002/09/10 15:26:39  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.7  2002/04/21 16:06:14  roefer
 * Fixed numbers replaced by counters in operator=
 *
 * Revision 1.6  2002/02/05 03:36:12  loetzsch
 * replaced direct member access by
 * inline const VALUE& get...() const   and
 * inline void set...(const Value&) methods.
 *
 * Revision 1.5  2002/01/15 10:15:30  kspiess
 * Streaming-Operatoren fr PlayerPose hinzugefgt
 *
 * Revision 1.4  2001/12/20 23:15:17  kspiess
 * PlayerPoseCollection implementiert
 *
 * Revision 1.3  2001/12/10 17:47:06  risler
 * change log added
 *
 */
