/**
 * @file LandmarksState.h
 * 
 * Declaration of class LandmarksState
 */ 

#ifndef __LandmarksState_h_
#define __LandmarksState_h_


#include "Tools/Streams/InOut.h"
#include "Representations/Perception/LandmarksPercept.h"

/**
 * A class describing detected landmarks
 */
class LandmarksState
{

public:

  /*
  bool frontLeftFlag, frontRightFlag;
  bool backLeftFlag, backRightFlag;
  bool ownGoal, opponentGoal;
  */

  bool flagVisible[Flag::numberOfFlagTypes];

  LandmarksState();

  void update (const LandmarksPercept& landmarksPercept);
  void reset();

	bool seenAnyFlag() const;

};

/**
 * Streaming operator that reads a LandmarksState from a stream.
 * @param stream The stream from which is read.
 * @param robotState The LandmarksState object.
 * @return The stream.
 */ 
In& operator>>(In& stream,LandmarksState& landmarksState);
 
/**
 * Streaming operator that writes a LandmarksState to a stream.
 * @param stream The stream to write on.
 * @param robotState The LandmarksState object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const LandmarksState& landmarksState);


#endif //__LandmarksState_h_

/*
 * Change log :
 * 
 */
