
#include "LandmarksState.h"

LandmarksState::LandmarksState()
{
  reset();
}

void LandmarksState::reset()
{
  for (int i=0; i<Flag::numberOfFlagTypes; i++) flagVisible[i] = false;
  /*
  this->frontLeftFlag = false;
  this->frontRightFlag = false;
  this->backLeftFlag = false;
  this->backRightFlag = false;
  this->ownGoal = false;
  this->opponentGoal = false;
  */
}

bool LandmarksState::seenAnyFlag() const
{
	bool ret=false;
	for (int i=0; i<Flag::numberOfFlagTypes; i++) ret = ret | flagVisible[i];
	return ret;
}

void LandmarksState::update(const LandmarksPercept& landmarksPercept)
{
  int i;
  for (i=0; i<Flag::numberOfFlagTypes; i++) flagVisible[i] = false;

  for (i=0; i<landmarksPercept.numberOfFlags; i++) flagVisible[landmarksPercept.flags[i].type] = true;
}

In& operator>>(In& stream,LandmarksState& landmarksState)
{
  for(int i=0; i<Flag::numberOfFlagTypes; i++) stream >> (char&)landmarksState.flagVisible[i];
  return stream;
}

Out& operator<<(Out& stream, const LandmarksState& landmarksState)
{
  for(int i=0; i<Flag::numberOfFlagTypes; i++) stream << (char)landmarksState.flagVisible[i];
  return stream;
}
