/** 
* @file Processes/CD/Debug.h
* 
* Declaration of class Debug.
*
* @author Martin Ltzsch
*/

#ifndef __Debug_h_
#define __Debug_h_

#include "Tools/Process.h"
#include "Tools/Debugging/QueueFillRequest.h"

/**
* @class Debug
* 
* A process for collection and distribution of debug messages.
*
* All messages from the processes to the PC are collected here and all messages from the 
* PC to the processes are distributed by the Debug process.
*
* @author Martin Ltzsch
*/
class Debug : public Process
{
private:
  DEBUGGING;
  DEBUG_RECEIVER(Cognition);
  DEBUG_SENDER(Cognition);

public:
  /** Constructor */
  Debug();

  /** Destructor */
  ~Debug();
  
  /** The main function of the process */
  int main();

  /** Is called before the first main() */
  virtual void init();

  /** 
  * Is called for every incoming debug message.
  * @param message the message to handle
  * @return if the message was handled
  */
  virtual bool handleMessage(InMessage& message);

  /**
  * The QueueFillMode for the outgoing Queue
  */
  QueueFillRequest::QueueFillMode mode;
	
  /**
  * The time when the outgoing queue is written to the stick or allowed to be accessed via wlan
  */
  unsigned long saveOrSendTime;

private:
  /**
  * this is used to read messages from a file called requests.dat
  */
  InBinaryFile* fin;

  /** If true, a message was received from the WLan or OVirtualRobotComm */
  bool messageWasReceived;
};

#endif // __Debug_h_

/*
 * Change log :
 * 
 * $Log: Debug.h,v $
 * Revision 1.2  2003/11/29 07:40:19  roefer
 * Doxygen comments corrected
 *
 * Revision 1.1  2003/10/27 19:02:20  loetzsch
 * no message
 *
 */
