/** 
* @file  Platform/Win32/SystemCall.h
* @brief static class for system calls from the non NDA classes
* @attention the implementation is system specific! Only definitions here
*
* @author <A href=mailto:brunn@sim.informatik.tu-darmstadt.de>Ronnie Brunn</A>
* @author <A href=mailto:risler@sim.informatik.tu-darmstadt.de>Max Risler</A>
*/

#ifndef	_SYSTEMCALL_H_
#define	_SYSTEMCALL_H_

class RobotDesign
{
public:
  /**
  * The design of the robot.
  */
  enum Design 
  {
    UNKNOWN,
    ERS210, 
    ERS7
  };
};

/**
* static class for system calls
* @attention the implementation is system specific!
*/
class SystemCall
{
public:
  /** returns the current system time in milliseconds
  */
  static unsigned long getCurrentSystemTime ();
  
  /** returns the time since aTime
  */
  static unsigned long getTimeSince (unsigned long aTime) {
    return (getCurrentSystemTime() - aTime);
  }

  /** returns the amount of remaining battery power in percent
    * or 100 if the system is attached to powerline
    */
  static unsigned char getRemainingPower();
  
  /** returns the amount of free (virtual) memory
    */
  static unsigned long getFreeMem();

  /** reboots the system */
  static void reboot();

  /** shuts the system down */
  static void shutdown();

  /** returns the robot's mac address */
  static void getMacAddress(unsigned char address[6]);

  /** returns the robot's design */
  static RobotDesign::Design getRobotDesign();
};


#endif // _SYSTEMCALL_H_

/*
 * Change log :
 * 
 * $Log: SystemCall.h,v $
 * Revision 1.2  2003/12/31 12:21:25  roefer
 * getRobotDesign added
 *
 * Revision 1.1  2003/10/07 10:06:59  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.5  2003/05/03 13:05:49  roefer
 * getMacAddress added
 *
 * Revision 1.4  2002/12/11 15:17:26  dueffert
 * getRemainingPower(), shutdown(), reboot() implemented
 *
 * Revision 1.3  2002/12/04 13:43:42  dueffert
 * getFreeMem() implemented
 *
 * Revision 1.2  2002/11/27 13:47:21  dueffert
 * doxygen docu added
 *
 * Revision 1.1  2002/09/10 15:40:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1.1.1  2002/05/10 12:40:18  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.3  2001/12/10 17:47:08  risler
 * change log added
 *
 */
