/** 
 * @file Platform/Win32/Sender.cpp
 *
 * This file implements classes related to senders.
 *
 * @author <A href=mailto:roefer@tzi.de>Thomas Rfer</A>
 */
#include "Platform/ProcessFramework.h"

SenderList::SenderList(PlatformProcess* p,const char* senderName,bool blocking)
{
  // copy the sender's name. The name of the process is still missing.
  process = p;
  eventId = process->getNextId();
  strcpy(this->name,senderName);
  if(getFirst())
  {
    SenderList* p = getFirst();
    while(p->next)
      p = p->next;
    p->next = this;
  }
  else
    getFirst() = this;
  next = 0;
  this->blocking = blocking;
}

SenderList*& SenderList::getFirst()
{
  return process->getFirstSender();
}

void SenderList::finishFrame()
{
  for(SenderList* p = getFirst(); p; p = p->getNext())
    p->sendPackage();
}

void SenderList::checkAllForRequests()
{
  for(SenderList* p = getFirst(); p; p = p->getNext())
    p->checkForRequest();
}

SenderList* SenderList::lookup(const char* processName,const char* senderName)
{
  for(SenderList* p = getFirst(); p; p = p->getNext())
  {
    char buf[80];
    ASSERT(strlen(processName) + strlen(p->name) + 1 < sizeof(buf));
    strcpy(buf,processName),
    strcat(buf,".");
    strcat(buf,p->name);
    if(!strcmp(buf,senderName))
      return p;
  }
  return 0;
}

/*
 * Change log :
 *
 * $Log: Sender.cpp,v $
 * Revision 1.1  2003/10/07 10:06:59  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2002/09/10 15:40:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1.1.1  2002/05/10 12:40:18  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.4  2002/01/14 22:50:28  loetzsch
 * SimRobot / RobotControl integration started
 *
 *
 * Revision 1.2  2001/12/10 17:47:08  risler
 * change log added
 *
 */
