/**
 * @file Platform/Win32/Receiver.cpp
 *
 * This file implements classes related to receivers.
 *
 * @author <A href=mailto:roefer@tzi.de>Thomas Rfer</A>
 */
#include "Platform/ProcessFramework.h"

ReceiverList::ReceiverList(PlatformProcess* p,const char* receiverName,bool blocking)
{
  process = p;
  eventId = process->getNextId();
  // copy the receiver's name. The name of the process is still missing.
  strcpy(this->name,receiverName);
  if(getFirst())
  {
    ReceiverList* p = getFirst();
    while(p->next)
      p = p->next;
    p->next = this;
  }
  else
    getFirst() = this;
  next = 0;
  this->blocking = blocking;
  package = 0;
}

ReceiverList*& ReceiverList::getFirst()
{
  return process->getFirstReceiver();
}

bool ReceiverList::receivedNew() const
{
  return (process->getEventMask() & 1 << eventId) != 0;
}

void ReceiverList::finishFrame()
{
  for(ReceiverList* p = getFirst(); p; p = p->getNext())
  {
    process->setBlockingId(p->eventId,p->blocking);
    if(p->receivedNew())
    {
      delete [] p->package;
      p->package = 0;
    }
  }
}

void ReceiverList::checkAllForPackages()
{
  for(ReceiverList* p = getFirst(); p; p = p->getNext())
    p->checkForPackage();
}

ReceiverList* ReceiverList::lookup(const char* processName,const char* receiverName)
{
  for(ReceiverList* p = getFirst(); p; p = p->getNext())
  {
    char buf[80];
    ASSERT(strlen(processName) + strlen(p->name) + 1 < sizeof(buf));
    strcpy(buf,processName),
    strcat(buf,".");
    strcat(buf,p->name);
    if(!strcmp(buf,receiverName))
      return p;
  }
  return 0;
}

/*
 * Change log :
 *
 * $Log: Receiver.cpp,v $
 * Revision 1.1  2003/10/07 10:06:59  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2002/09/10 15:40:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1.1.1  2002/05/10 12:40:18  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.4  2002/01/14 22:50:28  loetzsch
 * SimRobot / RobotControl integration started
 *
 *
 * Revision 1.2  2001/12/10 17:47:08  risler
 * change log added
 *
 */
