/**
* @file Platform/TCPHandler.h
*
* Inclusion of platform dependend process related classes and macros.
*
* @author <a href="mailto:robocup@m-wachter.de">Michael Wachter</a>
*/


// APERIOS
#ifdef APERIOS1_3_2
#include "Aperios1.3.2/TCPHandler.h"

#define EXTERNAL_DEBUGGING \
  NetReceiver<MessageQueue> theDebugReceiver; \
  NetDebugSender theDebugSender; \
  TCPHandler theTCPHandler;

#define INIT_EXTERNAL_DEBUGGING \
  Process(theDebugReceiver,theDebugSender), \
  theDebugReceiver(), \
  theDebugSender(), \
  theTCPHandler(theDebugSender,theDebugReceiver)

#define INIT_EXTERNAL_DEBUGGING_HANDLER theTCPHandler.listen(0xA1BD);
#endif


#ifdef APERIOS1_2_1
#define EXTERNAL_DEBUGGING DEBUGGING
#define INIT_EXTERNAL_DEBUGGING INIT_DEBUGGING
#define INIT_EXTERNAL_DEBUGGING_HANDLER 
#endif


// WINDOWS
#ifdef _WIN32
#define EXTERNAL_DEBUGGING DEBUGGING
#define INIT_EXTERNAL_DEBUGGING INIT_DEBUGGING
#define INIT_EXTERNAL_DEBUGGING_HANDLER 
#endif


/*
 * Change log :
 * 
 * $Log: TCPHandler.h,v $
 * Revision 1.3  2004/01/04 17:27:56  roefer
 * Adaptation to new communication scheme
 *
 * Revision 1.2  2004/01/03 16:19:12  wachter
 * debug-communication mostly working now
 *
 * Revision 1.1  2003/12/21 19:27:02  wachter
 * Added classes for Sender/Receiver over TCP and UDP.
 * ( PLEASE DO NOT USE THIS NOW ! )
 * *
 */
