/**
* @file Platform/MessageQueueBase.h
*
* Platform dependend inclusion of MessageQueueBase.h
*
* @author Martin Ltzsch
*/

#ifdef APERIOS1_2_1
#include "Aperios1.3.2/MessageQueueBase.h"
#define MESSAGEQUEUEBASE_INCLUDED
#endif

#ifdef APERIOS1_3_2
#include "Aperios1.3.2/MessageQueueBase.h"
#define MESSAGEQUEUEBASE_INCLUDED
#endif

#ifdef _WIN32
#include "Win32Linux/MessageQueueBase.h"
#define MESSAGEQUEUEBASE_INCLUDED
#endif

#ifdef LINUX
#include "Win32Linux/MessageQueueBase.h"
#define MESSAGEQUEUEBASE_INCLUDED
#endif

#ifdef CYGWIN
#include "Win32Linux/MessageQueueBase.h"
#define MESSAGEQUEUEBASE_INCLUDED
#endif

#ifndef MESSAGEQUEUEBASE_INCLUDED
#error Unknown platform
#endif

/*
 * Change log:
 * 
 * $Log: MessageQueueBase.h,v $
 * Revision 1.1  2003/10/07 10:06:58  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/05/05 11:56:56  dueffert
 * now using ifdef instead of if
 *
 * Revision 1.1  2002/09/10 15:40:04  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.3  2002/08/01 12:52:26  roefer
 * RouterCtrl and TcpConnection added
 *
 * Revision 1.2  2002/07/23 16:40:11  roefer
 * Router and SimGT2002 adapted to new message queue and streams
 *
 * Revision 1.1  2002/07/23 13:36:39  loetzsch
 * - exchanged StaticQueue by MessageQueue with platform dependend
 *   base classes
 *
 */
