/** 
* @file  Platform/Aperios1.3.2/UDPHandler.h
*
* Class for using NetSender/NetReceivers over UDP 
*
* @author <A href=mailto:robocup@m-wachter.de>Michael Wachter</A>
*
*
* The UDP-Handler sends data from NetSender's via an UDP based Protocol.
* If the data from the NetSender, the package, is too big for one
* UDP-Package (1500 bytes) the data is split into "subpackets".
* Each of this subpackets has the same packageNumber, an increasing
* subPackageNumber, the complete size and the data itself. (not implemented yet)
* With this information the receiving robot can put the data together into
* the right order and can find out package-loss.
* If the complete package is received the associated NetReceiver is called
* to stream the data.
*
*/


#ifndef	_UDPHandler_H_
#define	_UDPHandler_H_

/**
*
*/

#include "UDPEndpoint.h"
#include "DDPHandler.h"
#include "NetHandler.h"
#include "NetSender.h"
#include "NetReceiver.h"
#include "Tools/Player.h"
#include "NetConfig.h"

class UDPHandler;

class UDPHandlerEndpoint : public UDPEndpoint , public NetHandler
{
public:
	UDPHandlerEndpoint();
	~UDPHandlerEndpoint();
    virtual void onSendingDone();
  	virtual void onReceive(void* data, int size);
	virtual void sendPackage(int SenderNumber, void* package, int size);
	NetSenderBase* sender;
	NetReceiverBase* receiver;
	DDPHandler* ddpHandler;
	UDPHandler* udpHandler;
	int lastReceivedSerial;
	int sendSerial;
};


class UDPHandler 
{
  public:
    UDPHandler();
    ~UDPHandler(){};
	void addSenderAndReceiver(NetSenderBase& sender, NetReceiverBase& receiver);
    void start();
    void doRegularStuff();
	
  private:
	int numberOfEndpoints;

  private:
    UDPHandlerEndpoint endPoints[Player::numOfPlayerNumbers-1];
	DDPHandler ddpHandler;
};

#endif 

/*
 *
 * Changelog :
 *
 * $Log: UDPHandler.h,v $
 * Revision 1.6  2004/05/14 14:12:08  wachter
 * - Added communication support for 5 robots
 * - rewrote parts of team-communication to be faster and more stable
 *
 * Revision 1.5  2004/01/23 18:28:47  wachter
 * Added detection of lost packets
 *
 * Revision 1.4  2004/01/21 17:33:09  wachter
 * UDP Team-communication now working with packets<1400 bytes.
 * Not activated at the moment.
 *
 * Revision 1.3  2004/01/20 14:21:41  wachter
 * - Added sender-number to NetSender
 * - worked on with Team-Communication
 *
 * Revision 1.2  2004/01/09 15:44:30  wachter
 * Worked on with the Dog-Discovery-Protocol
 *
 * Revision 1.1  2003/12/21 19:27:03  wachter
 * Added classes for Sender/Receiver over TCP and UDP.
 * ( PLEASE DO NOT USE THIS NOW ! )
 *
 *
 */
