/** 
* @file  Platform/Aperios1.3.2/TCPEndpoint.h
*
* @author <A href=mailto:robocup@m-wachter.de>Michael Wachter</A>
*/

#ifndef	_TCPEndpoint_H_
#define	_TCPEndpoint_H_

/**
* static class for system calls
* @attention the implementation is system specific!
*/

#include "IPEndpoint.h"
#include <TCPEndpointMsg.h>

/**
 * handels a TCP-Connection 
 */
     
class TCPEndpoint : public IPEndpoint
{
    public:
       enum statusID
       {
         closed,
         connecting,
         connected,
         listening,
         sending,
         receiving,
         closing
       };

       TCPEndpoint(int sendBufferSize = 8192, int receiveBufferSize = 8192);
       TCPEndpoint(char* address,int port);
       ~TCPEndpoint();

       int listen(int port);                   /*< listens for incomming connection. onConnect is called if the connection is established */
       int connect(char* address, int port);   /*< connects to another host */
       int send(void* Data,int size);          /*< sends data (data should not be changed until onSendingDone is called) */
       int close();                            /*< close the connection */
              
       virtual void onConnect(void);
       virtual void onReceive(void* Data,int size);  /*< called when data is received */
       virtual void onClose(int reason);      /*< called when the connection ist closed by the other host */
       virtual void onSendingDone(void);      /*< called after all data from send() ist successfully send */
             
       const char* getErrorString(TCPEndpointError error);
                 
       virtual void listenCont(antEnvMsg* msg);
       virtual void sendCont(antEnvMsg* msg);
       virtual void receiveCont(antEnvMsg* msg);
       virtual void closeCont(antEnvMsg* msg);
       virtual void connectCont(antEnvMsg* msg);
 
       statusID getStatus(void) {return(status);};
    
    

    protected:
       IPAddress address;
       Port port;
       statusID status;
       void startReceiving();
       bool wasListening;
       int sizeOfDataToSend;
       void* sendDataBuffer;

    private:
       void sendSendMessage(int size);

};


// Class for testing 

class TestServer : public TCPEndpoint
{

public:

      TestServer():TCPEndpoint(){};
      virtual void onConnect(void)
      {
          char* hello = "I am an AIBO ERS-210 (Wau Wau). Who are you \n";
          this->send(hello,strlen(hello)+1);
      }

      virtual void onReceive(void* data, int size)
      {
        char antwort[255];
        char* data1 = (char*) data;
        data1[size] = 0;
        sprintf(antwort,"Hi %s \n",(char*) data1);
        
        if (data1[0]=='q')
        {
            close();
        }
        else
        {
            this->send(antwort,strlen(antwort));
        }
        
      }


    
};


#endif 

/*
 * Change log :
 * 
 * $Log: TCPEndpoint.h,v $
 * Revision 1.6  2004/01/26 13:44:07  wachter
 * shared-memory-buffers now have variable sizes
 *
 * Revision 1.5  2004/01/03 16:18:25  wachter
 * debug-communication mostly working now
 *
 * Revision 1.4  2003/12/21 19:27:03  wachter
 * Added classes for Sender/Receiver over TCP and UDP.
 * ( PLEASE DO NOT USE THIS NOW ! )
 *
 * Revision 1.3  2003/12/11 15:02:37  wachter
 * Low-level TCP and UDP functions for aperios now working.
 *
 * Revision 1.2  2003/12/03 14:35:51  kindler
 * Deleted obsolete UDPConnection
 *
 * Revision 1.1  2003/12/03 14:21:52  wachter
 * Splitted IPEndpoint.*
 *
 *
 */
