/**
 * @file Platform/Aperios1.3.2/SoundDataSender.h
 * This file contains a sender for sound data.
 */
#ifndef __SOUNDDATASENDER_H__
#define __SOUNDDATASENDER_H__

#ifndef __ProcessFramework_h__
#error Never include this file directly. Include ProcessFramework.h instead.
#endif

#include "Platform/ProcessFramework.h"
#include "Representations/Sound/SoundData.h"
#include <OPENR/OPENRAPI.h>

/**
 * This class implements a sender for sound data.
 */
class SoundDataSender : public SenderBase<SoundData>
{
  private:
    MemoryRegionID memID[2]; /**< The memory regions of the two package instances. */
    OSoundVectorData* soundVec[2]; /**< Pointers to the data in the packages. */
    RCRegion* package[2]; /**< The two instances of the packages. */
    int index; /**< The index of the next package. */

    /**
     * The function fills a package with data.
     * @param i The index of the package (0 or 1).
     */
    void prepare(int i);

  protected:
    /**
     * The function prepares a package.
     */
    virtual void preparePackage();

    /**
     * The functions sets a package for a receiver.
     * @param receiver The receive the package will be sent to.
     */
    virtual void setPackage(const ObserverID& receiver);

    /**
     * The function frees the package.
     */
    virtual void freePackage();

  public:
    /**
     * The constructor.
     * @param process The process this sender is associated with.
     * @param blocking Decides whether this sender blocks the execution of the next frame
     *                 until all connected receivers have requested a new package.
     */
    SoundDataSender(PlatformProcess* process,bool blocking);

    /**
     * Destructor.
     */
    ~SoundDataSender();
};

/**
 * The macro declares a sender for sound data.
 * It must be used inside a declaration of a process, after the macro DEBUGGING.
 */
#define SENDER_SOUNDDATA \
  SoundDataSender theSoundDataSender

/**
 * The macro instantiates a sender for sound data.
 * @param blocking Decides whether this sender blocks the execution of the next frame
 *                 until all connected receivers have requested a new package.
 */
#define INIT_SENDER_SOUNDDATA(blocking) \
  theSoundDataSender(this,blocking)

#endif

/*
 * Change log :
 * 
 * $Log: SoundDataSender.h,v $
 * Revision 1.1  2003/10/07 10:06:59  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 15:30:28  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2002/12/02 11:00:13  dueffert
 * doxygen docu corrected
 *
 * Revision 1.1  2002/11/28 14:22:01  hebbel
 * added SoundDataSender
 *
 * Revision 1.1  2002/07/13 10:54:58  roefer
 * New command and sound sender
 *
 *
 *
*/
