/** 
* @file  Platform/Aperios1.3.2/NetReceiver.h
*
* receiver-class for communication over wireless lan. 
*
* @author <A href=mailto:robocup@m-wachter.de>Michael Wachter</A>
*/

#ifndef	_NetReceiver_H_
#define	_NetReceiver_H_

/**
 * class NetReceiverBase - Template-Independent part of the NetReceiver
 * handles memory-acclocation
 */

class NetReceiverBase
{
  public:
    NetReceiverBase()
    {
       package = NULL;
       receivedNewPackage = false;
       size=0;
    }

    ~NetReceiverBase()
    { 
       freePackage();
    }

    virtual void onReceive() = 0;

    bool receivedNew()
    {  
     
       return (receivedNewPackage);
    }


    /**
     * gets memory for the NetHandler to store the data
     * the NetReceiver then calls the streaming-operator 
     * for this data.
     */
    void* getPackage(int newsize)
    {
      if (newsize>size)
      {
         cout << "NetReceiver::getPackage " << newsize << "\n" << flush;
         if (package) free(package);
         package = malloc(newsize);
         size=newsize;
         ASSERT(package);
      }
      return (package);
    }

    /**
     * frees the memory allocated by getPackage 
     */
    void freePackage()
    {
       free(package); 
       package = NULL;
       size=0;
       receivedNewPackage = false;
    }

  public:
     bool receivedNewPackage;
     void* package;
     int size;
};


/**
 * Class NetReciever. 
 * Template-Class to read a package from network and call the 
 * streaming-operator for it. 
 */

template<class T> class NetReceiver : public T, public NetReceiverBase
{
   public:
     virtual void onReceive()
     {
        // cout << "NetReceiver::onReceive() : received " << size << " bytes";

        /*unsigned char* ptr = (unsigned char*) package;
       
         printf("%02x - %02x %02x %02x %02x - %02x - %02x %02x %02x %02x \n", 
            ptr[0], 
            ptr[1],ptr[2],ptr[3],ptr[4], 
            ptr[5],
            ptr[6],ptr[7],ptr[8],ptr[9]);*/
       
        InBinaryMemory stream(package,size);
        T& data = *static_cast<T*>(this);
        stream >> data;
        receivedNewPackage = true;
     }             
};

#endif 

/*
 *
 * Changelog :
 *
 * $Log: NetReceiver.h,v $
 * Revision 1.8  2004/05/14 14:12:08  wachter
 * - Added communication support for 5 robots
 * - rewrote parts of team-communication to be faster and more stable
 *
 * Revision 1.7  2004/01/21 17:33:08  wachter
 * UDP Team-communication now working with packets<1400 bytes.
 * Not activated at the moment.
 *
 * Revision 1.6  2004/01/19 17:09:31  wachter
 * Bugfix
 *
 * Revision 1.5  2004/01/16 16:23:58  wachter
 * Bugfixes
 *
 * Revision 1.4  2004/01/06 10:01:14  wachter
 * Added comments
 *
 * Revision 1.3  2004/01/03 18:57:50  wachter
 * Debug-communication working now
 *
 * Revision 1.2  2004/01/03 16:18:25  wachter
 * debug-communication mostly working now
 *
 * Revision 1.1  2003/12/21 19:27:03  wachter
 * Added classes for Sender/Receiver over TCP and UDP.
 * ( PLEASE DO NOT USE THIS NOW ! )
 *
 *
 */
